/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.impl;

import android.content.Context;
import android.util.Log;
import android.util.Rational;
import android.view.WindowManager;
import androidx.annotation.RestrictTo;
import androidx.camera.camera2.impl.Camera2CaptureOptionUnpacker;
import androidx.camera.camera2.impl.Camera2SessionOptionUnpacker;
import androidx.camera.core.CameraFactory;
import androidx.camera.core.CameraX;
import androidx.camera.core.CaptureConfig;
import androidx.camera.core.ConfigProvider;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageAnalysisConfig;
import androidx.camera.core.SessionConfig;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class ImageAnalysisConfigProvider
implements ConfigProvider<ImageAnalysisConfig> {
    private static final String TAG = "ImageAnalysisProvider";
    private static final Rational DEFAULT_ASPECT_RATIO_4_3 = new Rational(4, 3);
    private static final Rational DEFAULT_ASPECT_RATIO_3_4 = new Rational(3, 4);
    private final CameraFactory mCameraFactory;
    private final WindowManager mWindowManager;

    public ImageAnalysisConfigProvider(CameraFactory cameraFactory, Context context) {
        this.mCameraFactory = cameraFactory;
        this.mWindowManager = (WindowManager)context.getSystemService("window");
    }

    public ImageAnalysisConfig getConfig(CameraX.LensFacing lensFacing) {
        ImageAnalysisConfig.Builder builder = ImageAnalysisConfig.Builder.fromConfig((ImageAnalysisConfig)ImageAnalysis.DEFAULT_CONFIG.getConfig(lensFacing));
        SessionConfig.Builder sessionBuilder = new SessionConfig.Builder();
        sessionBuilder.setTemplateType(1);
        builder.setDefaultSessionConfig(sessionBuilder.build());
        builder.setSessionOptionUnpacker((SessionConfig.OptionUnpacker)Camera2SessionOptionUnpacker.INSTANCE);
        CaptureConfig.Builder captureBuilder = new CaptureConfig.Builder();
        captureBuilder.setTemplateType(1);
        builder.setDefaultCaptureConfig(captureBuilder.build());
        builder.setCaptureOptionUnpacker((CaptureConfig.OptionUnpacker)Camera2CaptureOptionUnpacker.INSTANCE);
        try {
            CameraX.LensFacing checkedLensFacing = lensFacing != null ? lensFacing : CameraX.getDefaultLensFacing();
            String defaultId = this.mCameraFactory.cameraIdForLensFacing(checkedLensFacing);
            if (defaultId != null) {
                builder.setLensFacing(checkedLensFacing);
            }
            int targetRotation = this.mWindowManager.getDefaultDisplay().getRotation();
            int rotationDegrees = CameraX.getCameraInfo((String)defaultId).getSensorRotationDegrees(targetRotation);
            boolean isRotateNeeded = rotationDegrees == 90 || rotationDegrees == 270;
            builder.setTargetRotation(targetRotation);
            builder.setTargetAspectRatioCustom(isRotateNeeded ? DEFAULT_ASPECT_RATIO_3_4 : DEFAULT_ASPECT_RATIO_4_3);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Unable to determine default lens facing for ImageAnalysis.", (Throwable)e);
        }
        return builder.build();
    }
}

