/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.impl;

import android.graphics.PointF;
import android.graphics.Rect;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.MeteringRectangle;
import android.os.Build;
import android.util.Rational;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.camera.camera2.Camera2Config;
import androidx.camera.camera2.impl.Camera2CameraControl;
import androidx.camera.core.CaptureConfig;
import androidx.camera.core.Config;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.MeteringPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class FocusMeteringControl {
    private static final String TAG = "FocusMeteringControl";
    private final Camera2CameraControl mCameraControl;
    final Executor mExecutor;
    private final ScheduledExecutorService mScheduler;
    private FocusMeteringAction mCurrentFocusMeteringAction;
    private boolean mIsInAfAutoMode = false;
    Integer mCurrentAfState = 0;
    private ScheduledFuture<?> mAutoCancelHandle;
    long mFocusTimeoutCounter = 0L;
    Camera2CameraControl.CaptureResultListener mSessionListenerForFocus = null;
    private MeteringRectangle[] mAfRects = new MeteringRectangle[0];
    private MeteringRectangle[] mAeRects = new MeteringRectangle[0];
    private MeteringRectangle[] mAwbRects = new MeteringRectangle[0];

    FocusMeteringControl(@NonNull Camera2CameraControl cameraControl, Executor executor, ScheduledExecutorService scheduler) {
        this.mCameraControl = cameraControl;
        this.mExecutor = executor;
        this.mScheduler = scheduler;
    }

    @WorkerThread
    void addFocusMeteringOptions(@NonNull Camera2Config.Builder configBuilder) {
        int afMode = this.mIsInAfAutoMode ? 1 : 4;
        configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AF_MODE, this.mCameraControl.getSupportedAfMode(afMode));
        if (this.mAfRects.length != 0) {
            configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AF_REGIONS, this.mAfRects);
        }
        if (this.mAeRects.length != 0) {
            configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AE_REGIONS, this.mAeRects);
        }
        if (this.mAwbRects.length != 0) {
            configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AWB_REGIONS, this.mAwbRects);
        }
    }

    @WorkerThread
    private PointF getFOVAdjustedPoint(@NonNull MeteringPoint meteringPoint, @NonNull Rational cropRegionAspectRatio, @NonNull Rational defaultAspectRatio) {
        Rational fovAspectRatio = defaultAspectRatio;
        if (meteringPoint.getFOVAspectRatio() != null) {
            fovAspectRatio = meteringPoint.getFOVAspectRatio();
        }
        PointF adjustedPoint = new PointF(meteringPoint.getNormalizedCropRegionX(), meteringPoint.getNormalizedCropRegionY());
        if (!fovAspectRatio.equals((Object)cropRegionAspectRatio)) {
            if (fovAspectRatio.compareTo(cropRegionAspectRatio) > 0) {
                float heightOfCropRegion = (float)(fovAspectRatio.doubleValue() / cropRegionAspectRatio.doubleValue());
                float top_padding = (float)(((double)heightOfCropRegion - 1.0) / 2.0);
                adjustedPoint.y = (top_padding + adjustedPoint.y) * (1.0f / heightOfCropRegion);
            } else {
                float widthOfCropRegion = (float)(cropRegionAspectRatio.doubleValue() / fovAspectRatio.doubleValue());
                float left_padding = (float)(((double)widthOfCropRegion - 1.0) / 2.0);
                adjustedPoint.x = (left_padding + adjustedPoint.x) * (1.0f / widthOfCropRegion);
            }
        }
        return adjustedPoint;
    }

    @WorkerThread
    private MeteringRectangle getMeteringRect(MeteringPoint meteringPoint, PointF adjustedPoint, Rect cropRegion) {
        int centerX = (int)((float)cropRegion.left + adjustedPoint.x * (float)cropRegion.width());
        int centerY = (int)((float)cropRegion.top + adjustedPoint.y * (float)cropRegion.height());
        int width = (int)(meteringPoint.getSize() * (float)cropRegion.width());
        int height = (int)(meteringPoint.getSize() * (float)cropRegion.height());
        Rect focusRect = new Rect(centerX - width / 2, centerY - height / 2, centerX + width / 2, centerY + height / 2);
        focusRect.left = this.rangeLimit(focusRect.left, cropRegion.right, cropRegion.left);
        focusRect.right = this.rangeLimit(focusRect.right, cropRegion.right, cropRegion.left);
        focusRect.top = this.rangeLimit(focusRect.top, cropRegion.bottom, cropRegion.top);
        focusRect.bottom = this.rangeLimit(focusRect.bottom, cropRegion.bottom, cropRegion.top);
        int weight = (int)(meteringPoint.getWeight() * 1000.0f);
        weight = this.rangeLimit(weight, 1000, 0);
        return new MeteringRectangle(focusRect, weight);
    }

    @WorkerThread
    private int rangeLimit(int val, int max, int min) {
        return Math.min(Math.max(val, min), max);
    }

    @WorkerThread
    void startFocusAndMetering(@NonNull FocusMeteringAction action, @Nullable Rational defaultAspectRatio) {
        MeteringRectangle meteringRectangle;
        PointF adjustedPoint;
        if (this.mCurrentFocusMeteringAction != null) {
            this.cancelFocusAndMetering();
        }
        this.mCurrentFocusMeteringAction = action;
        Rect cropSensorRegion = this.mCameraControl.getCropSensorRegion();
        Rational cropRegionAspectRatio = new Rational(cropSensorRegion.width(), cropSensorRegion.height());
        if (defaultAspectRatio == null) {
            defaultAspectRatio = cropRegionAspectRatio;
        }
        ArrayList<MeteringRectangle> meteringRectanglesListAF = new ArrayList<MeteringRectangle>();
        ArrayList<MeteringRectangle> meteringRectanglesListAE = new ArrayList<MeteringRectangle>();
        ArrayList<MeteringRectangle> meteringRectanglesListAWB = new ArrayList<MeteringRectangle>();
        for (MeteringPoint meteringPoint : action.getMeteringPointsAF()) {
            adjustedPoint = this.getFOVAdjustedPoint(meteringPoint, cropRegionAspectRatio, defaultAspectRatio);
            meteringRectangle = this.getMeteringRect(meteringPoint, adjustedPoint, cropSensorRegion);
            meteringRectanglesListAF.add(meteringRectangle);
        }
        for (MeteringPoint meteringPoint : action.getMeteringPointsAE()) {
            adjustedPoint = this.getFOVAdjustedPoint(meteringPoint, cropRegionAspectRatio, defaultAspectRatio);
            meteringRectangle = this.getMeteringRect(meteringPoint, adjustedPoint, cropSensorRegion);
            meteringRectanglesListAE.add(meteringRectangle);
        }
        for (MeteringPoint meteringPoint : action.getMeteringPointsAWB()) {
            adjustedPoint = this.getFOVAdjustedPoint(meteringPoint, cropRegionAspectRatio, defaultAspectRatio);
            meteringRectangle = this.getMeteringRect(meteringPoint, adjustedPoint, cropSensorRegion);
            meteringRectanglesListAWB.add(meteringRectangle);
        }
        this.executeMeteringAction(meteringRectanglesListAF.toArray(new MeteringRectangle[meteringRectanglesListAF.size()]), meteringRectanglesListAE.toArray(new MeteringRectangle[meteringRectanglesListAE.size()]), meteringRectanglesListAWB.toArray(new MeteringRectangle[meteringRectanglesListAWB.size()]), action);
    }

    @WorkerThread
    private int getDefaultTemplate() {
        return 1;
    }

    @WorkerThread
    void triggerAf() {
        CaptureConfig.Builder builder = new CaptureConfig.Builder();
        builder.setTemplateType(this.getDefaultTemplate());
        builder.setUseRepeatingSurface(true);
        Camera2Config.Builder configBuilder = new Camera2Config.Builder();
        configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AF_TRIGGER, 1);
        builder.addImplementationOptions((Config)configBuilder.build());
        this.mCameraControl.submitCaptureRequestsInternal(Collections.singletonList(builder.build()));
    }

    @WorkerThread
    void triggerAePrecapture() {
        CaptureConfig.Builder builder = new CaptureConfig.Builder();
        builder.setTemplateType(this.getDefaultTemplate());
        builder.setUseRepeatingSurface(true);
        Camera2Config.Builder configBuilder = new Camera2Config.Builder();
        configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, 1);
        builder.addImplementationOptions((Config)configBuilder.build());
        this.mCameraControl.submitCaptureRequestsInternal(Collections.singletonList(builder.build()));
    }

    @WorkerThread
    void cancelAfAeTrigger(boolean cancelAfTrigger, boolean cancelAePrecaptureTrigger) {
        CaptureConfig.Builder builder = new CaptureConfig.Builder();
        builder.setUseRepeatingSurface(true);
        builder.setTemplateType(this.getDefaultTemplate());
        Camera2Config.Builder configBuilder = new Camera2Config.Builder();
        if (cancelAfTrigger) {
            configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AF_TRIGGER, 2);
        }
        if (Build.VERSION.SDK_INT >= 23 && cancelAePrecaptureTrigger) {
            configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, 2);
        }
        builder.addImplementationOptions((Config)configBuilder.build());
        this.mCameraControl.submitCaptureRequestsInternal(Collections.singletonList(builder.build()));
    }

    @WorkerThread
    private void disableAutoCancel() {
        if (this.mAutoCancelHandle != null) {
            this.mAutoCancelHandle.cancel(true);
            this.mAutoCancelHandle = null;
        }
    }

    @WorkerThread
    void executeMeteringAction(@Nullable MeteringRectangle[] afRects, @Nullable MeteringRectangle[] aeRects, @Nullable MeteringRectangle[] awbRects, final FocusMeteringAction focusMeteringAction) {
        this.mCameraControl.removeCaptureResultListener(this.mSessionListenerForFocus);
        this.disableAutoCancel();
        this.mAfRects = afRects == null ? new MeteringRectangle[0] : afRects;
        this.mAeRects = aeRects == null ? new MeteringRectangle[0] : aeRects;
        this.mAwbRects = awbRects == null ? new MeteringRectangle[0] : awbRects;
        if (this.shouldTriggerAF()) {
            this.mCurrentAfState = 0;
            if (focusMeteringAction.getOnAutoFocusListener() != null) {
                this.mSessionListenerForFocus = new Camera2CameraControl.CaptureResultListener(){

                    @Override
                    @WorkerThread
                    public boolean onCaptureResult(@NonNull TotalCaptureResult result) {
                        Integer afState = (Integer)result.get(CaptureResult.CONTROL_AF_STATE);
                        if (afState == null) {
                            return false;
                        }
                        if (FocusMeteringControl.this.mCurrentAfState == 3) {
                            if (afState == 4) {
                                focusMeteringAction.notifyAutoFocusCompleted(true);
                                return true;
                            }
                            if (afState == 5) {
                                focusMeteringAction.notifyAutoFocusCompleted(false);
                                return true;
                            }
                        }
                        if (!FocusMeteringControl.this.mCurrentAfState.equals(afState)) {
                            FocusMeteringControl.this.mCurrentAfState = afState;
                        }
                        return false;
                    }
                };
                this.mCameraControl.addCaptureResultListener(this.mSessionListenerForFocus);
            }
            this.mIsInAfAutoMode = true;
            this.mCameraControl.updateSessionConfig();
            this.triggerAf();
        } else {
            focusMeteringAction.notifyAutoFocusCompleted(false);
            this.mCameraControl.updateSessionConfig();
        }
        if (focusMeteringAction.isAutoCancelEnabled()) {
            final long timeoutId = ++this.mFocusTimeoutCounter;
            Runnable autoCancelRunnable = new Runnable(){

                @Override
                public void run() {
                    FocusMeteringControl.this.mExecutor.execute(new Runnable(){

                        @Override
                        @WorkerThread
                        public void run() {
                            if (timeoutId == FocusMeteringControl.this.mFocusTimeoutCounter) {
                                FocusMeteringControl.this.cancelFocusAndMetering();
                            }
                        }
                    });
                }
            };
            this.mAutoCancelHandle = this.mScheduler.schedule(autoCancelRunnable, focusMeteringAction.getAutoCancelDurationInMs(), TimeUnit.MILLISECONDS);
        }
    }

    @WorkerThread
    private boolean shouldTriggerAF() {
        return this.mAfRects.length > 0;
    }

    @WorkerThread
    void cancelFocusAndMetering() {
        this.mCameraControl.removeCaptureResultListener(this.mSessionListenerForFocus);
        if (this.mCurrentFocusMeteringAction != null) {
            this.mCurrentFocusMeteringAction.notifyAutoFocusCompleted(false);
        }
        this.disableAutoCancel();
        if (this.shouldTriggerAF()) {
            this.cancelAfAeTrigger(true, false);
        }
        this.mAfRects = new MeteringRectangle[0];
        this.mAeRects = new MeteringRectangle[0];
        this.mAwbRects = new MeteringRectangle[0];
        this.mIsInAfAutoMode = false;
        this.mCameraControl.updateSessionConfig();
        this.mCurrentFocusMeteringAction = null;
    }
}

