/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.impl;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.camera.core.BaseCamera;
import androidx.camera.core.Observable;
import androidx.camera.core.impl.LiveDataObservable;
import androidx.core.util.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

final class CameraAvailabilityRegistry {
    private static final boolean DEBUG = false;
    private StringBuilder mDebugString = null;
    private static final String TAG = "AvailabilityRegistry";
    final int mMaxAllowedOpenedCameras;
    private final Executor mExecutor;
    private final LiveDataObservable<Integer> mAvailableCameras;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private final Map<BaseCamera, BaseCamera.State> mCameraStates = new HashMap<BaseCamera, BaseCamera.State>();

    CameraAvailabilityRegistry(int maxAllowedOpenedCameras, @NonNull Executor executor) {
        this.mMaxAllowedOpenedCameras = maxAllowedOpenedCameras;
        this.mExecutor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.mAvailableCameras = new LiveDataObservable();
        this.mAvailableCameras.postValue((Object)maxAllowedOpenedCameras);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerCamera(final @NonNull BaseCamera camera) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mCameraStates.containsKey(camera)) {
                this.mCameraStates.put(camera, null);
                camera.getCameraState().addObserver(this.mExecutor, (Observable.Observer)new Observable.Observer<BaseCamera.State>(){

                    public void onNewData(@Nullable BaseCamera.State state) {
                        if (state == BaseCamera.State.RELEASED) {
                            CameraAvailabilityRegistry.this.unregisterCamera(camera, this);
                        } else {
                            CameraAvailabilityRegistry.this.updateState(camera, state);
                        }
                    }

                    public void onError(@NonNull Throwable t) {
                    }
                });
            }
        }
    }

    Observable<Integer> getAvailableCameraCount() {
        return this.mAvailableCameras;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void unregisterCamera(BaseCamera camera, Observable.Observer<BaseCamera.State> observer) {
        int availableCameras;
        Object object = this.mLock;
        synchronized (object) {
            camera.getCameraState().removeObserver(observer);
            if (this.mCameraStates.remove(camera) == null) {
                return;
            }
            availableCameras = this.recalculateAvailableCameras();
        }
        this.mAvailableCameras.postValue((Object)availableCameras);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void updateState(BaseCamera camera, BaseCamera.State state) {
        int availableCameras;
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mCameraStates.containsKey(camera) || this.mCameraStates.put(camera, state) == state) {
                return;
            }
            availableCameras = this.recalculateAvailableCameras();
        }
        this.mAvailableCameras.postValue((Object)availableCameras);
    }

    @WorkerThread
    @GuardedBy(value="mLock")
    private int recalculateAvailableCameras() {
        int openCount = 0;
        for (Map.Entry<BaseCamera, BaseCamera.State> entry : this.mCameraStates.entrySet()) {
            if (entry.getValue() == BaseCamera.State.CLOSED || entry.getValue() == BaseCamera.State.OPENING || entry.getValue() == BaseCamera.State.PENDING_OPEN) continue;
            ++openCount;
        }
        return Math.max(this.mMaxAllowedOpenedCameras - openCount, 0);
    }
}

