/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.impl;

import android.hardware.camera2.CaptureRequest;
import androidx.annotation.NonNull;
import androidx.camera.camera2.Camera2Config;
import androidx.camera.camera2.impl.Camera2CaptureCallbacks;
import androidx.camera.camera2.impl.CameraEventCallbacks;
import androidx.camera.camera2.impl.CaptureCallbackContainer;
import androidx.camera.core.CameraCaptureCallback;
import androidx.camera.core.CameraCaptureSessionStateCallbacks;
import androidx.camera.core.CameraDeviceStateCallbacks;
import androidx.camera.core.Config;
import androidx.camera.core.MutableOptionsBundle;
import androidx.camera.core.OptionsBundle;
import androidx.camera.core.SessionConfig;
import androidx.camera.core.UseCaseConfig;
import java.util.Collection;
import java.util.Iterator;

final class Camera2SessionOptionUnpacker
implements SessionConfig.OptionUnpacker {
    static final Camera2SessionOptionUnpacker INSTANCE = new Camera2SessionOptionUnpacker();

    Camera2SessionOptionUnpacker() {
    }

    public void unpack(@NonNull UseCaseConfig<?> config, @NonNull SessionConfig.Builder builder) {
        SessionConfig defaultSessionConfig = config.getDefaultSessionConfig(null);
        OptionsBundle implOptions = OptionsBundle.emptyBundle();
        int templateType = SessionConfig.defaultEmptySessionConfig().getTemplateType();
        if (defaultSessionConfig != null) {
            templateType = defaultSessionConfig.getTemplateType();
            builder.addAllDeviceStateCallbacks((Collection)defaultSessionConfig.getDeviceStateCallbacks());
            builder.addAllSessionStateCallbacks(defaultSessionConfig.getSessionStateCallbacks());
            builder.addAllRepeatingCameraCaptureCallbacks((Collection)defaultSessionConfig.getRepeatingCameraCaptureCallbacks());
            implOptions = defaultSessionConfig.getImplementationOptions();
        }
        builder.setImplementationOptions((Config)implOptions);
        Camera2Config camera2Config = new Camera2Config((Config)config);
        builder.setTemplateType(camera2Config.getCaptureRequestTemplate(templateType));
        builder.addDeviceStateCallback(camera2Config.getDeviceStateCallback(CameraDeviceStateCallbacks.createNoOpCallback()));
        builder.addSessionStateCallback(camera2Config.getSessionStateCallback(CameraCaptureSessionStateCallbacks.createNoOpCallback()));
        builder.addCameraCaptureCallback((CameraCaptureCallback)CaptureCallbackContainer.create(camera2Config.getSessionCaptureCallback(Camera2CaptureCallbacks.createNoOpCallback())));
        MutableOptionsBundle cameraEventConfig = MutableOptionsBundle.create();
        cameraEventConfig.insertOption(Camera2Config.CAMERA_EVENT_CALLBACK_OPTION, (Object)camera2Config.getCameraEventCallback(CameraEventCallbacks.createEmptyCallback()));
        builder.addImplementationOptions((Config)cameraEventConfig);
        Camera2Config.Builder configBuilder = new Camera2Config.Builder();
        Iterator<Config.Option<?>> iterator = camera2Config.getCaptureRequestOptions().iterator();
        while (iterator.hasNext()) {
            Config.Option<?> option;
            Config.Option<?> typeErasedOption = option = iterator.next();
            CaptureRequest.Key key = (CaptureRequest.Key)option.getToken();
            configBuilder.setCaptureRequestOption(key, camera2Config.retrieveOption(typeErasedOption));
        }
        builder.addImplementationOptions((Config)configBuilder.build());
    }
}

