/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.impl;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.camera.core.CameraX;
import androidx.camera.core.LensFacingCameraIdFilter;
import java.util.LinkedHashSet;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class Camera2LensFacingCameraIdFilter
extends LensFacingCameraIdFilter {
    private static final String TAG = "Camera2LensFacingCIF";
    private CameraX.LensFacing mLensFacing;
    private CameraManager mCameraManager;

    Camera2LensFacingCameraIdFilter(@NonNull CameraManager cameraManager, @NonNull CameraX.LensFacing lensFacing) {
        this.mLensFacing = lensFacing;
        this.mCameraManager = cameraManager;
    }

    @NonNull
    public Set<String> filter(@NonNull Set<String> cameraIdSet) {
        LinkedHashSet<String> resultCameraIdSet = new LinkedHashSet<String>();
        for (String cameraId : cameraIdSet) {
            Integer lensFacingInteger = null;
            try {
                lensFacingInteger = (Integer)this.mCameraManager.getCameraCharacteristics(cameraId).get(CameraCharacteristics.LENS_FACING);
            }
            catch (CameraAccessException e) {
                Log.e((String)TAG, (String)("Unable to retrieve info for camera with id " + cameraId + "."), (Throwable)e);
            }
            if (lensFacingInteger == null || !lensFacingInteger.equals(this.cameraXLensFacingToCamera2LensFacing(this.mLensFacing))) continue;
            resultCameraIdSet.add(cameraId);
        }
        return resultCameraIdSet;
    }

    @NonNull
    public CameraX.LensFacing getLensFacing() {
        return this.mLensFacing;
    }

    private Integer cameraXLensFacingToCamera2LensFacing(CameraX.LensFacing lensFacing) {
        Integer lensFacingInteger = -1;
        switch (lensFacing) {
            case BACK: {
                lensFacingInteger = 1;
                break;
            }
            case FRONT: {
                lensFacingInteger = 0;
            }
        }
        return lensFacingInteger;
    }
}

