/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.impl;

import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraManager;
import android.media.CamcorderProfile;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.camera.camera2.impl.CamcorderProfileHelper;
import androidx.camera.camera2.impl.SupportedSurfaceCombination;
import androidx.camera.camera2.impl.UseCaseSurfaceOccupancyManager;
import androidx.camera.core.CameraDeviceConfig;
import androidx.camera.core.CameraDeviceSurfaceManager;
import androidx.camera.core.CameraX;
import androidx.camera.core.SurfaceConfig;
import androidx.camera.core.UseCase;
import androidx.camera.core.UseCaseConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class Camera2DeviceSurfaceManager
implements CameraDeviceSurfaceManager {
    private static final String TAG = "Camera2DeviceSurfaceManager";
    private static final Size MAXIMUM_PREVIEW_SIZE = new Size(1920, 1080);
    private final Map<String, SupportedSurfaceCombination> mCameraSupportedSurfaceCombinationMap = new HashMap<String, SupportedSurfaceCombination>();
    private boolean mIsInitialized = false;

    public Camera2DeviceSurfaceManager(Context context) {
        this.init(context, new CamcorderProfileHelper(){

            @Override
            public boolean hasProfile(int cameraId, int quality) {
                return CamcorderProfile.hasProfile((int)cameraId, (int)quality);
            }
        });
    }

    @VisibleForTesting
    Camera2DeviceSurfaceManager(Context context, CamcorderProfileHelper camcorderProfileHelper) {
        this.init(context, camcorderProfileHelper);
    }

    public boolean checkSupported(String cameraId, List<SurfaceConfig> surfaceConfigList) {
        boolean isSupported = false;
        if (!this.mIsInitialized) {
            throw new IllegalStateException("Camera2DeviceSurfaceManager is not initialized.");
        }
        if (surfaceConfigList == null || surfaceConfigList.isEmpty()) {
            return true;
        }
        SupportedSurfaceCombination supportedSurfaceCombination = this.mCameraSupportedSurfaceCombinationMap.get(cameraId);
        if (supportedSurfaceCombination != null) {
            isSupported = supportedSurfaceCombination.checkSupported(surfaceConfigList);
        }
        return isSupported;
    }

    public SurfaceConfig transformSurfaceConfig(String cameraId, int imageFormat, Size size) {
        SurfaceConfig surfaceConfig = null;
        if (!this.mIsInitialized) {
            throw new IllegalStateException("Camera2DeviceSurfaceManager is not initialized.");
        }
        SupportedSurfaceCombination supportedSurfaceCombination = this.mCameraSupportedSurfaceCombinationMap.get(cameraId);
        if (supportedSurfaceCombination != null) {
            surfaceConfig = supportedSurfaceCombination.transformSurfaceConfig(imageFormat, size);
        }
        return surfaceConfig;
    }

    public Map<UseCase, Size> getSuggestedResolutions(String cameraId, List<UseCase> originalUseCases, List<UseCase> newUseCases) {
        if (newUseCases == null || newUseCases.isEmpty()) {
            throw new IllegalArgumentException("No new use cases to be bound.");
        }
        UseCaseSurfaceOccupancyManager.checkUseCaseLimitNotExceeded(originalUseCases, newUseCases);
        ArrayList<SurfaceConfig> surfaceConfigs = new ArrayList<SurfaceConfig>();
        if (originalUseCases != null) {
            for (UseCase useCase : originalUseCases) {
                String useCaseCameraId = this.getCameraIdFromConfig(useCase.getUseCaseConfig());
                Size resolution = useCase.getAttachedSurfaceResolution(useCaseCameraId);
                surfaceConfigs.add(this.transformSurfaceConfig(cameraId, useCase.getImageFormat(), resolution));
            }
        }
        for (UseCase useCase : newUseCases) {
            surfaceConfigs.add(this.transformSurfaceConfig(cameraId, useCase.getImageFormat(), new Size(640, 480)));
        }
        SupportedSurfaceCombination supportedSurfaceCombination = this.mCameraSupportedSurfaceCombinationMap.get(cameraId);
        if (supportedSurfaceCombination == null || !supportedSurfaceCombination.checkSupported(surfaceConfigs)) {
            throw new IllegalArgumentException("No supported surface combination is found for camera device - Id : " + cameraId + ".  May be attempting to bind too many use cases.");
        }
        return supportedSurfaceCombination.getSuggestedResolutions(originalUseCases, newUseCases);
    }

    private void init(Context context, CamcorderProfileHelper camcorderProfileHelper) {
        if (!this.mIsInitialized) {
            CameraManager cameraManager = (CameraManager)context.getSystemService("camera");
            try {
                for (String cameraId : cameraManager.getCameraIdList()) {
                    this.mCameraSupportedSurfaceCombinationMap.put(cameraId, new SupportedSurfaceCombination(context, cameraId, camcorderProfileHelper));
                }
            }
            catch (CameraAccessException e) {
                throw new IllegalArgumentException("Fail to get camera id list", e);
            }
            this.mIsInitialized = true;
        }
    }

    public Size getMaxOutputSize(String cameraId, int imageFormat) {
        if (!this.mIsInitialized) {
            throw new IllegalStateException("CameraDeviceSurfaceManager is not initialized.");
        }
        SupportedSurfaceCombination supportedSurfaceCombination = this.mCameraSupportedSurfaceCombinationMap.get(cameraId);
        if (supportedSurfaceCombination == null) {
            throw new IllegalArgumentException("Fail to find supported surface info - CameraId:" + cameraId);
        }
        return supportedSurfaceCombination.getMaxOutputSizeByFormat(imageFormat);
    }

    public Size getPreviewSize() {
        if (!this.mIsInitialized) {
            throw new IllegalStateException("CameraDeviceSurfaceManager is not initialized.");
        }
        Size previewSize = MAXIMUM_PREVIEW_SIZE;
        if (!this.mCameraSupportedSurfaceCombinationMap.isEmpty()) {
            String cameraId = (String)this.mCameraSupportedSurfaceCombinationMap.keySet().toArray()[0];
            previewSize = this.mCameraSupportedSurfaceCombinationMap.get(cameraId).getSurfaceSizeDefinition().getPreviewSize();
        }
        return previewSize;
    }

    public boolean requiresCorrectedAspectRatio(@NonNull UseCaseConfig<?> useCaseConfig) {
        if (!this.mIsInitialized) {
            throw new IllegalStateException("CameraDeviceSurfaceManager is not initialized.");
        }
        String cameraId = this.getCameraIdFromConfig(useCaseConfig);
        SupportedSurfaceCombination supportedSurfaceCombination = this.mCameraSupportedSurfaceCombinationMap.get(cameraId);
        if (supportedSurfaceCombination == null) {
            throw new IllegalArgumentException("Fail to find supported surface info - CameraId:" + cameraId);
        }
        return supportedSurfaceCombination.requiresCorrectedAspectRatio();
    }

    @Nullable
    public Rational getCorrectedAspectRatio(@NonNull UseCaseConfig<?> useCaseConfig) {
        if (!this.mIsInitialized) {
            throw new IllegalStateException("CameraDeviceSurfaceManager is not initialized.");
        }
        String cameraId = this.getCameraIdFromConfig(useCaseConfig);
        SupportedSurfaceCombination supportedSurfaceCombination = this.mCameraSupportedSurfaceCombinationMap.get(cameraId);
        if (supportedSurfaceCombination == null) {
            throw new IllegalArgumentException("Fail to find supported surface info - CameraId:" + cameraId);
        }
        return supportedSurfaceCombination.getCorrectedAspectRatio(useCaseConfig);
    }

    private String getCameraIdFromConfig(UseCaseConfig<?> useCaseConfig) {
        String cameraId;
        CameraDeviceConfig config = (CameraDeviceConfig)useCaseConfig;
        try {
            CameraX.LensFacing lensFacing = config.getLensFacing(null);
            if (lensFacing == null) {
                lensFacing = CameraX.getDefaultLensFacing();
            }
            cameraId = CameraX.getCameraWithLensFacing((CameraX.LensFacing)lensFacing);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to get camera ID for use case " + useCaseConfig.getTargetName(), e);
        }
        return cameraId;
    }

    static enum Operation {
        ADD_CONFIG,
        REMOVE_CONFIG;

    }
}

