/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.impl;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.CameraInfoInternal;
import androidx.camera.core.CameraInfoUnavailableException;
import androidx.camera.core.CameraOrientationUtil;
import androidx.camera.core.CameraX;
import androidx.core.util.Preconditions;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;

final class Camera2CameraInfo
implements CameraInfoInternal {
    private final CameraCharacteristics mCameraCharacteristics;
    private static final String TAG = "Camera2CameraInfo";
    private MutableLiveData<Boolean> mFlashAvailability;

    Camera2CameraInfo(CameraManager cameraManager, String cameraId) throws CameraInfoUnavailableException {
        try {
            this.mCameraCharacteristics = cameraManager.getCameraCharacteristics(cameraId);
        }
        catch (CameraAccessException e) {
            throw new CameraInfoUnavailableException("Unable to retrieve info for camera " + cameraId, (Throwable)e);
        }
        this.mFlashAvailability = new MutableLiveData(this.mCameraCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE));
        this.checkCharacteristicAvailable(CameraCharacteristics.SENSOR_ORIENTATION, "Sensor orientation");
        this.checkCharacteristicAvailable(CameraCharacteristics.LENS_FACING, "Lens facing direction");
        this.checkCharacteristicAvailable(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL, "Supported hardware level");
        this.logDeviceInfo();
    }

    @Nullable
    public CameraX.LensFacing getLensFacing() {
        Integer lensFacing = (Integer)this.mCameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
        Preconditions.checkNotNull((Object)lensFacing);
        switch (lensFacing) {
            case 0: {
                return CameraX.LensFacing.FRONT;
            }
            case 1: {
                return CameraX.LensFacing.BACK;
            }
        }
        return null;
    }

    public int getSensorRotationDegrees(int relativeRotation) {
        Integer sensorOrientation = this.getSensorOrientation();
        int relativeRotationDegrees = CameraOrientationUtil.surfaceRotationToDegrees((int)relativeRotation);
        boolean isOppositeFacingScreen = CameraX.LensFacing.BACK.equals((Object)this.getLensFacing());
        return CameraOrientationUtil.getRelativeImageRotation((int)relativeRotationDegrees, (int)sensorOrientation, (boolean)isOppositeFacingScreen);
    }

    int getSensorOrientation() {
        Integer sensorOrientation = (Integer)this.mCameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        Preconditions.checkNotNull((Object)sensorOrientation);
        return sensorOrientation;
    }

    int getSupportedHardwareLevel() {
        Integer deviceLevel = (Integer)this.mCameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
        Preconditions.checkNotNull((Object)deviceLevel);
        return deviceLevel;
    }

    private void checkCharacteristicAvailable(CameraCharacteristics.Key<?> key, String readableName) throws CameraInfoUnavailableException {
        if (this.mCameraCharacteristics.get(key) == null) {
            throw new CameraInfoUnavailableException("Camera characteristics map is missing value for characteristic: " + readableName);
        }
    }

    public int getSensorRotationDegrees() {
        return this.getSensorRotationDegrees(0);
    }

    private void logDeviceInfo() {
        this.logDeviceLevel();
    }

    private void logDeviceLevel() {
        String levelString;
        int deviceLevel = this.getSupportedHardwareLevel();
        switch (deviceLevel) {
            case 2: {
                levelString = "INFO_SUPPORTED_HARDWARE_LEVEL_LEGACY";
                break;
            }
            case 4: {
                levelString = "INFO_SUPPORTED_HARDWARE_LEVEL_EXTERNAL";
                break;
            }
            case 0: {
                levelString = "INFO_SUPPORTED_HARDWARE_LEVEL_LIMITED";
                break;
            }
            case 1: {
                levelString = "INFO_SUPPORTED_HARDWARE_LEVEL_FULL";
                break;
            }
            case 3: {
                levelString = "INFO_SUPPORTED_HARDWARE_LEVEL_3";
                break;
            }
            default: {
                levelString = "Unknown value: " + deviceLevel;
            }
        }
        Log.i((String)TAG, (String)("Device Level: " + levelString));
    }

    @NonNull
    public LiveData<Boolean> isFlashAvailable() {
        return this.mFlashAvailability;
    }
}

