/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.impl;

import android.graphics.Rect;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.TotalCaptureResult;
import android.util.Rational;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.camera.camera2.Camera2Config;
import androidx.camera.camera2.impl.CaptureCallbackContainer;
import androidx.camera.camera2.impl.FocusMeteringControl;
import androidx.camera.core.CameraCaptureCallback;
import androidx.camera.core.CameraControlInternal;
import androidx.camera.core.CaptureConfig;
import androidx.camera.core.Config;
import androidx.camera.core.FlashMode;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.SessionConfig;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class Camera2CameraControl
implements CameraControlInternal {
    private static final String TAG = "Camera2CameraControl";
    final CameraControlSessionCallback mSessionCallback;
    final Executor mExecutor;
    private final CameraCharacteristics mCameraCharacteristics;
    private final CameraControlInternal.ControlUpdateListener mControlUpdateListener;
    private final ScheduledExecutorService mScheduler;
    private final SessionConfig.Builder mSessionConfigBuilder = new SessionConfig.Builder();
    volatile Rational mPreviewAspectRatio = null;
    @VisibleForTesting
    final FocusMeteringControl mFocusMeteringControl;
    private volatile boolean mIsTorchOn = false;
    private volatile FlashMode mFlashMode = FlashMode.OFF;
    private Rect mCropRect = null;

    public Camera2CameraControl(@NonNull CameraCharacteristics cameraCharacteristics, @NonNull CameraControlInternal.ControlUpdateListener controlUpdateListener, @NonNull ScheduledExecutorService scheduler, @NonNull Executor executor) {
        this.mCameraCharacteristics = cameraCharacteristics;
        this.mControlUpdateListener = controlUpdateListener;
        this.mExecutor = CameraXExecutors.isSequentialExecutor((Executor)executor) ? executor : CameraXExecutors.newSequentialExecutor((Executor)executor);
        this.mScheduler = scheduler;
        this.mSessionCallback = new CameraControlSessionCallback(this.mExecutor);
        this.mSessionConfigBuilder.setTemplateType(this.getDefaultTemplate());
        this.mSessionConfigBuilder.addRepeatingCameraCaptureCallback((CameraCaptureCallback)CaptureCallbackContainer.create(this.mSessionCallback));
        this.mFocusMeteringControl = new FocusMeteringControl(this, this.mExecutor, this.mScheduler);
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                Camera2CameraControl.this.updateSessionConfig();
            }
        });
    }

    public void setPreviewAspectRatio(@Nullable Rational previewAspectRatio) {
        this.mPreviewAspectRatio = previewAspectRatio;
    }

    public void startFocusAndMetering(final @NonNull FocusMeteringAction action) {
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                Camera2CameraControl.this.mFocusMeteringControl.startFocusAndMetering(action, Camera2CameraControl.this.mPreviewAspectRatio);
            }
        });
    }

    public void cancelFocusAndMetering() {
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                Camera2CameraControl.this.mFocusMeteringControl.cancelFocusAndMetering();
            }
        });
    }

    public void setCropRegion(final @Nullable Rect crop) {
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                Camera2CameraControl.this.setCropRegionInternal(crop);
            }
        });
    }

    @NonNull
    public FlashMode getFlashMode() {
        return this.mFlashMode;
    }

    public void setFlashMode(@NonNull FlashMode flashMode) {
        this.mFlashMode = flashMode;
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                Camera2CameraControl.this.updateSessionConfig();
            }
        });
    }

    public void enableTorch(final boolean torch) {
        this.mIsTorchOn = torch;
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                Camera2CameraControl.this.enableTorchInternal(torch);
            }
        });
    }

    public boolean isTorchOn() {
        return this.mIsTorchOn;
    }

    public void triggerAf() {
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                Camera2CameraControl.this.mFocusMeteringControl.triggerAf();
            }
        });
    }

    public void triggerAePrecapture() {
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                Camera2CameraControl.this.mFocusMeteringControl.triggerAePrecapture();
            }
        });
    }

    public void cancelAfAeTrigger(final boolean cancelAfTrigger, final boolean cancelAePrecaptureTrigger) {
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                Camera2CameraControl.this.mFocusMeteringControl.cancelAfAeTrigger(cancelAfTrigger, cancelAePrecaptureTrigger);
            }
        });
    }

    public void submitCaptureRequests(final @NonNull List<CaptureConfig> captureConfigs) {
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                Camera2CameraControl.this.submitCaptureRequestsInternal(captureConfigs);
            }
        });
    }

    @WorkerThread
    private int getDefaultTemplate() {
        return 1;
    }

    @WorkerThread
    void updateSessionConfig() {
        this.mSessionConfigBuilder.setImplementationOptions(this.getSessionOptions());
        this.mControlUpdateListener.onCameraControlUpdateSessionConfig(this.mSessionConfigBuilder.build());
    }

    @WorkerThread
    void setCropRegionInternal(Rect crop) {
        this.mCropRect = crop;
        this.updateSessionConfig();
    }

    @WorkerThread
    @NonNull
    Rect getCropSensorRegion() {
        Rect cropRect = this.mCropRect;
        if (cropRect == null) {
            cropRect = this.getSensorRect();
        }
        return cropRect;
    }

    @WorkerThread
    @NonNull
    Rect getSensorRect() {
        return (Rect)this.mCameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
    }

    @WorkerThread
    void removeCaptureResultListener(@NonNull CaptureResultListener listener) {
        this.mSessionCallback.removeListener(listener);
    }

    @WorkerThread
    void addCaptureResultListener(@NonNull CaptureResultListener listener) {
        this.mSessionCallback.addListener(listener);
    }

    @WorkerThread
    void enableTorchInternal(boolean torch) {
        if (!torch) {
            CaptureConfig.Builder singleRequestBuilder = new CaptureConfig.Builder();
            singleRequestBuilder.setTemplateType(this.getDefaultTemplate());
            singleRequestBuilder.setUseRepeatingSurface(true);
            Camera2Config.Builder configBuilder = new Camera2Config.Builder();
            configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AE_MODE, this.getSupportedAeMode(1));
            configBuilder.setCaptureRequestOption(CaptureRequest.FLASH_MODE, 0);
            singleRequestBuilder.addImplementationOptions((Config)configBuilder.build());
            this.submitCaptureRequestsInternal(Collections.singletonList(singleRequestBuilder.build()));
        }
        this.updateSessionConfig();
    }

    @WorkerThread
    void submitCaptureRequestsInternal(List<CaptureConfig> captureConfigs) {
        this.mControlUpdateListener.onCameraControlCaptureRequests(captureConfigs);
    }

    @VisibleForTesting
    @WorkerThread
    Config getSessionOptions() {
        Camera2Config.Builder builder = new Camera2Config.Builder();
        builder.setCaptureRequestOption(CaptureRequest.CONTROL_MODE, 1);
        this.mFocusMeteringControl.addFocusMeteringOptions(builder);
        int aeMode = 1;
        if (this.mIsTorchOn) {
            builder.setCaptureRequestOption(CaptureRequest.FLASH_MODE, 2);
        } else {
            switch (this.mFlashMode) {
                case OFF: {
                    aeMode = 1;
                    break;
                }
                case ON: {
                    aeMode = 3;
                    break;
                }
                case AUTO: {
                    aeMode = 2;
                }
            }
        }
        builder.setCaptureRequestOption(CaptureRequest.CONTROL_AE_MODE, this.getSupportedAeMode(aeMode));
        builder.setCaptureRequestOption(CaptureRequest.CONTROL_AWB_MODE, this.getSupportedAwbMode(1));
        if (this.mCropRect != null) {
            builder.setCaptureRequestOption(CaptureRequest.SCALER_CROP_REGION, this.mCropRect);
        }
        return builder.build();
    }

    @WorkerThread
    int getSupportedAfMode(int preferredMode) {
        int[] modes = (int[])this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
        if (modes == null) {
            return 0;
        }
        if (this.isModeInList(preferredMode, modes)) {
            return preferredMode;
        }
        if (this.isModeInList(4, modes)) {
            return 4;
        }
        if (this.isModeInList(1, modes)) {
            return 1;
        }
        return 0;
    }

    @WorkerThread
    private int getSupportedAeMode(int preferredMode) {
        int[] modes = (int[])this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_MODES);
        if (modes == null) {
            return 0;
        }
        if (this.isModeInList(preferredMode, modes)) {
            return preferredMode;
        }
        if (this.isModeInList(1, modes)) {
            return 1;
        }
        return 0;
    }

    @WorkerThread
    private int getSupportedAwbMode(int preferredMode) {
        int[] modes = (int[])this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_AWB_AVAILABLE_MODES);
        if (modes == null) {
            return 0;
        }
        if (this.isModeInList(preferredMode, modes)) {
            return preferredMode;
        }
        if (this.isModeInList(1, modes)) {
            return 1;
        }
        return 0;
    }

    @WorkerThread
    private boolean isModeInList(int mode, int[] modeList) {
        for (int m : modeList) {
            if (mode != m) continue;
            return true;
        }
        return false;
    }

    static final class CameraControlSessionCallback
    extends CameraCaptureSession.CaptureCallback {
        final Set<CaptureResultListener> mResultListeners = new HashSet<CaptureResultListener>();
        private final Executor mExecutor;

        CameraControlSessionCallback(@NonNull Executor executor) {
            this.mExecutor = executor;
        }

        @WorkerThread
        void addListener(@NonNull CaptureResultListener listener) {
            this.mResultListeners.add(listener);
        }

        @WorkerThread
        void removeListener(@NonNull CaptureResultListener listener) {
            this.mResultListeners.remove(listener);
        }

        public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, final @NonNull TotalCaptureResult result) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    HashSet<CaptureResultListener> removeSet = new HashSet<CaptureResultListener>();
                    for (CaptureResultListener listener : mResultListeners) {
                        boolean isFinished = listener.onCaptureResult(result);
                        if (!isFinished) continue;
                        removeSet.add(listener);
                    }
                    if (!removeSet.isEmpty()) {
                        mResultListeners.removeAll(removeSet);
                    }
                }
            });
        }
    }

    static interface CaptureResultListener {
        public boolean onCaptureResult(@NonNull TotalCaptureResult var1);
    }
}

