/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.impl;

import android.annotation.SuppressLint;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.util.Rational;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import androidx.camera.camera2.impl.Camera2CameraControl;
import androidx.camera.camera2.impl.Camera2CameraInfo;
import androidx.camera.camera2.impl.CaptureSession;
import androidx.camera.camera2.impl.compat.CameraManagerCompat;
import androidx.camera.core.BaseCamera;
import androidx.camera.core.CameraControlInternal;
import androidx.camera.core.CameraDeviceStateCallbacks;
import androidx.camera.core.CameraInfoInternal;
import androidx.camera.core.CameraInfoUnavailableException;
import androidx.camera.core.CameraX;
import androidx.camera.core.CaptureConfig;
import androidx.camera.core.DeferrableSurface;
import androidx.camera.core.ImmediateSurface;
import androidx.camera.core.Observable;
import androidx.camera.core.Preview;
import androidx.camera.core.SessionConfig;
import androidx.camera.core.UseCase;
import androidx.camera.core.UseCaseAttachState;
import androidx.camera.core.impl.LiveDataObservable;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;

final class Camera
implements BaseCamera {
    private static final String TAG = "Camera";
    private static final int ERROR_NONE = 0;
    private final Object mAttachedUseCaseLock = new Object();
    @GuardedBy(value="mAttachedUseCaseLock")
    private final UseCaseAttachState mUseCaseAttachState;
    private final String mCameraId;
    private final CameraManagerCompat mCameraManager;
    private final Object mCameraInfoLock = new Object();
    final Handler mHandler;
    private final Executor mExecutor;
    volatile InternalState mState = InternalState.INITIALIZED;
    private final LiveDataObservable<BaseCamera.State> mObservableState = new LiveDataObservable();
    private final Camera2CameraControl mCameraControlInternal;
    private final StateCallback mStateCallback = new StateCallback();
    @GuardedBy(value="mCameraInfoLock")
    @Nullable
    private CameraInfoInternal mCameraInfoInternal;
    @Nullable
    CameraDevice mCameraDevice;
    int mCameraDeviceError = 0;
    private CaptureSession.Builder mCaptureSessionBuilder = new CaptureSession.Builder();
    CaptureSession mCaptureSession;
    private SessionConfig mCameraControlSessionConfig = SessionConfig.defaultEmptySessionConfig();
    private final Object mPendingLock = new Object();
    @GuardedBy(value="mPendingLock")
    private final List<UseCase> mPendingForAddOnline = new ArrayList<UseCase>();
    final AtomicInteger mReleaseRequestCount = new AtomicInteger(0);
    ListenableFuture<Void> mUserReleaseFuture;
    CallbackToFutureAdapter.Completer<Void> mUserReleaseNotifier;
    final Map<CaptureSession, ListenableFuture<Void>> mReleasedCaptureSessions = new HashMap<CaptureSession, ListenableFuture<Void>>();
    private final Observable<Integer> mAvailableCamerasObservable;
    private final CameraAvailability mCameraAvailability;

    Camera(CameraManagerCompat cameraManager, String cameraId, @NonNull Observable<Integer> availableCamerasObservable, Handler handler) {
        this.mCameraManager = cameraManager;
        this.mCameraId = cameraId;
        this.mAvailableCamerasObservable = availableCamerasObservable;
        this.mHandler = handler;
        ScheduledExecutorService executorScheduler = CameraXExecutors.newHandlerExecutor((Handler)this.mHandler);
        this.mExecutor = executorScheduler;
        this.mUseCaseAttachState = new UseCaseAttachState(cameraId);
        this.mObservableState.postValue((Object)BaseCamera.State.CLOSED);
        try {
            CameraCharacteristics cameraCharacteristics = this.mCameraManager.unwrap().getCameraCharacteristics(this.mCameraId);
            this.mCameraControlInternal = new Camera2CameraControl(cameraCharacteristics, (CameraControlInternal.ControlUpdateListener)this, executorScheduler, executorScheduler);
            int supportedHardwareLevel = (Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
            this.mCaptureSessionBuilder.setSupportedHardwareLevel(supportedHardwareLevel);
        }
        catch (CameraAccessException e) {
            throw new IllegalStateException("Cannot access camera", e);
        }
        this.mCaptureSessionBuilder.setExecutor(this.mExecutor);
        this.mCaptureSession = this.mCaptureSessionBuilder.build();
        this.mCameraAvailability = new CameraAvailability(this.mCameraId);
        this.mAvailableCamerasObservable.addObserver(this.mExecutor, (Observable.Observer)this.mCameraAvailability);
        this.mCameraManager.registerAvailabilityCallback(this.mExecutor, this.mCameraAvailability);
    }

    public void open() {
        if (Looper.myLooper() != this.mHandler.getLooper()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Camera.this.open();
                }
            });
            return;
        }
        switch (this.mState) {
            case INITIALIZED: {
                this.openCameraDevice();
                break;
            }
            case CLOSING: {
                this.setState(InternalState.REOPENING);
                if (this.isSessionCloseComplete() || this.mCameraDeviceError != 0) break;
                Preconditions.checkState((this.mCameraDevice != null ? 1 : 0) != 0, (String)"Camera Device should be open if session close is not complete");
                this.setState(InternalState.OPENED);
                this.openCaptureSession();
                break;
            }
            default: {
                Log.d((String)TAG, (String)("open() ignored due to being in state: " + (Object)((Object)this.mState)));
            }
        }
    }

    public void close() {
        if (Looper.myLooper() != this.mHandler.getLooper()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Camera.this.close();
                }
            });
            return;
        }
        Log.d((String)TAG, (String)("Closing camera: " + this.mCameraId));
        switch (this.mState) {
            case OPENED: {
                this.setState(InternalState.CLOSING);
                this.closeCamera(false);
                break;
            }
            case OPENING: 
            case REOPENING: {
                this.setState(InternalState.CLOSING);
                break;
            }
            case PENDING_OPEN: {
                Preconditions.checkState((this.mCameraDevice == null ? 1 : 0) != 0);
                this.setState(InternalState.INITIALIZED);
                break;
            }
            default: {
                Log.d((String)TAG, (String)("close() ignored due to being in state: " + (Object)((Object)this.mState)));
            }
        }
    }

    @WorkerThread
    private void configAndClose() {
        CaptureSession dummySession = this.mCaptureSessionBuilder.build();
        final SurfaceTexture surfaceTexture = new SurfaceTexture(0);
        surfaceTexture.setDefaultBufferSize(640, 480);
        final Surface surface = new Surface(surfaceTexture);
        Runnable closeAndCleanupRunner = new Runnable(){

            @Override
            public void run() {
                surface.release();
                surfaceTexture.release();
            }
        };
        SessionConfig.Builder builder = new SessionConfig.Builder();
        builder.addNonRepeatingSurface((DeferrableSurface)new ImmediateSurface(surface));
        builder.setTemplateType(1);
        try {
            Log.d((String)TAG, (String)"Start configAndClose.");
            dummySession.open(builder.build(), this.mCameraDevice);
            ListenableFuture<Void> releaseFuture = this.releaseSession(dummySession, false);
            releaseFuture.addListener(closeAndCleanupRunner, CameraXExecutors.directExecutor());
        }
        catch (CameraAccessException e) {
            Log.d((String)TAG, (String)("Unable to configure camera " + this.mCameraId + " due to " + e.getMessage()));
            closeAndCleanupRunner.run();
        }
        catch (DeferrableSurface.SurfaceClosedException e) {
            this.postSurfaceClosedError(e);
        }
    }

    boolean isSessionCloseComplete() {
        return this.mReleasedCaptureSessions.isEmpty();
    }

    void finishClose() {
        Preconditions.checkState((this.mState == InternalState.RELEASING || this.mState == InternalState.CLOSING ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.mReleasedCaptureSessions.isEmpty());
        this.mCameraDevice = null;
        if (this.mState == InternalState.CLOSING) {
            this.setState(InternalState.INITIALIZED);
        } else {
            this.setState(InternalState.RELEASED);
            this.mAvailableCamerasObservable.removeObserver((Observable.Observer)this.mCameraAvailability);
            this.mCameraManager.unregisterAvailabilityCallback(this.mCameraAvailability);
            if (this.mUserReleaseNotifier != null) {
                this.mUserReleaseNotifier.set(null);
                this.mUserReleaseNotifier = null;
            }
        }
    }

    @WorkerThread
    void closeCamera(boolean abortInFlightCaptures) {
        Preconditions.checkState((this.mState == InternalState.CLOSING || this.mState == InternalState.RELEASING || this.mState == InternalState.REOPENING && this.mCameraDeviceError != 0 ? 1 : 0) != 0, (String)("closeCamera should only be called in a CLOSING, RELEASING or REOPENING (with error) state. Current state: " + (Object)((Object)this.mState) + " (error: " + this.getErrorMessage(this.mCameraDeviceError) + ")"));
        boolean isLegacyDevice = false;
        try {
            Camera2CameraInfo camera2CameraInfo = (Camera2CameraInfo)this.getCameraInfoInternal();
            isLegacyDevice = camera2CameraInfo.getSupportedHardwareLevel() == 2;
        }
        catch (CameraInfoUnavailableException e) {
            Log.w((String)TAG, (String)"Check legacy device failed.", (Throwable)e);
        }
        if (Build.VERSION.SDK_INT > 23 && Build.VERSION.SDK_INT < 29 && isLegacyDevice && this.mCameraDeviceError == 0) {
            this.configAndClose();
        }
        this.resetCaptureSession(abortInFlightCaptures);
    }

    @WorkerThread
    private ListenableFuture<Void> releaseSession(final @NonNull CaptureSession captureSession, boolean abortInFlightCaptures) {
        captureSession.close();
        ListenableFuture<Void> releaseFuture = captureSession.release(abortInFlightCaptures);
        Log.d((String)TAG, (String)("releasing session in state " + this.mState.name()));
        this.mReleasedCaptureSessions.put(captureSession, releaseFuture);
        Futures.addCallback(releaseFuture, (FutureCallback)new FutureCallback<Void>(){

            @WorkerThread
            public void onSuccess(@Nullable Void result) {
                Camera.this.mReleasedCaptureSessions.remove(captureSession);
                switch (Camera.this.mState) {
                    case REOPENING: {
                        if (Camera.this.mCameraDeviceError == 0) break;
                    }
                    case CLOSING: 
                    case RELEASING: {
                        if (!Camera.this.isSessionCloseComplete() || Camera.this.mCameraDevice == null) break;
                        Camera.this.mCameraDevice.close();
                        Camera.this.mCameraDevice = null;
                        break;
                    }
                }
            }

            public void onFailure(Throwable t) {
            }
        }, (Executor)CameraXExecutors.directExecutor());
        return releaseFuture;
    }

    @NonNull
    public ListenableFuture<Void> release() {
        ListenableFuture releaseFuture = CallbackToFutureAdapter.getFuture((CallbackToFutureAdapter.Resolver)new CallbackToFutureAdapter.Resolver<Void>(){

            public Object attachCompleter(final @NonNull CallbackToFutureAdapter.Completer<Void> completer) {
                Camera.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        Futures.propagate(Camera.this.getOrCreateUserReleaseFuture(), (CallbackToFutureAdapter.Completer)completer);
                    }
                });
                return "Release[request=" + Camera.this.mReleaseRequestCount.getAndIncrement() + "]";
            }
        });
        if (Looper.myLooper() != this.mHandler.getLooper()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Camera.this.releaseInternal();
                }
            });
        } else {
            this.releaseInternal();
        }
        return releaseFuture;
    }

    @NonNull
    public Observable<BaseCamera.State> getCameraState() {
        return this.mObservableState;
    }

    @WorkerThread
    void releaseInternal() {
        switch (this.mState) {
            case INITIALIZED: 
            case PENDING_OPEN: {
                Preconditions.checkState((this.mCameraDevice == null ? 1 : 0) != 0);
                this.setState(InternalState.RELEASING);
                Preconditions.checkState((boolean)this.isSessionCloseComplete());
                this.finishClose();
                break;
            }
            case OPENED: {
                this.setState(InternalState.RELEASING);
                this.closeCamera(true);
                break;
            }
            case CLOSING: 
            case OPENING: 
            case REOPENING: 
            case RELEASING: {
                this.setState(InternalState.RELEASING);
                break;
            }
            default: {
                Log.d((String)TAG, (String)("release() ignored due to being in state: " + (Object)((Object)this.mState)));
            }
        }
    }

    @WorkerThread
    ListenableFuture<Void> getOrCreateUserReleaseFuture() {
        if (this.mUserReleaseFuture == null) {
            this.mUserReleaseFuture = this.mState != InternalState.RELEASED ? CallbackToFutureAdapter.getFuture((CallbackToFutureAdapter.Resolver)new CallbackToFutureAdapter.Resolver<Void>(){

                public Object attachCompleter(@NonNull CallbackToFutureAdapter.Completer<Void> completer) {
                    Preconditions.checkState((Camera.this.mUserReleaseNotifier == null ? 1 : 0) != 0, (String)"Camera can only be released once, so release completer should be null on creation.");
                    Camera.this.mUserReleaseNotifier = completer;
                    return "Release[camera=" + Camera.this + "]";
                }
            }) : Futures.immediateFuture(null);
        }
        return this.mUserReleaseFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUseCaseActive(final UseCase useCase) {
        if (Looper.myLooper() != this.mHandler.getLooper()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Camera.this.onUseCaseActive(useCase);
                }
            });
            return;
        }
        Log.d((String)TAG, (String)("Use case " + useCase + " ACTIVE for camera " + this.mCameraId));
        Object object = this.mAttachedUseCaseLock;
        synchronized (object) {
            this.reattachUseCaseSurfaces(useCase);
            this.mUseCaseAttachState.setUseCaseActive(useCase);
            this.mUseCaseAttachState.updateUseCase(useCase);
        }
        this.updateCaptureSessionConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUseCaseInactive(final UseCase useCase) {
        if (Looper.myLooper() != this.mHandler.getLooper()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Camera.this.onUseCaseInactive(useCase);
                }
            });
            return;
        }
        Log.d((String)TAG, (String)("Use case " + useCase + " INACTIVE for camera " + this.mCameraId));
        Object object = this.mAttachedUseCaseLock;
        synchronized (object) {
            this.mUseCaseAttachState.setUseCaseInactive(useCase);
        }
        this.updateCaptureSessionConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUseCaseUpdated(final UseCase useCase) {
        if (Looper.myLooper() != this.mHandler.getLooper()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Camera.this.onUseCaseUpdated(useCase);
                }
            });
            return;
        }
        Log.d((String)TAG, (String)("Use case " + useCase + " UPDATED for camera " + this.mCameraId));
        Object object = this.mAttachedUseCaseLock;
        synchronized (object) {
            this.reattachUseCaseSurfaces(useCase);
            this.mUseCaseAttachState.updateUseCase(useCase);
        }
        this.updateCaptureSessionConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUseCaseReset(final @NonNull UseCase useCase) {
        if (Looper.myLooper() != this.mHandler.getLooper()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Camera.this.onUseCaseReset(useCase);
                }
            });
            return;
        }
        Log.d((String)TAG, (String)("Use case " + useCase + " RESET for camera " + this.mCameraId));
        Object object = this.mAttachedUseCaseLock;
        synchronized (object) {
            this.reattachUseCaseSurfaces(useCase);
            this.mUseCaseAttachState.updateUseCase(useCase);
        }
        this.resetCaptureSession(false);
        this.updateCaptureSessionConfig();
        this.openCaptureSession();
    }

    @GuardedBy(value="mAttachedUseCaseLock")
    private void reattachUseCaseSurfaces(UseCase useCase) {
        if (!this.isUseCaseOnline(useCase)) {
            return;
        }
        SessionConfig sessionConfig = this.mUseCaseAttachState.getUseCaseSessionConfig(useCase);
        SessionConfig newSessionConfig = useCase.getSessionConfig(this.mCameraId);
        List currentSurfaces = sessionConfig.getSurfaces();
        List newSurfaces = newSessionConfig.getSurfaces();
        for (DeferrableSurface newSurface : newSurfaces) {
            if (currentSurfaces.contains(newSurface)) continue;
            newSurface.notifySurfaceAttached();
        }
        for (DeferrableSurface currentSurface : currentSurfaces) {
            if (newSurfaces.contains(currentSurface)) continue;
            currentSurface.notifySurfaceDetached();
        }
    }

    private void notifyAttachToUseCaseSurfaces(UseCase useCase) {
        for (DeferrableSurface surface : useCase.getSessionConfig(this.mCameraId).getSurfaces()) {
            surface.notifySurfaceAttached();
        }
    }

    private void notifyDetachFromUseCaseSurfaces(UseCase useCase) {
        for (DeferrableSurface surface : useCase.getSessionConfig(this.mCameraId).getSurfaces()) {
            surface.notifySurfaceDetached();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUseCaseOnline(UseCase useCase) {
        Object object = this.mAttachedUseCaseLock;
        synchronized (object) {
            return this.mUseCaseAttachState.isUseCaseOnline(useCase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnlineUseCase(final @NonNull Collection<UseCase> useCases) {
        if (useCases.isEmpty()) {
            return;
        }
        Object object = this.mPendingLock;
        synchronized (object) {
            for (UseCase useCase : useCases) {
                boolean isOnline = this.isUseCaseOnline(useCase);
                if (this.mPendingForAddOnline.contains(useCase) || isOnline) continue;
                this.notifyAttachToUseCaseSurfaces(useCase);
                this.mPendingForAddOnline.add(useCase);
            }
        }
        if (Looper.myLooper() != this.mHandler.getLooper()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Camera.this.addOnlineUseCase(useCases);
                }
            });
            return;
        }
        Log.d((String)TAG, (String)("Use cases " + useCases + " ONLINE for camera " + this.mCameraId));
        object = this.mAttachedUseCaseLock;
        synchronized (object) {
            for (UseCase useCase : useCases) {
                this.mUseCaseAttachState.setUseCaseOnline(useCase);
            }
        }
        object = this.mPendingLock;
        synchronized (object) {
            this.mPendingForAddOnline.removeAll(useCases);
        }
        this.updateCaptureSessionConfig();
        this.resetCaptureSession(false);
        if (this.mState == InternalState.OPENED) {
            this.openCaptureSession();
        } else {
            this.open();
        }
        this.updateCameraControlPreviewAspectRatio(useCases);
    }

    private void updateCameraControlPreviewAspectRatio(Collection<UseCase> useCases) {
        for (UseCase useCase : useCases) {
            if (!(useCase instanceof Preview)) continue;
            Size resolutoin = useCase.getAttachedSurfaceResolution(this.mCameraId);
            Rational aspectRatio = new Rational(resolutoin.getWidth(), resolutoin.getHeight());
            this.mCameraControlInternal.setPreviewAspectRatio(aspectRatio);
            return;
        }
    }

    private void clearCameraControlPreviewAspectRatio(Collection<UseCase> useCases) {
        for (UseCase useCase : useCases) {
            if (!(useCase instanceof Preview)) continue;
            this.mCameraControlInternal.setPreviewAspectRatio(null);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOnlineUseCase(final @NonNull Collection<UseCase> useCases) {
        if (useCases.isEmpty()) {
            return;
        }
        if (Looper.myLooper() != this.mHandler.getLooper()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Camera.this.removeOnlineUseCase(useCases);
                }
            });
            return;
        }
        Log.d((String)TAG, (String)("Use cases " + useCases + " OFFLINE for camera " + this.mCameraId));
        Object object = this.mAttachedUseCaseLock;
        synchronized (object) {
            ArrayList<UseCase> toDetach = new ArrayList<UseCase>();
            for (UseCase useCase : useCases) {
                if (this.mUseCaseAttachState.isUseCaseOnline(useCase)) {
                    toDetach.add(useCase);
                }
                this.mUseCaseAttachState.setUseCaseOffline(useCase);
            }
            for (UseCase detach : toDetach) {
                this.notifyDetachFromUseCaseSurfaces(detach);
            }
            if (this.mUseCaseAttachState.getOnlineUseCases().isEmpty()) {
                this.resetCaptureSession(true);
                this.close();
                return;
            }
        }
        this.updateCaptureSessionConfig();
        this.resetCaptureSession(false);
        if (this.mState == InternalState.OPENED) {
            this.openCaptureSession();
        }
        this.clearCameraControlPreviewAspectRatio(useCases);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public CameraInfoInternal getCameraInfoInternal() throws CameraInfoUnavailableException {
        Object object = this.mCameraInfoLock;
        synchronized (object) {
            if (this.mCameraInfoInternal == null) {
                this.mCameraInfoInternal = new Camera2CameraInfo(this.mCameraManager.unwrap(), this.mCameraId);
            }
            return this.mCameraInfoInternal;
        }
    }

    @SuppressLint(value={"MissingPermission"})
    void openCameraDevice() {
        if (!this.mCameraAvailability.isCameraAvailable()) {
            Log.d((String)TAG, (String)("No cameras available. Waiting for available camera before opening camera: " + this.mCameraId));
            this.setState(InternalState.PENDING_OPEN);
            return;
        }
        this.setState(InternalState.OPENING);
        Log.d((String)TAG, (String)("Opening camera: " + this.mCameraId));
        try {
            this.mCameraManager.openCamera(this.mCameraId, this.mExecutor, this.createDeviceStateCallback());
        }
        catch (CameraAccessException e) {
            Log.d((String)TAG, (String)("Unable to open camera " + this.mCameraId + " due to " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCaptureSessionConfig() {
        SessionConfig.ValidatingBuilder validatingBuilder;
        Object object = this.mAttachedUseCaseLock;
        synchronized (object) {
            validatingBuilder = this.mUseCaseAttachState.getActiveAndOnlineBuilder();
        }
        if (validatingBuilder.isValid()) {
            validatingBuilder.add(this.mCameraControlSessionConfig);
            SessionConfig sessionConfig = validatingBuilder.build();
            this.mCaptureSession.setSessionConfig(sessionConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void openCaptureSession() {
        SessionConfig.ValidatingBuilder validatingBuilder;
        Preconditions.checkState((this.mState == InternalState.OPENED ? 1 : 0) != 0);
        Object object = this.mAttachedUseCaseLock;
        synchronized (object) {
            validatingBuilder = this.mUseCaseAttachState.getOnlineBuilder();
        }
        if (!validatingBuilder.isValid()) {
            Log.d((String)TAG, (String)"Unable to create capture session due to conflicting configurations");
            return;
        }
        try {
            this.mCaptureSession.open(validatingBuilder.build(), this.mCameraDevice);
        }
        catch (CameraAccessException e) {
            Log.d((String)TAG, (String)("Unable to configure camera " + this.mCameraId + " due to " + e.getMessage()));
        }
        catch (DeferrableSurface.SurfaceClosedException e) {
            this.postSurfaceClosedError(e);
        }
    }

    void postSurfaceClosedError(DeferrableSurface.SurfaceClosedException e) {
        ScheduledExecutorService executor = CameraXExecutors.mainThreadExecutor();
        for (UseCase useCase : this.mUseCaseAttachState.getOnlineUseCases()) {
            List errorListeners;
            final SessionConfig sessionConfigError = useCase.getSessionConfig(this.mCameraId);
            if (!sessionConfigError.getSurfaces().contains(e.getDeferrableSurface()) || (errorListeners = sessionConfigError.getErrorListeners()).isEmpty()) continue;
            final SessionConfig.ErrorListener errorListener = (SessionConfig.ErrorListener)errorListeners.get(0);
            Log.d((String)TAG, (String)"Posting surface closed", (Throwable)new Throwable());
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    errorListener.onError(sessionConfigError, SessionConfig.SessionError.SESSION_ERROR_SURFACE_NEEDS_RESET);
                }
            });
            break;
        }
    }

    @WorkerThread
    void resetCaptureSession(boolean abortInFlightCaptures) {
        Preconditions.checkState((this.mCaptureSession != null ? 1 : 0) != 0);
        Log.d((String)TAG, (String)"Resetting Capture Session");
        CaptureSession oldCaptureSession = this.mCaptureSession;
        SessionConfig previousSessionConfig = oldCaptureSession.getSessionConfig();
        List<CaptureConfig> unissuedCaptureConfigs = oldCaptureSession.getCaptureConfigs();
        this.mCaptureSession = this.mCaptureSessionBuilder.build();
        this.mCaptureSession.setSessionConfig(previousSessionConfig);
        this.mCaptureSession.issueCaptureRequests(unissuedCaptureConfigs);
        this.releaseSession(oldCaptureSession, abortInFlightCaptures);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CameraDevice.StateCallback createDeviceStateCallback() {
        Object object = this.mAttachedUseCaseLock;
        synchronized (object) {
            SessionConfig config = this.mUseCaseAttachState.getOnlineBuilder().build();
            List configuredStateCallbacks = config.getDeviceStateCallbacks();
            ArrayList<StateCallback> allStateCallbacks = new ArrayList<StateCallback>(configuredStateCallbacks);
            allStateCallbacks.add(this.mStateCallback);
            return CameraDeviceStateCallbacks.createComboCallback(allStateCallbacks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkAndAttachRepeatingSurface(CaptureConfig.Builder captureConfigBuilder) {
        Collection activeUseCases;
        if (!captureConfigBuilder.getSurfaces().isEmpty()) {
            Log.w((String)TAG, (String)"The capture config builder already has surface inside.");
            return false;
        }
        Iterator iterator = this.mAttachedUseCaseLock;
        synchronized (iterator) {
            activeUseCases = this.mUseCaseAttachState.getActiveAndOnlineUseCases();
        }
        for (UseCase useCase : activeUseCases) {
            SessionConfig sessionConfig = useCase.getSessionConfig(this.mCameraId);
            List surfaces = sessionConfig.getRepeatingCaptureConfig().getSurfaces();
            if (surfaces.isEmpty()) continue;
            for (DeferrableSurface surface : surfaces) {
                captureConfigBuilder.addSurface(surface);
            }
        }
        if (captureConfigBuilder.getSurfaces().isEmpty()) {
            Log.w((String)TAG, (String)"Unable to find a repeating surface to attach to CaptureConfig");
            return false;
        }
        return true;
    }

    @NonNull
    public CameraControlInternal getCameraControlInternal() {
        return this.mCameraControlInternal;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    void submitCaptureRequests(final List<CaptureConfig> captureConfigs) {
        if (Looper.myLooper() != this.mHandler.getLooper()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Camera.this.submitCaptureRequests(captureConfigs);
                }
            });
            return;
        }
        ArrayList<CaptureConfig> captureConfigsWithSurface = new ArrayList<CaptureConfig>();
        for (CaptureConfig captureConfig : captureConfigs) {
            CaptureConfig.Builder builder = CaptureConfig.Builder.from((CaptureConfig)captureConfig);
            if (captureConfig.getSurfaces().isEmpty() && captureConfig.isUseRepeatingSurface() && !this.checkAndAttachRepeatingSurface(builder)) continue;
            captureConfigsWithSurface.add(builder.build());
        }
        Log.d((String)TAG, (String)("issue capture request for camera " + this.mCameraId));
        this.mCaptureSession.issueCaptureRequests(captureConfigsWithSurface);
    }

    public void onCameraControlUpdateSessionConfig(@NonNull SessionConfig sessionConfig) {
        this.mCameraControlSessionConfig = sessionConfig;
        this.updateCaptureSessionConfig();
    }

    public void onCameraControlCaptureRequests(@NonNull List<CaptureConfig> captureConfigs) {
        this.submitCaptureRequests(captureConfigs);
    }

    @NonNull
    public String toString() {
        return String.format(Locale.US, "Camera@%x[id=%s]", this.hashCode(), this.mCameraId);
    }

    @WorkerThread
    void setState(InternalState state) {
        Log.d((String)TAG, (String)("Transitioning camera internal state: " + (Object)((Object)this.mState) + " --> " + (Object)((Object)state)));
        this.mState = state;
        switch (state) {
            case INITIALIZED: {
                this.mObservableState.postValue((Object)BaseCamera.State.CLOSED);
                break;
            }
            case PENDING_OPEN: {
                this.mObservableState.postValue((Object)BaseCamera.State.PENDING_OPEN);
                break;
            }
            case OPENING: 
            case REOPENING: {
                this.mObservableState.postValue((Object)BaseCamera.State.OPENING);
                break;
            }
            case OPENED: {
                this.mObservableState.postValue((Object)BaseCamera.State.OPEN);
                break;
            }
            case CLOSING: {
                this.mObservableState.postValue((Object)BaseCamera.State.CLOSING);
                break;
            }
            case RELEASING: {
                this.mObservableState.postValue((Object)BaseCamera.State.RELEASING);
                break;
            }
            case RELEASED: {
                this.mObservableState.postValue((Object)BaseCamera.State.RELEASED);
            }
        }
    }

    String getErrorMessage(int errorCode) {
        switch (errorCode) {
            case 0: {
                return "ERROR_NONE";
            }
            case 4: {
                return "ERROR_CAMERA_DEVICE";
            }
            case 3: {
                return "ERROR_CAMERA_DISABLED";
            }
            case 1: {
                return "ERROR_CAMERA_IN_USE";
            }
            case 5: {
                return "ERROR_CAMERA_SERVICE";
            }
            case 2: {
                return "ERROR_MAX_CAMERAS_IN_USE";
            }
        }
        return "UNKNOWN ERROR";
    }

    final class CameraAvailability
    extends CameraManager.AvailabilityCallback
    implements Observable.Observer<Integer> {
        private final String mCameraId;
        private boolean mCameraAvailable = true;
        private int mNumAvailableCameras = 0;

        CameraAvailability(String cameraId) {
            this.mCameraId = cameraId;
        }

        public void onCameraAvailable(@NonNull String cameraId) {
            if (!this.mCameraId.equals(cameraId)) {
                return;
            }
            this.mCameraAvailable = true;
            if (Camera.this.mState == InternalState.PENDING_OPEN) {
                Camera.this.openCameraDevice();
            }
        }

        public void onCameraUnavailable(@NonNull String cameraId) {
            if (!this.mCameraId.equals(cameraId)) {
                return;
            }
            this.mCameraAvailable = false;
        }

        public void onNewData(@Nullable Integer value) {
            Preconditions.checkNotNull((Object)value);
            if (value != this.mNumAvailableCameras) {
                this.mNumAvailableCameras = value;
                if (Camera.this.mState == InternalState.PENDING_OPEN) {
                    Camera.this.openCameraDevice();
                }
            }
        }

        public void onError(@NonNull Throwable t) {
        }

        boolean isCameraAvailable() {
            return this.mCameraAvailable && this.mNumAvailableCameras > 0;
        }
    }

    final class StateCallback
    extends CameraDevice.StateCallback {
        StateCallback() {
        }

        public void onOpened(CameraDevice cameraDevice) {
            Log.d((String)Camera.TAG, (String)("CameraDevice.onOpened(): " + cameraDevice.getId()));
            Camera.this.mCameraDevice = cameraDevice;
            Camera.this.mCameraDeviceError = 0;
            switch (Camera.this.mState) {
                case CLOSING: 
                case RELEASING: {
                    Preconditions.checkState((boolean)Camera.this.isSessionCloseComplete());
                    Camera.this.mCameraDevice.close();
                    Camera.this.mCameraDevice = null;
                    break;
                }
                case OPENING: 
                case REOPENING: {
                    Camera.this.setState(InternalState.OPENED);
                    Camera.this.openCaptureSession();
                    break;
                }
                default: {
                    throw new IllegalStateException("onOpened() should not be possible from state: " + (Object)((Object)Camera.this.mState));
                }
            }
        }

        public void onClosed(CameraDevice cameraDevice) {
            Log.d((String)Camera.TAG, (String)("CameraDevice.onClosed(): " + cameraDevice.getId()));
            Preconditions.checkState((Camera.this.mCameraDevice == null ? 1 : 0) != 0, (String)("Unexpected onClose callback on camera device: " + cameraDevice));
            switch (Camera.this.mState) {
                case CLOSING: 
                case RELEASING: {
                    Preconditions.checkState((boolean)Camera.this.isSessionCloseComplete());
                    Camera.this.finishClose();
                    break;
                }
                case REOPENING: {
                    Camera.this.openCameraDevice();
                    break;
                }
                default: {
                    CameraX.postError((CameraX.ErrorCode)CameraX.ErrorCode.CAMERA_STATE_INCONSISTENT, (String)("Camera closed while in state: " + (Object)((Object)Camera.this.mState)));
                }
            }
        }

        public void onDisconnected(CameraDevice cameraDevice) {
            Log.d((String)Camera.TAG, (String)("CameraDevice.onDisconnected(): " + cameraDevice.getId()));
            for (CaptureSession captureSession : Camera.this.mReleasedCaptureSessions.keySet()) {
                captureSession.forceClose();
            }
            Camera.this.mCaptureSession.forceClose();
            this.onError(cameraDevice, 1);
        }

        public void onError(@NonNull CameraDevice cameraDevice, int error) {
            Camera.this.mCameraDevice = cameraDevice;
            Camera.this.mCameraDeviceError = error;
            switch (Camera.this.mState) {
                case CLOSING: 
                case RELEASING: {
                    Log.e((String)Camera.TAG, (String)("CameraDevice.onError(): " + cameraDevice.getId() + " with error: " + Camera.this.getErrorMessage(error)));
                    Camera.this.closeCamera(false);
                    break;
                }
                case OPENED: 
                case OPENING: 
                case REOPENING: {
                    this.handleErrorOnOpen(cameraDevice, error);
                    break;
                }
                default: {
                    throw new IllegalStateException("onError() should not be possible from state: " + (Object)((Object)Camera.this.mState));
                }
            }
        }

        private void handleErrorOnOpen(@NonNull CameraDevice cameraDevice, int error) {
            Preconditions.checkState((Camera.this.mState == InternalState.OPENING || Camera.this.mState == InternalState.OPENED || Camera.this.mState == InternalState.REOPENING ? 1 : 0) != 0, (String)("Attempt to handle open error from non open state: " + (Object)((Object)Camera.this.mState)));
            switch (error) {
                case 1: 
                case 2: 
                case 4: {
                    this.reopenCameraAfterError();
                    break;
                }
                default: {
                    Log.e((String)Camera.TAG, (String)("Error observed on open (or opening) camera device " + cameraDevice.getId() + ": " + Camera.this.getErrorMessage(error)));
                    Camera.this.setState(InternalState.CLOSING);
                    Camera.this.closeCamera(false);
                }
            }
        }

        private void reopenCameraAfterError() {
            Preconditions.checkState((Camera.this.mCameraDeviceError != 0 ? 1 : 0) != 0, (String)"Can only reopen camera device after error if the camera device is actually in an error state.");
            Camera.this.setState(InternalState.REOPENING);
            Camera.this.closeCamera(false);
        }
    }

    static enum InternalState {
        INITIALIZED,
        PENDING_OPEN,
        OPENING,
        OPENED,
        CLOSING,
        REOPENING,
        RELEASING,
        RELEASED;

    }
}

