/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2;

import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureRequest;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.camera.camera2.impl.CameraEventCallbacks;
import androidx.camera.core.Config;
import androidx.camera.core.MutableConfig;
import androidx.camera.core.MutableOptionsBundle;
import androidx.camera.core.OptionsBundle;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class Camera2Config
implements Config {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String CAPTURE_REQUEST_ID_STEM = "camera2.captureRequest.option.";
    static final Config.Option<Integer> TEMPLATE_TYPE_OPTION = Config.Option.create((String)"camera2.captureRequest.templateType", Integer.TYPE);
    static final Config.Option<CameraDevice.StateCallback> DEVICE_STATE_CALLBACK_OPTION = Config.Option.create((String)"camera2.cameraDevice.stateCallback", CameraDevice.StateCallback.class);
    static final Config.Option<CameraCaptureSession.StateCallback> SESSION_STATE_CALLBACK_OPTION = Config.Option.create((String)"camera2.cameraCaptureSession.stateCallback", CameraCaptureSession.StateCallback.class);
    static final Config.Option<CameraCaptureSession.CaptureCallback> SESSION_CAPTURE_CALLBACK_OPTION = Config.Option.create((String)"camera2.cameraCaptureSession.captureCallback", CameraCaptureSession.CaptureCallback.class);
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final Config.Option<CameraEventCallbacks> CAMERA_EVENT_CALLBACK_OPTION = Config.Option.create((String)"camera2.cameraEvent.callback", CameraEventCallbacks.class);
    private final Config mConfig;

    public Camera2Config(@NonNull Config config) {
        this.mConfig = config;
    }

    static Config.Option<Object> createCaptureRequestOption(CaptureRequest.Key<?> key) {
        return Config.Option.create((String)(CAPTURE_REQUEST_ID_STEM + key.getName()), Object.class, key);
    }

    @Nullable
    public <ValueT> ValueT getCaptureRequestOption(@NonNull CaptureRequest.Key<ValueT> key, @Nullable ValueT valueIfMissing) {
        Config.Option<Object> opt = Camera2Config.createCaptureRequestOption(key);
        return (ValueT)this.mConfig.retrieveOption(opt, valueIfMissing);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public Set<Config.Option<?>> getCaptureRequestOptions() {
        final HashSet optionSet = new HashSet();
        this.findOptions(CAPTURE_REQUEST_ID_STEM, new Config.OptionMatcher(){

            public boolean onOptionMatched(Config.Option<?> option) {
                optionSet.add(option);
                return true;
            }
        });
        return optionSet;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public int getCaptureRequestTemplate(int valueIfMissing) {
        return (Integer)this.mConfig.retrieveOption(TEMPLATE_TYPE_OPTION, (Object)valueIfMissing);
    }

    @Nullable
    public CameraDevice.StateCallback getDeviceStateCallback(@Nullable CameraDevice.StateCallback valueIfMissing) {
        return (CameraDevice.StateCallback)this.mConfig.retrieveOption(DEVICE_STATE_CALLBACK_OPTION, (Object)valueIfMissing);
    }

    @Nullable
    public CameraCaptureSession.StateCallback getSessionStateCallback(@Nullable CameraCaptureSession.StateCallback valueIfMissing) {
        return (CameraCaptureSession.StateCallback)this.mConfig.retrieveOption(SESSION_STATE_CALLBACK_OPTION, (Object)valueIfMissing);
    }

    @Nullable
    public CameraCaptureSession.CaptureCallback getSessionCaptureCallback(@Nullable CameraCaptureSession.CaptureCallback valueIfMissing) {
        return (CameraCaptureSession.CaptureCallback)this.mConfig.retrieveOption(SESSION_CAPTURE_CALLBACK_OPTION, (Object)valueIfMissing);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public CameraEventCallbacks getCameraEventCallback(@Nullable CameraEventCallbacks valueIfMissing) {
        return (CameraEventCallbacks)((Object)this.mConfig.retrieveOption(CAMERA_EVENT_CALLBACK_OPTION, (Object)valueIfMissing));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean containsOption(@NonNull Config.Option<?> id) {
        return this.mConfig.containsOption(id);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public <ValueT> ValueT retrieveOption(@NonNull Config.Option<ValueT> id) {
        return (ValueT)this.mConfig.retrieveOption(id);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public <ValueT> ValueT retrieveOption(@NonNull Config.Option<ValueT> id, @Nullable ValueT valueIfMissing) {
        return (ValueT)this.mConfig.retrieveOption(id, valueIfMissing);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void findOptions(@NonNull String idStem, @NonNull Config.OptionMatcher matcher) {
        this.mConfig.findOptions(idStem, matcher);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public Set<Config.Option<?>> listOptions() {
        return this.mConfig.listOptions();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Builder
    implements Config.ExtendableBuilder {
        private final MutableOptionsBundle mMutableOptionsBundle = MutableOptionsBundle.create();

        @NonNull
        public MutableConfig getMutableConfig() {
            return this.mMutableOptionsBundle;
        }

        @NonNull
        public <ValueT> Builder setCaptureRequestOption(@NonNull CaptureRequest.Key<ValueT> key, @NonNull ValueT value) {
            Config.Option<Object> opt = Camera2Config.createCaptureRequestOption(key);
            this.mMutableOptionsBundle.insertOption(opt, value);
            return this;
        }

        @NonNull
        public Builder insertAllOptions(@NonNull Config config) {
            Iterator iterator = config.listOptions().iterator();
            while (iterator.hasNext()) {
                Config.Option option;
                Config.Option objectOpt = option = (Config.Option)iterator.next();
                this.mMutableOptionsBundle.insertOption(objectOpt, config.retrieveOption(objectOpt));
            }
            return this;
        }

        @NonNull
        public Camera2Config build() {
            return new Camera2Config((Config)OptionsBundle.from((Config)this.mMutableOptionsBundle));
        }
    }

    public static final class Extender {
        Config.ExtendableBuilder mBaseBuilder;

        public Extender(@NonNull Config.ExtendableBuilder baseBuilder) {
            this.mBaseBuilder = baseBuilder;
        }

        @NonNull
        public <ValueT> Extender setCaptureRequestOption(@NonNull CaptureRequest.Key<ValueT> key, @NonNull ValueT value) {
            Config.Option<Object> opt = Camera2Config.createCaptureRequestOption(key);
            this.mBaseBuilder.getMutableConfig().insertOption(opt, value);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @NonNull
        public Extender setCaptureRequestTemplate(int templateType) {
            this.mBaseBuilder.getMutableConfig().insertOption(TEMPLATE_TYPE_OPTION, (Object)templateType);
            return this;
        }

        @NonNull
        public Extender setDeviceStateCallback(@NonNull CameraDevice.StateCallback stateCallback) {
            this.mBaseBuilder.getMutableConfig().insertOption(DEVICE_STATE_CALLBACK_OPTION, (Object)stateCallback);
            return this;
        }

        @NonNull
        public Extender setSessionStateCallback(@NonNull CameraCaptureSession.StateCallback stateCallback) {
            this.mBaseBuilder.getMutableConfig().insertOption(SESSION_STATE_CALLBACK_OPTION, (Object)stateCallback);
            return this;
        }

        @NonNull
        public Extender setSessionCaptureCallback(@NonNull CameraCaptureSession.CaptureCallback captureCallback) {
            this.mBaseBuilder.getMutableConfig().insertOption(SESSION_CAPTURE_CALLBACK_OPTION, (Object)captureCallback);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Extender setCameraEventCallback(@NonNull CameraEventCallbacks cameraEventCallbacks) {
            this.mBaseBuilder.getMutableConfig().insertOption(CAMERA_EVENT_CALLBACK_OPTION, (Object)cameraEventCallbacks);
            return this;
        }
    }
}

