/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2;

import android.content.Context;
import androidx.annotation.RestrictTo;
import androidx.camera.camera2.impl.Camera2CameraFactory;
import androidx.camera.camera2.impl.Camera2DeviceSurfaceManager;
import androidx.camera.camera2.impl.ImageAnalysisConfigProvider;
import androidx.camera.camera2.impl.ImageCaptureConfigProvider;
import androidx.camera.camera2.impl.PreviewConfigProvider;
import androidx.camera.camera2.impl.VideoCaptureConfigProvider;
import androidx.camera.core.AppConfig;
import androidx.camera.core.CameraDeviceSurfaceManager;
import androidx.camera.core.CameraFactory;
import androidx.camera.core.ConfigProvider;
import androidx.camera.core.ExtendableUseCaseConfigFactory;
import androidx.camera.core.ImageAnalysisConfig;
import androidx.camera.core.ImageCaptureConfig;
import androidx.camera.core.PreviewConfig;
import androidx.camera.core.UseCaseConfigFactory;
import androidx.camera.core.VideoCaptureConfig;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class Camera2AppConfig {
    private Camera2AppConfig() {
    }

    public static AppConfig create(Context context) {
        Camera2CameraFactory cameraFactory = new Camera2CameraFactory(context);
        Camera2DeviceSurfaceManager surfaceManager = new Camera2DeviceSurfaceManager(context);
        ExtendableUseCaseConfigFactory configFactory = new ExtendableUseCaseConfigFactory();
        configFactory.installDefaultProvider(ImageAnalysisConfig.class, (ConfigProvider)new ImageAnalysisConfigProvider(cameraFactory, context));
        configFactory.installDefaultProvider(ImageCaptureConfig.class, (ConfigProvider)new ImageCaptureConfigProvider(cameraFactory, context));
        configFactory.installDefaultProvider(VideoCaptureConfig.class, (ConfigProvider)new VideoCaptureConfigProvider(cameraFactory, context));
        configFactory.installDefaultProvider(PreviewConfig.class, (ConfigProvider)new PreviewConfigProvider(cameraFactory, context));
        AppConfig.Builder appConfigBuilder = new AppConfig.Builder().setCameraFactory((CameraFactory)cameraFactory).setDeviceSurfaceManager((CameraDeviceSurfaceManager)surfaceManager).setUseCaseConfigFactory((UseCaseConfigFactory)configFactory);
        return appConfigBuilder.build();
    }
}

