/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.gradle;

import androidx.benchmark.gradle.Adb;
import com.android.ddmlib.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J(\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Landroidx/benchmark/gradle/BenchmarkReportTask;", "Lorg/gradle/api/DefaultTask;", "()V", "adbPath", "Lorg/gradle/api/provider/Property;", "", "getAdbPath", "()Lorg/gradle/api/provider/Property;", "benchmarkReportDir", "Ljava/io/File;", "exec", "", "getReportDirForDevice", "adb", "Landroidx/benchmark/gradle/Adb;", "deviceId", "getReportsForDevice", "dataDir", "getReportsForDevices", "benchmark-gradle-plugin"})
public class BenchmarkReportTask
extends DefaultTask {
    private final File benchmarkReportDir;
    @Input
    @NotNull
    private final Property<String> adbPath;

    @NotNull
    public final Property<String> getAdbPath() {
        return this.adbPath;
    }

    @TaskAction
    public final void exec() {
        Object object = this.adbPath.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"adbPath.get()");
        String string = (String)object;
        Logger logger = this.getLogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
        this.getReportsForDevices(new Adb(string, logger));
    }

    private final void getReportsForDevices(Adb adb) {
        Iterable $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        if (this.benchmarkReportDir.exists()) {
            FilesKt.deleteRecursively((File)this.benchmarkReportDir);
        }
        this.benchmarkReportDir.mkdirs();
        Iterable $this$filter$iv = CollectionsKt.drop((Iterable)StringsKt.split$default((CharSequence)Adb.execSync$default(adb, "devices -l", null, false, false, 14, null).getStdout(), (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null), (int)1);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!StringsKt.contains$default((CharSequence)it, (CharSequence)"unauthorized", (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it;
            Regex regex = new Regex("\\s+");
            int n = 0;
            boolean bl2 = false;
            charSequence = (String)CollectionsKt.first((List)regex.split(charSequence, n));
            boolean bl3 = false;
            CharSequence charSequence2 = charSequence;
            if (charSequence2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string = ((Object)StringsKt.trim((CharSequence)charSequence2)).toString();
            collection.add(string);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!StringsKt.isBlank((CharSequence)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List deviceIds = (List)destination$iv$iv;
        for (String deviceId : deviceIds) {
            String dataDir = this.getReportDirForDevice(adb, deviceId);
            if (StringsKt.isBlank((CharSequence)dataDir)) {
                throw (Throwable)new StopExecutionException("Failed to find benchmark report on device: " + deviceId);
            }
            File outDir = new File(this.benchmarkReportDir, deviceId);
            outDir.mkdirs();
            this.getReportsForDevice(adb, outDir, dataDir, deviceId);
            Log.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Benchmark", (String)("Benchmark report files generated at " + this.benchmarkReportDir.getAbsolutePath()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void getReportsForDevice(Adb adb, File benchmarkReportDir, String dataDir, String deviceId) {
        void $this$filterTo$iv$iv;
        CharSequence charSequence;
        String it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)Adb.execSync$default(adb, "shell ls " + dataDir, deviceId, false, false, 12, null).getStdout(), (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            charSequence = it;
            boolean bl2 = false;
            void v0 = charSequence;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v0))).toString();
            collection.add(string2);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            charSequence = it;
            Regex regex = new Regex(".*benchmarkData[.](?:xml|json)$");
            boolean bl3 = false;
            if (!regex.matches(charSequence)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl = false;
            String src = dataDir + '/' + it2;
            Adb.execSync$default(adb, "pull " + src + ' ' + benchmarkReportDir + '/' + it2, deviceId, false, false, 12, null);
            Adb.execSync$default(adb, "shell rm " + src, deviceId, false, false, 12, null);
        }
    }

    private final String getReportDirForDevice(Adb adb, String deviceId) {
        String cmd = "shell content query --uri content://media/external/file --projection _data --where \"_data LIKE '%Download'\"";
        CharSequence charSequence = (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)Adb.execSync$default(adb, cmd, deviceId, false, false, 12, null).getStdout(), (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null));
        boolean bl = false;
        String string = charSequence;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        charSequence = ((Object)StringsKt.trim((CharSequence)string)).toString();
        Regex regex = new Regex("\\s+");
        int n = 0;
        boolean bl2 = false;
        charSequence = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)((CharSequence)CollectionsKt.last((List)regex.split(charSequence, n))), (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null));
        boolean bl3 = false;
        CharSequence charSequence2 = charSequence;
        if (charSequence2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)charSequence2)).toString();
    }

    public BenchmarkReportTask() {
        Property property;
        this.setGroup("Android");
        this.setDescription("Run benchmarks found in the current project and output reports to the benchmark_reports folder under the project's build directory.");
        StringBuilder stringBuilder = new StringBuilder();
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        this.benchmarkReportDir = new File(stringBuilder.append(project.getBuildDir()).append("/outputs").toString(), "connected_android_test_additional_output");
        this.getOutputs().dir((Object)this.benchmarkReportDir);
        this.getOutputs().upToDateWhen((Spec)1.INSTANCE);
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        ObjectFactory objectFactory = project2.getObjects();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectFactory, (String)"project.objects");
        ObjectFactory $this$property$iv = objectFactory;
        BenchmarkReportTask benchmarkReportTask = this;
        boolean $i$f$property = false;
        Property property2 = $this$property$iv.property(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)property2, (String)"property(T::class.java)");
        benchmarkReportTask.adbPath = property = property2;
    }
}

