/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.util.Log;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000fR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Landroidx/benchmark/WarmupManager;", "", "()V", "estimatedIterationTime", "", "getEstimatedIterationTime", "()F", "fastMovingAvg", "<set-?>", "", "iteration", "getIteration", "()I", "similarIterationCount", "slowMovingAvg", "", "totalDuration", "getTotalDuration", "()J", "logInfo", "", "onNextIteration", "", "durationNs", "Companion", "benchmark-common_release"})
public final class WarmupManager {
    private float fastMovingAvg;
    private float slowMovingAvg;
    private int similarIterationCount;
    private int iteration;
    private long totalDuration;
    private static final long MIN_DURATION_NS;
    private static final long MAX_DURATION_NS;
    public static final int MIN_ITERATIONS = 30;
    private static final int MIN_SIMILAR_ITERATIONS = 40;
    private static final float FAST_RATIO = 0.1f;
    private static final float SLOW_RATIO = 0.005f;
    private static final float THRESHOLD = 0.04f;
    public static final Companion Companion;

    public final float getEstimatedIterationTime() {
        return this.fastMovingAvg;
    }

    public final int getIteration() {
        return this.iteration;
    }

    public final long getTotalDuration() {
        return this.totalDuration;
    }

    public final boolean onNextIteration(long durationNs) {
        int n = this.iteration;
        this.iteration = n + 1;
        this.totalDuration += durationNs;
        if (this.iteration == 1) {
            this.fastMovingAvg = durationNs;
            this.slowMovingAvg = durationNs;
            return false;
        }
        this.fastMovingAvg = 0.1f * (float)durationNs + 0.9f * this.fastMovingAvg;
        this.slowMovingAvg = 0.005f * (float)durationNs + 0.995f * this.slowMovingAvg;
        float ratio = this.fastMovingAvg / this.slowMovingAvg;
        if (ratio < 1.04f && ratio > 0.96f) {
            int n2 = this.similarIterationCount;
            this.similarIterationCount = n2 + 1;
        } else {
            this.similarIterationCount = 0;
        }
        return this.iteration >= 30 && this.totalDuration >= MIN_DURATION_NS && (this.similarIterationCount > 40 || this.totalDuration >= MAX_DURATION_NS);
    }

    public final void logInfo() {
        if (this.iteration > 0) {
            String string = "Warmup: t=%.3f, iter=%d, fastAvg=%3.0f, slowAvg=%3.0f";
            Object[] objectArray = new Object[]{(double)this.totalDuration / 1.0E9, this.iteration, Float.valueOf(this.fastMovingAvg), Float.valueOf(this.slowMovingAvg)};
            String string2 = "Benchmark";
            boolean bl = false;
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(this, *args)");
            String string4 = string3;
            Log.d((String)string2, (String)string4);
        }
    }

    static {
        Companion = new Companion(null);
        MIN_DURATION_NS = TimeUnit.MILLISECONDS.toNanos(250L);
        MAX_DURATION_NS = TimeUnit.SECONDS.toNanos(8L);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Landroidx/benchmark/WarmupManager$Companion;", "", "()V", "FAST_RATIO", "", "MAX_DURATION_NS", "", "getMAX_DURATION_NS", "()J", "MIN_DURATION_NS", "getMIN_DURATION_NS", "MIN_ITERATIONS", "", "MIN_SIMILAR_ITERATIONS", "SLOW_RATIO", "THRESHOLD", "benchmark-common_release"})
    public static final class Companion {
        public final long getMIN_DURATION_NS() {
            return MIN_DURATION_NS;
        }

        public final long getMAX_DURATION_NS() {
            return MAX_DURATION_NS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

