/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.os.Build;
import android.os.Process;
import android.util.Log;
import androidx.annotation.GuardedBy;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0004J\u0006\u0010\u0015\u001a\u00020\u0004J\u0006\u0010\u0016\u001a\u00020\u0013J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Landroidx/benchmark/ThreadPriority;", "", "()V", "BENCH_THREAD_PRIORITY", "", "HIGH_PRIORITY", "JIT_INITIAL_PRIORITY", "getJIT_INITIAL_PRIORITY", "()I", "JIT_THREAD_NAME", "", "JIT_THREAD_PRIORITY", "JIT_TID", "Ljava/lang/Integer;", "TASK_PATH", "initialPriority", "initialTid", "lock", "bumpCurrentThreadPriority", "", "get", "getJit", "resetBumpedThread", "setThreadPriority", "", "label", "tid", "priority", "benchmark-common_release"})
public final class ThreadPriority {
    public static final int HIGH_PRIORITY = -20;
    private static final int BENCH_THREAD_PRIORITY = -20;
    private static final int JIT_THREAD_PRIORITY = -15;
    private static final String TASK_PATH = "/proc/self/task";
    private static final String JIT_THREAD_NAME = "Jit thread pool";
    private static final Integer JIT_TID;
    private static final int JIT_INITIAL_PRIORITY;
    private static final Object lock;
    @GuardedBy(value="lock")
    private static int initialTid;
    @GuardedBy(value="lock")
    private static int initialPriority;
    public static final ThreadPriority INSTANCE;

    public final int getJIT_INITIAL_PRIORITY() {
        return JIT_INITIAL_PRIORITY;
    }

    private final boolean setThreadPriority(String label, int tid, int priority) {
        int previousPriority = Process.getThreadPriority((int)tid);
        try {
            Process.setThreadPriority((int)tid, (int)priority);
        }
        catch (SecurityException e) {
            return false;
        }
        int newPriority = Process.getThreadPriority((int)tid);
        if (newPriority != previousPriority) {
            Log.d((String)"Benchmark", (String)("Set " + tid + " (" + label + ") to priority " + priority + ". Was " + previousPriority + ", now " + newPriority));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void bumpCurrentThreadPriority() {
        Object object = lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            int myTid = Process.myTid();
            if (initialTid == myTid) {
                return;
            }
            INSTANCE.resetBumpedThread();
            initialTid = myTid;
            initialPriority = Process.getThreadPriority((int)initialTid);
            INSTANCE.setThreadPriority("Bench thread", initialTid, -20);
            if (JIT_TID != null) {
                INSTANCE.setThreadPriority("Jit", JIT_TID, -15);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resetBumpedThread() {
        Object object = lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            if (initialTid > 0) {
                INSTANCE.setThreadPriority("Bench thread", initialTid, initialPriority);
                if (JIT_TID != null) {
                    INSTANCE.setThreadPriority("Jit", JIT_TID, JIT_INITIAL_PRIORITY);
                }
                initialTid = -1;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final int getJit() {
        Integer n = JIT_TID;
        boolean bl = false;
        boolean bl2 = false;
        if (n == null) {
            boolean bl3 = false;
            String string = "Jit thread not found!";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return Process.getThreadPriority((int)JIT_TID);
    }

    public final int get() {
        return Process.getThreadPriority((int)Process.myTid());
    }

    private ThreadPriority() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        ThreadPriority threadPriority;
        INSTANCE = threadPriority = new ThreadPriority();
        if (Build.VERSION.SDK_INT > 21) {
            Map map;
            int capacity$iv2;
            boolean $i$f$associateBy;
            File[] $this$associateBy$iv;
            File[] fileArray = new File(TASK_PATH).listFiles();
            if (fileArray != null) {
                void $this$associateByTo$iv$iv;
                $this$associateBy$iv = fileArray;
                $i$f$associateBy = false;
                capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
                File[] fileArray2 = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv2);
                boolean $i$f$associateByTo = false;
                void var8_12 = $this$associateByTo$iv$iv;
                int n = ((void)var8_12).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void element$iv$iv;
                    void var12_21 = element$iv$iv = var8_12[i];
                    Map map2 = destination$iv$iv;
                    boolean bl = false;
                    void v1 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                    String string = v1.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name");
                    String string2 = string;
                    boolean bl2 = false;
                    Integer n2 = Integer.parseInt(string2);
                    it = element$iv$iv;
                    boolean bl3 = false;
                    try {
                        String string3 = (String)CollectionsKt.firstOrNull((List)FilesKt.readLines$default((File)new File((File)it, "comm"), null, (int)1, null));
                        if (string3 == null) {
                            string3 = "";
                        }
                        string2 = string3;
                    }
                    catch (IOException e) {
                        string2 = "ERROR READING THREAD NAME";
                    }
                    String string4 = string2;
                    map2.put(n2, string4);
                }
                map = destination$iv$iv;
            } else {
                map = null;
            }
            Map tidsToNames = map;
            $this$associateBy$iv = tidsToNames;
            $i$f$associateBy = false;
            capacity$iv2 = 0;
            if ($this$associateBy$iv == null || $this$associateBy$iv.isEmpty()) {
                Log.d((String)"Benchmark", (String)"NOTE: Couldn't find threads in this process for priority pinning.");
                JIT_TID = null;
            } else {
                void $this$filterTo$iv$iv;
                Map $this$filter$iv = tidsToNames;
                boolean $i$f$filter = false;
                Map capacity$iv2 = $this$filter$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$filterTo = false;
                void $i$f$associateByTo = $this$filterTo$iv$iv;
                boolean bl = false;
                Iterator iterator = $i$f$associateByTo.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv$iv;
                    Map.Entry it = element$iv$iv = iterator.next();
                    boolean bl4 = false;
                    if (!StringsKt.startsWith$default((String)((String)it.getValue()), (String)JIT_THREAD_NAME, (boolean)false, (int)2, null)) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                JIT_TID = (Integer)CollectionsKt.firstOrNull((Iterable)destination$iv$iv.keySet());
                if (JIT_TID == null) {
                    Log.d((String)"Benchmark", (String)"NOTE: Couldn't JIT thread, threads found:");
                    Map $this$forEach$iv = tidsToNames;
                    boolean $i$f$forEach = false;
                    Map map3 = $this$forEach$iv;
                    boolean bl5 = false;
                    Iterator iterator2 = map3.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry element$iv;
                        Map.Entry it = element$iv = iterator2.next();
                        boolean bl6 = false;
                        Log.d((String)"Benchmark", (String)("    tid: " + ((Number)it.getKey()).intValue() + ", name:'" + (String)it.getValue() + '\''));
                    }
                }
            }
        } else {
            JIT_TID = null;
        }
        JIT_INITIAL_PRIORITY = JIT_TID != null ? Process.getThreadPriority((int)JIT_TID) : 0;
        lock = new Object();
        initialTid = -1;
        initialPriority = Integer.MAX_VALUE;
    }
}

