/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u000e\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\bR\u0011\u0010\u0015\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\f\u00a8\u0006\u0018"}, d2={"Landroidx/benchmark/Stats;", "", "data", "", "", "(Ljava/util/List;)V", "max", "getMax", "()J", "mean", "", "getMean", "()D", "median", "getMedian", "min", "getMin", "percentile90", "getPercentile90", "percentile95", "getPercentile95", "standardDeviation", "getStandardDeviation", "Companion", "benchmark-common_release"})
public final class Stats {
    private final long median;
    private final long min;
    private final long max;
    private final long percentile90;
    private final long percentile95;
    private final double mean;
    private final double standardDeviation;
    public static final Companion Companion = new Companion(null);

    public final long getMedian() {
        return this.median;
    }

    public final long getMin() {
        return this.min;
    }

    public final long getMax() {
        return this.max;
    }

    public final long getPercentile90() {
        return this.percentile90;
    }

    public final long getPercentile95() {
        return this.percentile95;
    }

    public final double getMean() {
        return this.mean;
    }

    public final double getStandardDeviation() {
        return this.standardDeviation;
    }

    /*
     * WARNING - void declaration
     */
    public Stats(@NotNull List<Long> data) {
        double d;
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        this.mean = CollectionsKt.averageOfLong((Iterable)data);
        List values = CollectionsKt.sorted((Iterable)new ArrayList(data));
        int size = values.size();
        if (size < 1) {
            throw (Throwable)new IllegalArgumentException("At least one result is necessary.");
        }
        Object object = CollectionsKt.first((List)values);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"values.first()");
        this.min = ((Number)object).longValue();
        Object object2 = CollectionsKt.last((List)values);
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"values.last()");
        this.max = ((Number)object2).longValue();
        this.median = Companion.getPercentile$benchmark_common_release(values, 50);
        this.percentile90 = Companion.getPercentile$benchmark_common_release(values, 90);
        this.percentile95 = Companion.getPercentile$benchmark_common_release(values, 95);
        Stats stats = this;
        if (size == 1) {
            d = DoubleCompanionObject.INSTANCE.getNaN();
        } else {
            Collection<Double> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = values;
            Stats stats2 = stats;
            boolean $i$f$map = false;
            void var8_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Long l = (Long)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                double d2 = (double)it.longValue() - this.mean;
                int n = 2;
                boolean bl2 = false;
                Double d3 = Math.pow(d2, n);
                collection.add(d3);
            }
            collection = (List)destination$iv$iv;
            stats = stats2;
            double sum = CollectionsKt.sumOfDouble((Iterable)collection);
            d = Math.sqrt(sum / (double)(size - 1));
        }
        stats.standardDeviation = d;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ%\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Landroidx/benchmark/Stats$Companion;", "", "()V", "getPercentile", "", "data", "", "percentile", "", "getPercentile$benchmark_common_release", "lerp", "a", "b", "ratio", "", "lerp$benchmark_common_release", "benchmark-common_release"})
    public static final class Companion {
        public final long lerp$benchmark_common_release(long a, long b, double ratio) {
            return MathKt.roundToLong((double)((double)a * (1.0 - ratio) + (double)b * ratio));
        }

        public final long getPercentile$benchmark_common_release(@NotNull List<Long> data, int percentile) {
            Long l;
            Intrinsics.checkParameterIsNotNull(data, (String)"data");
            double idealIndex = (double)RangesKt.coerceIn((int)percentile, (int)0, (int)100) / 100.0 * (double)(data.size() - 1);
            int firstIndex = (int)idealIndex;
            int secondIndex = firstIndex + 1;
            long firstValue = ((Number)data.get(firstIndex)).longValue();
            List<Long> list = data;
            boolean bl = false;
            if (secondIndex >= 0 && secondIndex <= CollectionsKt.getLastIndex(list)) {
                l = list.get(secondIndex);
            } else {
                int it = secondIndex;
                boolean bl2 = false;
                l = firstValue;
            }
            long secondValue = ((Number)l).longValue();
            return this.lerp$benchmark_common_release(firstValue, secondValue, idealIndex - (double)firstIndex);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

