/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.content.IntentFilter;
import android.os.Build;
import android.util.Log;
import androidx.benchmark.Arguments;
import androidx.benchmark.CpuInfo;
import androidx.benchmark.IsolationActivity;
import androidx.test.platform.app.InstrumentationRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006J\u0017\u0010\u0012\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u00060\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\u0011\u0010\u0015\u001a\u00020\u0006*\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Landroidx/benchmark/Errors;", "", "()V", "MINIMUM_BATTERY_PERCENT", "", "PREFIX", "", "getPREFIX", "()Ljava/lang/String;", "TAG", "UNSUPPRESSED_WARNING_MESSAGE", "getUNSUPPRESSED_WARNING_MESSAGE", "isDeviceRooted", "", "isEmulator", "()Z", "warningString", "acquireWarningStringForLogging", "toDisplayString", "", "toDisplayString$benchmark_common_release", "trimMarginWrapNewlines", "trimMarginWrapNewlines$benchmark_common_release", "benchmark-common_release"})
public final class Errors {
    private static final String TAG = "Benchmark";
    @NotNull
    private static final String PREFIX;
    @Nullable
    private static final String UNSUPPRESSED_WARNING_MESSAGE;
    private static String warningString;
    private static final int MINIMUM_BATTERY_PERCENT = 25;
    private static final boolean isEmulator;
    private static final boolean isDeviceRooted;
    public static final Errors INSTANCE;

    @NotNull
    public final String trimMarginWrapNewlines$benchmark_common_release(@NotNull String $this$trimMarginWrapNewlines) {
        Intrinsics.checkParameterIsNotNull((Object)$this$trimMarginWrapNewlines, (String)"$this$trimMarginWrapNewlines");
        return "\n" + StringsKt.trimMargin$default((String)$this$trimMarginWrapNewlines, null, (int)1, null) + " \n";
    }

    @NotNull
    public final String toDisplayString$benchmark_common_release(@NotNull Set<String> $this$toDisplayString) {
        Intrinsics.checkParameterIsNotNull($this$toDisplayString, (String)"$this$toDisplayString");
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)CollectionsKt.toList((Iterable)$this$toDisplayString)), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final String getPREFIX() {
        return PREFIX;
    }

    @Nullable
    public final String getUNSUPPRESSED_WARNING_MESSAGE() {
        return UNSUPPRESSED_WARNING_MESSAGE;
    }

    @Nullable
    public final String acquireWarningStringForLogging() {
        String ret = warningString;
        warningString = null;
        return ret;
    }

    public final boolean isEmulator() {
        return isEmulator;
    }

    private Errors() {
    }

    /*
     * Unable to fully structure code
     */
    static {
        block17: {
            block18: {
                Errors.INSTANCE = var0 = new Errors();
                v0 = Build.FINGERPRINT;
                Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"Build.FINGERPRINT");
                if (StringsKt.startsWith$default((String)v0, (String)"generic", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v1 = Build.FINGERPRINT;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"Build.FINGERPRINT");
                if (StringsKt.startsWith$default((String)v1, (String)"unknown", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v2 = Build.MODEL;
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"Build.MODEL");
                if (StringsKt.contains$default((CharSequence)v2, (CharSequence)"google_sdk", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v3 = Build.MODEL;
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"Build.MODEL");
                if (StringsKt.contains$default((CharSequence)v3, (CharSequence)"Emulator", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v4 = Build.MODEL;
                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"Build.MODEL");
                if (StringsKt.contains$default((CharSequence)v4, (CharSequence)"Android SDK built for x86", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v5 = Build.MANUFACTURER;
                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"Build.MANUFACTURER");
                if (StringsKt.contains$default((CharSequence)v5, (CharSequence)"Genymotion", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v6 = Build.BRAND;
                Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"Build.BRAND");
                if (!StringsKt.startsWith$default((String)v6, (String)"generic", (boolean)false, (int)2, null)) break block18;
                v7 = Build.DEVICE;
                Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"Build.DEVICE");
                if (StringsKt.startsWith$default((String)v7, (String)"generic", (boolean)false, (int)2, null)) ** GOTO lbl-1000
            }
            if (Intrinsics.areEqual((Object)"google_sdk", (Object)Build.PRODUCT)) lbl-1000:
            // 8 sources

            {
                v8 = true;
            } else {
                v8 = false;
            }
            Errors.isEmulator = v8;
            $this$any$iv = new String[]{"/system/app/Superuser.apk", "/sbin/su", "/system/bin/su", "/system/xbin/su", "/data/local/xbin/su", "/data/local/bin/su", "/system/sd/xbin/su", "/system/bin/failsafe/su", "/data/local/su", "/su/bin/su"};
            $i$f$any = false;
            var3_4 = $this$any$iv;
            var4_5 = var3_4.length;
            for (var5_7 = 0; var5_7 < var4_5; ++var5_7) {
                it = element$iv = var3_4[var5_7];
                $i$a$-any-Errors$isDeviceRooted$1 = false;
                if (!new File(it).exists()) continue;
                v9 = true;
                break block17;
            }
            v9 = false;
        }
        Errors.isDeviceRooted = v9;
        v10 = InstrumentationRegistry.getInstrumentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"InstrumentationRegistry.getInstrumentation()");
        v11 = context = v10.getTargetContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"context");
        appInfo = v11.getApplicationInfo();
        warningPrefix = "";
        warningString = "";
        if ((appInfo.flags & 2) != 0) {
            warningPrefix = warningPrefix + "DEBUGGABLE_";
            warningString = warningString + var0.trimMarginWrapNewlines$benchmark_common_release("\n                |WARNING: Debuggable Benchmark\n                |    Benchmark is running with debuggable=true, which drastically reduces\n                |    runtime performance in order to support debugging features. Run\n                |    benchmarks with debuggable=false. Debuggable affects execution speed\n                |    in ways that mean benchmark improvements might not carry over to a\n                |    real user's experience (or even regress release performance).\n            ");
        }
        if (Errors.isEmulator) {
            warningPrefix = warningPrefix + "EMULATOR_";
            warningString = warningString + var0.trimMarginWrapNewlines$benchmark_common_release("\n                |WARNING: Running on Emulator\n                |    Benchmark is running on an emulator, which is not representative of\n                |    real user devices. Use a physical device to benchmark. Emulator\n                |    benchmark improvements might not carry over to a real user's\n                |    experience (or even regress real device performance).\n            ");
        }
        v12 = Build.FINGERPRINT;
        Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"Build.FINGERPRINT");
        if (StringsKt.contains$default((CharSequence)v12, (CharSequence)":eng/", (boolean)false, (int)2, null)) {
            warningPrefix = warningPrefix + "ENG-BUILD_";
            warningString = warningString + var0.trimMarginWrapNewlines$benchmark_common_release("\n                |WARNING: Running on Eng Build\n                |    Benchmark is running on device flashed with a '-eng' build. Eng builds\n                |    of the platform drastically reduce performance to enable testing\n                |    changes quickly. For this reason they should not be used for\n                |    benchmarking. Use a '-user' or '-userdebug' system image.\n            ");
        }
        if (Intrinsics.areEqual((Object)(arguments = InstrumentationRegistry.getArguments()).get("coverage"), (Object)"true")) {
            warningPrefix = warningPrefix + "CODE-COVERAGE_";
            warningString = warningString + var0.trimMarginWrapNewlines$benchmark_common_release("\n                |WARNING: Code coverage enabled\n                |    Benchmark is running with code coverage enabled, which typically alters the dex\n                |    in a way that can affect performance. Ensure that code coverage is disabled by\n                |    setting testCoverageEnabled to false in the buildType your benchmarks run in.\n            ");
        }
        if (Errors.isDeviceRooted && !CpuInfo.INSTANCE.getLocked()) {
            warningPrefix = warningPrefix + "UNLOCKED_";
            warningString = warningString + var0.trimMarginWrapNewlines$benchmark_common_release("\n                |WARNING: Unlocked CPU clocks\n                |    Benchmark appears to be running on a rooted device with unlocked CPU\n                |    clocks. Unlocked CPU clocks can lead to inconsistent results due to\n                |    dynamic frequency scaling, and thermal throttling. On a rooted device,\n                |    lock your device clocks to a stable frequency with `./gradlew lockClocks`\n            ");
        }
        if (!CpuInfo.INSTANCE.getLocked() && IsolationActivity.Companion.isSustainedPerformanceModeSupported$benchmark_common_release() && !IsolationActivity.Companion.getSustainedPerformanceModeInUse$benchmark_common_release()) {
            warningPrefix = warningPrefix + "UNSUSTAINED-ACTIVITY-MISSING_";
            warningString = warningString + var0.trimMarginWrapNewlines$benchmark_common_release("\n                |WARNING: Cannot use SustainedPerformanceMode without IsolationActivity\n                |    Benchmark running on device that supports Window.setSustainedPerformanceMode,\n                |    but not launching IsolationActivity via the AndroidBenchmarkRunner. This\n                |    Activity is required to limit CPU clock max frequency, to prevent thermal\n                |    throttling. To fix this, add the following to your benchmark module-level\n                |    build.gradle:\n                |        android.defaultConfig.testInstrumentationRunner\n                |            = \"androidx.benchmark.junit4.AndroidBenchmarkRunner\"\n            ");
        } else if (IsolationActivity.Companion.getSingleton$benchmark_common_release().get() == null) {
            warningPrefix = warningPrefix + "ACTIVITY-MISSING_";
            warningString = warningString + var0.trimMarginWrapNewlines$benchmark_common_release("\n                |WARNING: Not using IsolationActivity via AndroidBenchmarkRunner\n                |    AndroidBenchmarkRunner should be used to isolate benchmarks from interference\n                |    from other visible apps. To fix this, add the following to your module-level\n                |    build.gradle:\n                |        android.defaultConfig.testInstrumentationRunner\n                |            = \"androidx.benchmark.junit4.AndroidBenchmarkRunner\"\n            ");
        }
        filter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        v13 = context.registerReceiver(null, filter);
        if (v13 != null) {
            $i$a$-any-Errors$isDeviceRooted$1 = v13;
            var9_15 = false;
            var10_17 = false;
            $this$run = $i$a$-any-Errors$isDeviceRooted$1;
            $i$a$-run-Errors$batteryPercent$1 = false;
            level = $this$run.getIntExtra("level", 100);
            scale = $this$run.getIntExtra("scale", 100);
            v14 = level * 100 / scale;
        } else {
            v14 = batteryPercent = 100;
        }
        if (batteryPercent < 25) {
            warningPrefix = warningPrefix + "LOW-BATTERY_";
            warningString = warningString + var0.trimMarginWrapNewlines$benchmark_common_release("\n                |WARNING: Device has low battery (" + batteryPercent + "%)\n                |    When battery is low, devices will often reduce performance (e.g. disabling big\n                |    cores) to save remaining battery. This occurs even when they are plugged in.\n                |    Wait for your battery to charge to at least 25%.\n                |    Currently at " + batteryPercent + "%.\n            ");
        }
        Errors.PREFIX = warningPrefix;
        $i$a$-any-Errors$isDeviceRooted$1 = warningString;
        var9_15 = false;
        if ($i$a$-any-Errors$isDeviceRooted$1.length() > 0) {
            Errors.warningString = warningString;
            $this$map$iv = StringsKt.split$default((CharSequence)warningString, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
            $i$f$map = false;
            var10_18 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var15_29 = (String)item$iv$iv;
                var20_32 = destination$iv$iv;
                $i$a$-map-Errors$1 = false;
                var21_33 = Log.w((String)"Benchmark", (String)it);
                var20_32.add(var21_33);
            }
            (List)destination$iv$iv;
        }
        $this$filter$iv = StringsKt.split$default((CharSequence)Errors.PREFIX, (char[])new char[]{'_'}, (boolean)false, (int)0, (int)6, null);
        $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            $i$a$-filter-Errors$warningSet$1 = false;
            var18_35 = it;
            var19_36 = false;
            if (!(var18_35.length() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        warningSet = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        unsuppressedWarningSet = SetsKt.minus((Set)warningSet, (Iterable)Arguments.INSTANCE.getSuppressedErrors());
        var10_19 = unsuppressedWarningSet;
        var11_21 = false;
        Errors.UNSUPPRESSED_WARNING_MESSAGE = var10_19.isEmpty() == false != false ? StringsKt.trimMargin$default((String)("\n                |ERRORS (not suppressed): " + var0.toDisplayString$benchmark_common_release(unsuppressedWarningSet) + "\n                |(Suppressed errors: " + var0.toDisplayString$benchmark_common_release(Arguments.INSTANCE.getSuppressedErrors()) + ")\n                |" + warningString + "\n                |While you can suppress these errors (turning them into warnings)\n                |PLEASE NOTE THAT EACH SUPPRESSED ERROR COMPROMISES ACCURACY\n                |\n                |// Sample suppression, in a benchmark module's build.gradle:\n                |android {\n                |    defaultConfig {\n                |        // Enable measuring on an emulator, or devices with low battery\n                |        testInstrumentationRunnerArgument\n                |                'androidx.benchmark.suppressErrors', 'EMULATOR,LOW_BATTERY'\n                |    }\n                |}\n            "), null, (int)1, null) : null;
    }
}

