/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0012\u001a\u00020\u000b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Landroidx/benchmark/CpuInfo;", "", "()V", "TAG", "", "coreDirs", "", "Landroidx/benchmark/CpuInfo$CoreDir;", "getCoreDirs", "()Ljava/util/List;", "locked", "", "getLocked", "()Z", "maxFreqHz", "", "getMaxFreqHz", "()J", "isCpuLocked", "readFileTextOrNull", "path", "CoreDir", "benchmark-common_release"})
public final class CpuInfo {
    private static final String TAG = "Benchmark";
    @NotNull
    private static final List<CoreDir> coreDirs;
    private static final boolean locked;
    private static final long maxFreqHz;
    public static final CpuInfo INSTANCE;

    @NotNull
    public final List<CoreDir> getCoreDirs() {
        return coreDirs;
    }

    public final boolean getLocked() {
        return locked;
    }

    public final long getMaxFreqHz() {
        return maxFreqHz;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isCpuLocked(@NotNull List<CoreDir> coreDirs) {
        boolean bl;
        block15: {
            boolean bl2;
            boolean $i$f$any;
            Iterable $this$any$iv;
            List onlineCores;
            block14: {
                boolean bl3;
                block13: {
                    void $this$filterTo$iv$iv;
                    Intrinsics.checkParameterIsNotNull(coreDirs, (String)"coreDirs");
                    Iterable $this$filter$iv = coreDirs;
                    boolean $i$f$filter = false;
                    Iterator iterator = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        CoreDir it = (CoreDir)element$iv$iv;
                        boolean bl4 = false;
                        if (!it.getOnline()) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    onlineCores = (List)destination$iv$iv;
                    $this$any$iv = onlineCores;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            CoreDir it = (CoreDir)element$iv;
                            boolean bl5 = false;
                            if (!(Intrinsics.areEqual((Object)((Integer)CollectionsKt.max((Iterable)it.getAvailableFreqs())), (Object)((Integer)CollectionsKt.max((Iterable)((CoreDir)onlineCores.get(0)).getAvailableFreqs()))) ^ true)) continue;
                            bl3 = true;
                            break block13;
                        }
                        bl3 = false;
                    }
                }
                if (bl3) {
                    Log.d((String)TAG, (String)"Clocks not locked: cores with different max frequencies");
                    return false;
                }
                $this$any$iv = onlineCores;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        CoreDir it = (CoreDir)element$iv;
                        boolean bl6 = false;
                        if (!(it.getCurrentMinFreq() != ((CoreDir)onlineCores.get(0)).getCurrentMinFreq())) continue;
                        bl2 = true;
                        break block14;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                Log.d((String)TAG, (String)"Clocks not locked: cores with different current min freq");
                return false;
            }
            $this$any$iv = onlineCores;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CoreDir it = (CoreDir)element$iv;
                    boolean bl7 = false;
                    Integer n = (Integer)CollectionsKt.min((Iterable)it.getAvailableFreqs());
                    int n2 = it.getCurrentMinFreq();
                    if (!(n != null && n == n2)) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
        }
        if (bl) {
            Log.d((String)TAG, (String)"Clocks not locked: online cores with min freq == min avail freq");
            return false;
        }
        return true;
    }

    private final String readFileTextOrNull(String path) {
        try {
            String string;
            File file = new File(path);
            boolean bl = false;
            boolean bl2 = false;
            File $this$run = file;
            boolean bl3 = false;
            if ($this$run.exists()) {
                String string2 = FilesKt.readText$default((File)$this$run, null, (int)1, null);
                boolean bl4 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            } else {
                string = null;
            }
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }

    private CpuInfo() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        Object v6;
        void $this$filterTo$iv$iv;
        List list;
        int n;
        int n2;
        Iterable $this$mapTo$iv$iv;
        Collection destination$iv$iv;
        CpuInfo cpuInfo;
        block22: {
            block19: {
                INSTANCE = cpuInfo = new CpuInfo();
                File cpuDir = new File("/sys/devices/system/cpu");
                String[] stringArray = cpuDir.list(1.INSTANCE);
                if (stringArray == null) break block19;
                String[] $this$map$iv = stringArray;
                boolean $i$f$map = false;
                String[] stringArray2 = $this$map$iv;
                destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                Iterable iterable = $this$mapTo$iv$iv;
                n2 = ((Iterable)iterable).length;
                for (n = 0; n < n2; ++n) {
                    long l;
                    int n3;
                    Object object;
                    boolean bl;
                    Object object2;
                    Object object3;
                    boolean bl2;
                    String path;
                    Collection collection;
                    block21: {
                        block20: {
                            void $this$mapTo$iv$iv2;
                            void $this$map$iv2;
                            String it;
                            void $this$filterTo$iv$iv2;
                            Iterable $this$filter$iv;
                            void it2;
                            Object item$iv$iv;
                            Object object4 = item$iv$iv = iterable[n];
                            collection = destination$iv$iv;
                            boolean bl3 = false;
                            path = cpuDir.getPath() + '/' + (String)it2;
                            bl2 = Intrinsics.areEqual((Object)INSTANCE.readFileTextOrNull(path + "/online"), (Object)"0") ^ true;
                            object3 = INSTANCE.readFileTextOrNull(path + "/cpufreq/scaling_available_frequencies");
                            if (object3 == null) break block20;
                            object2 = (CharSequence)object3;
                            Regex regex = new Regex("\\s+");
                            bl = bl2;
                            int n4 = 0;
                            boolean bl4 = false;
                            object = regex.split((CharSequence)object2, n4);
                            bl2 = bl;
                            object3 = object;
                            if (object3 == null) break block20;
                            object2 = (Iterable)object3;
                            bl = bl2;
                            boolean $i$f$filter = false;
                            void var21_34 = $this$filter$iv;
                            Collection destination$iv$iv2 = new ArrayList();
                            boolean $i$f$filterTo = false;
                            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                                it = (String)element$iv$iv;
                                boolean bl5 = false;
                                CharSequence charSequence = it;
                                boolean bl6 = false;
                                if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
                                destination$iv$iv2.add(element$iv$iv);
                            }
                            object = (List)destination$iv$iv2;
                            $this$filter$iv = (Iterable)object;
                            boolean $i$f$map2 = false;
                            $this$filterTo$iv$iv2 = $this$map$iv2;
                            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                            boolean $i$f$mapTo2 = false;
                            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                                it = (String)item$iv$iv2;
                                object = destination$iv$iv2;
                                boolean bl7 = false;
                                Integer n5 = Integer.parseInt(it);
                                object.add(n5);
                            }
                            object = (List)destination$iv$iv2;
                            bl2 = bl;
                            object3 = CollectionsKt.sorted((Iterable)((Iterable)object));
                            if (object3 != null) break block21;
                        }
                        object3 = CollectionsKt.listOf((Object)-1);
                    }
                    if (INSTANCE.readFileTextOrNull(path + "/cpufreq/scaling_min_freq") != null) {
                        object = object3;
                        bl = bl2;
                        boolean bl8 = false;
                        int n6 = Integer.parseInt((String)object2);
                        bl2 = bl;
                        object3 = object;
                        n3 = n6;
                    } else {
                        n3 = -1;
                    }
                    if (INSTANCE.readFileTextOrNull(path + "/cpuinfo_max_freq") != null) {
                        int n7 = n3;
                        object = object3;
                        bl = bl2;
                        boolean bl9 = false;
                        long l2 = Long.parseLong((String)object2);
                        bl2 = bl;
                        object3 = object;
                        n3 = n7;
                        l = l2;
                    } else {
                        l = -1L;
                    }
                    long l3 = l;
                    int n8 = n3;
                    Object object5 = object3;
                    boolean bl10 = bl2;
                    CoreDir coreDir = new CoreDir(bl10, (List<Integer>)object5, n8, l3);
                    collection.add(coreDir);
                }
                list = (List)destination$iv$iv;
                break block22;
            }
            list = CollectionsKt.emptyList();
        }
        coreDirs = list;
        Iterable $this$filter$iv = coreDirs;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CoreDir it = (CoreDir)element$iv$iv;
            boolean bl = false;
            if (!(it.getMaxFreqKhz() != -1L)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$maxBy$iv = (List)destination$iv$iv;
        boolean $i$f$maxBy = false;
        Iterator iterator$iv = $this$maxBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v6 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v6 = maxElem$iv;
            } else {
                CoreDir it = (CoreDir)maxElem$iv;
                boolean bl = false;
                long maxValue$iv = it.getMaxFreqKhz();
                do {
                    Object e$iv = iterator$iv.next();
                    CoreDir it3 = (CoreDir)e$iv;
                    $i$a$-maxBy-CpuInfo$4 = false;
                    long v$iv = it3.getMaxFreqKhz();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v6 = maxElem$iv;
            }
        }
        CoreDir coreDir = v6;
        maxFreqHz = coreDir != null ? coreDir.getMaxFreqKhz() * (long)1000 : -1L;
        locked = cpuInfo.isCpuLocked(coreDirs);
        if (!locked) {
            Iterable $this$forEachIndexed$iv = coreDirs;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void coreDir2;
                int n9 = index$iv++;
                n2 = 0;
                if (n9 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                n = n9;
                CoreDir bl = (CoreDir)item$iv;
                int index = n;
                boolean bl11 = false;
                Log.d((String)TAG, (String)("cpu" + index + ' ' + coreDir2));
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0012\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J7\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00032\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Landroidx/benchmark/CpuInfo$CoreDir;", "", "online", "", "availableFreqs", "", "", "currentMinFreq", "maxFreqKhz", "", "(ZLjava/util/List;IJ)V", "getAvailableFreqs", "()Ljava/util/List;", "getCurrentMinFreq", "()I", "getMaxFreqKhz", "()J", "getOnline", "()Z", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "", "benchmark-common_release"})
    public static final class CoreDir {
        private final boolean online;
        @NotNull
        private final List<Integer> availableFreqs;
        private final int currentMinFreq;
        private final long maxFreqKhz;

        public final boolean getOnline() {
            return this.online;
        }

        @NotNull
        public final List<Integer> getAvailableFreqs() {
            return this.availableFreqs;
        }

        public final int getCurrentMinFreq() {
            return this.currentMinFreq;
        }

        public final long getMaxFreqKhz() {
            return this.maxFreqKhz;
        }

        public CoreDir(boolean online, @NotNull List<Integer> availableFreqs, int currentMinFreq, long maxFreqKhz) {
            Intrinsics.checkParameterIsNotNull(availableFreqs, (String)"availableFreqs");
            this.online = online;
            this.availableFreqs = availableFreqs;
            this.currentMinFreq = currentMinFreq;
            this.maxFreqKhz = maxFreqKhz;
        }

        public final boolean component1() {
            return this.online;
        }

        @NotNull
        public final List<Integer> component2() {
            return this.availableFreqs;
        }

        public final int component3() {
            return this.currentMinFreq;
        }

        public final long component4() {
            return this.maxFreqKhz;
        }

        @NotNull
        public final CoreDir copy(boolean online, @NotNull List<Integer> availableFreqs, int currentMinFreq, long maxFreqKhz) {
            Intrinsics.checkParameterIsNotNull(availableFreqs, (String)"availableFreqs");
            return new CoreDir(online, availableFreqs, currentMinFreq, maxFreqKhz);
        }

        public static /* synthetic */ CoreDir copy$default(CoreDir coreDir, boolean bl, List list, int n, long l, int n2, Object object) {
            if ((n2 & 1) != 0) {
                bl = coreDir.online;
            }
            if ((n2 & 2) != 0) {
                list = coreDir.availableFreqs;
            }
            if ((n2 & 4) != 0) {
                n = coreDir.currentMinFreq;
            }
            if ((n2 & 8) != 0) {
                l = coreDir.maxFreqKhz;
            }
            return coreDir.copy(bl, list, n, l);
        }

        @NotNull
        public String toString() {
            return "CoreDir(online=" + this.online + ", availableFreqs=" + this.availableFreqs + ", currentMinFreq=" + this.currentMinFreq + ", maxFreqKhz=" + this.maxFreqKhz + ")";
        }

        public int hashCode() {
            int n = this.online ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            List<Integer> list = this.availableFreqs;
            return ((n * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + Integer.hashCode(this.currentMinFreq)) * 31 + Long.hashCode(this.maxFreqKhz);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CoreDir)) break block3;
                    CoreDir coreDir = (CoreDir)object;
                    if (!(this.online == coreDir.online) || !Intrinsics.areEqual(this.availableFreqs, coreDir.availableFreqs) || !(this.currentMinFreq == coreDir.currentMinFreq) || !(this.maxFreqKhz == coreDir.maxFreqKhz)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

