/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.os.Bundle;
import android.util.Log;
import androidx.annotation.IntRange;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.benchmark.Arguments;
import androidx.benchmark.CpuInfo;
import androidx.benchmark.Errors;
import androidx.benchmark.IsolationActivity;
import androidx.benchmark.ResultWriter;
import androidx.benchmark.Stats;
import androidx.benchmark.ThreadPriority;
import androidx.benchmark.ThrottleDetector;
import androidx.benchmark.TraceCompatKt;
import androidx.benchmark.WarmupManager;
import androidx.test.platform.app.InstrumentationRegistry;
import java.lang.annotation.ElementType;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Experimental;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.AnnotationTarget;
import kotlin.annotation.Retention;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u0000 E2\u00020\u0001:\u0002EFB\u0007\b\u0017\u00a2\u0006\u0002\u0010\u0002J\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020#H\u0002J\u001f\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020\n2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0082\bJ\b\u0010*\u001a\u00020\u0006H\u0002J\b\u0010+\u001a\u00020#H\u0002J\u0015\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020)H\u0000\u00a2\u0006\u0002\b/J\b\u00100\u001a\u00020\fH\u0007J\u001d\u00101\u001a\u0002022\u0006\u00103\u001a\u00020)2\u0006\u00104\u001a\u00020)H\u0000\u00a2\u0006\u0002\b5J\u0006\u00106\u001a\u00020\nJ\t\u00107\u001a\u00020\nH\u0087\bJ\b\u00108\u001a\u00020\nH\u0001J\u0006\u00109\u001a\u00020#J \u0010:\u001a\u00020#2\u0006\u0010;\u001a\u00020)2\u0006\u0010<\u001a\u00020)2\u0006\u0010=\u001a\u00020)H\u0007J\u0006\u0010>\u001a\u00020#J\u0010\u0010?\u001a\u00020#2\u0006\u00103\u001a\u00020)H\u0002J\u0010\u0010@\u001a\u00020\n2\u0006\u0010A\u001a\u00020\fH\u0002J\b\u0010B\u001a\u00020\nH\u0002J\b\u0010C\u001a\u00020)H\u0002J\b\u0010D\u001a\u00020#H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u00068\u0000@\u0000X\u0081\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Landroidx/benchmark/BenchmarkState;", "", "()V", "internalStats", "Landroidx/benchmark/Stats;", "iterationsRemaining", "", "iterationsRemaining$annotations", "maxIterations", "paused", "", "pausedDurationNs", "", "pausedTimeNs", "performThrottleChecks", "getPerformThrottleChecks$benchmark_common_release", "()Z", "setPerformThrottleChecks$benchmark_common_release", "(Z)V", "repeatCount", "results", "Ljava/util/ArrayList;", "startTimeNs", "state", "stats", "getStats$benchmark_common_release", "()Landroidx/benchmark/Stats;", "thermalThrottleSleepSeconds", "throttleRemainingRetries", "totalRunTimeNs", "totalRunTimeStartNs", "warmupIteration", "warmupManager", "Landroidx/benchmark/WarmupManager;", "beginBenchmark", "", "beginWarmup", "check", "value", "lazyMessage", "Lkotlin/Function0;", "", "computeIterationsFromWarmup", "endBenchmark", "getFullStatusReport", "Landroid/os/Bundle;", "key", "getFullStatusReport$benchmark_common_release", "getMin", "getReport", "Landroidx/benchmark/BenchmarkState$Report;", "testName", "className", "getReport$benchmark_common_release", "keepRunning", "keepRunningInline", "keepRunningInternal", "pauseTiming", "report", "fullClassName", "simpleClassName", "methodName", "resumeTiming", "sendStatus", "sleepIfThermalThrottled", "sleepSeconds", "startNextTestRun", "summaryLine", "throwIfPaused", "Companion", "Report", "benchmark-common_release"})
public final class BenchmarkState {
    private int warmupIteration;
    @JvmField
    public int iterationsRemaining = -1;
    private int maxIterations;
    private int state;
    private final WarmupManager warmupManager = new WarmupManager();
    private long startTimeNs;
    private boolean paused;
    private long pausedTimeNs;
    private long pausedDurationNs;
    private long thermalThrottleSleepSeconds;
    private long totalRunTimeStartNs;
    private long totalRunTimeNs;
    private int repeatCount;
    private Stats internalStats;
    private final ArrayList<Long> results;
    private boolean performThrottleChecks;
    private int throttleRemainingRetries;
    @NotNull
    public static final String TAG = "Benchmark";
    private static final String STUDIO_OUTPUT_KEY_PREFIX = "android.studio.display.";
    private static final String STUDIO_OUTPUT_KEY_ID = "benchmark";
    private static final boolean ENABLE_PROFILING = false;
    private static final int NOT_STARTED = 0;
    private static final int WARMUP = 1;
    private static final int RUNNING = 2;
    private static final int FINISHED = 3;
    private static final int REPEAT_COUNT;
    private static final Integer OVERRIDE_ITERATIONS;
    private static final long TARGET_TEST_DURATION_NS;
    private static final int MAX_TEST_ITERATIONS = 1000000;
    private static final int MIN_TEST_ITERATIONS = 1;
    private static final int THROTTLE_MAX_RETRIES = 3;
    private static final long THROTTLE_BACKOFF_S = 90L;
    private static boolean firstBenchmark;
    public static final Companion Companion;

    @PublishedApi
    public static /* synthetic */ void iterationsRemaining$annotations() {
    }

    public final boolean getPerformThrottleChecks$benchmark_common_release() {
        return this.performThrottleChecks;
    }

    public final void setPerformThrottleChecks$benchmark_common_release(boolean bl) {
        this.performThrottleChecks = bl;
    }

    @NotNull
    public final Stats getStats$benchmark_common_release() {
        BenchmarkState benchmarkState = this;
        boolean value$iv = this.state != 0;
        boolean $i$f$check = false;
        if (!value$iv) {
            String string;
            ThreadPriority.INSTANCE.resetBumpedThread();
            boolean bl = false;
            String string2 = string = "The benchmark wasn't started! Every test in a class with a BenchmarkRule must contain a benchmark. In Kotlin, call benchmarkRule.measureRepeated {}, or in Java, call benchmarkRule.getState().keepRunning() to run your benchmark.";
            throw (Throwable)new IllegalStateException(string2);
        }
        BenchmarkState this_$iv = this;
        value$iv = this.state == 3;
        $i$f$check = false;
        if (!value$iv) {
            String string;
            ThreadPriority.INSTANCE.resetBumpedThread();
            boolean bl = false;
            String string3 = string = "The benchmark hasn't finished! In Java, use while(BenchmarkState.keepRunning()) to ensure keepRunning() returns false before ending your test. In Kotlin, just use benchmarkRule.measureRepeated {} to avoid the problem.";
            throw (Throwable)new IllegalStateException(string3);
        }
        Stats stats = this.internalStats;
        if (stats == null) {
            Intrinsics.throwNpe();
        }
        return stats;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final long getMin() {
        return this.getStats$benchmark_common_release().getMin();
    }

    public final void pauseTiming() {
        BenchmarkState benchmarkState = this;
        boolean value$iv = !this.paused;
        boolean $i$f$check = false;
        if (!value$iv) {
            String string;
            ThreadPriority.INSTANCE.resetBumpedThread();
            boolean bl = false;
            String string2 = string = "Unable to pause the benchmark. The benchmark has already paused.";
            throw (Throwable)new IllegalStateException(string2);
        }
        this.pausedTimeNs = System.nanoTime();
        this.paused = true;
    }

    public final void resumeTiming() {
        BenchmarkState benchmarkState = this;
        boolean value$iv = this.paused;
        boolean $i$f$check = false;
        if (!value$iv) {
            String string;
            ThreadPriority.INSTANCE.resetBumpedThread();
            boolean bl = false;
            String string2 = string = "Unable to resume the benchmark. The benchmark is already running.";
            throw (Throwable)new IllegalStateException(string2);
        }
        this.pausedDurationNs += System.nanoTime() - this.pausedTimeNs;
        this.pausedTimeNs = 0L;
        this.paused = false;
    }

    private final void beginWarmup() {
        TraceCompatKt.beginTraceSection("Warmup");
        Runtime.getRuntime().gc();
        this.startTimeNs = System.nanoTime();
        this.warmupIteration = 0;
        this.state = 1;
    }

    private final void beginBenchmark() {
        Integer n = OVERRIDE_ITERATIONS;
        this.maxIterations = n != null ? n.intValue() : this.computeIterationsFromWarmup();
        this.pausedDurationNs = 0L;
        this.iterationsRemaining = this.maxIterations;
        this.repeatCount = 0;
        this.thermalThrottleSleepSeconds = 0L;
        this.state = 2;
        TraceCompatKt.beginTraceSection(TAG);
        this.startTimeNs = System.nanoTime();
    }

    /*
     * WARNING - void declaration
     */
    private final void endBenchmark() {
        TraceCompatKt.endTraceSection();
        ThreadPriority.INSTANCE.resetBumpedThread();
        this.warmupManager.logInfo();
        Iterable $this$forEachIndexed$iv = CollectionsKt.chunked((Iterable)this.results, (int)10);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            String string;
            void list;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            List list2 = (List)item$iv;
            int i = n2;
            boolean bl2 = false;
            String string2 = "Results[%2d:%2d]: %s";
            Object[] objectArray = new Object[]{i * 10, (i + 1) * 10, CollectionsKt.joinToString$default((Iterable)((Iterable)list), null, null, null, (int)0, null, null, (int)63, null)};
            String string3 = TAG;
            boolean bl3 = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(this, *args)");
            Log.d((String)string3, (String)string);
        }
        this.internalStats = new Stats((List<Long>)this.results);
        this.state = 3;
        this.totalRunTimeNs = System.nanoTime() - this.totalRunTimeStartNs;
    }

    private final int computeIterationsFromWarmup() {
        int idealIterations = (int)((float)TARGET_TEST_DURATION_NS / this.warmupManager.getEstimatedIterationTime());
        return RangesKt.coerceIn((int)idealIterations, (int)1, (int)1000000);
    }

    private final boolean startNextTestRun() {
        long currentTime = System.nanoTime();
        this.results.add((currentTime - this.startTimeNs - this.pausedDurationNs) / (long)this.maxIterations);
        int n = this.repeatCount;
        this.repeatCount = n + 1;
        if (this.repeatCount >= REPEAT_COUNT) {
            if (this.performThrottleChecks && this.throttleRemainingRetries > 0 && this.sleepIfThermalThrottled(90L)) {
                --this.throttleRemainingRetries;
                this.results.clear();
                this.repeatCount = 0;
            } else {
                this.endBenchmark();
                return false;
            }
        }
        this.pausedDurationNs = 0L;
        this.iterationsRemaining = this.maxIterations;
        this.startTimeNs = System.nanoTime();
        return true;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final boolean keepRunningInline() {
        int $i$f$keepRunningInline = 0;
        if (this.iterationsRemaining > 1) {
            int n = this.iterationsRemaining;
            this.iterationsRemaining = n + -1;
            return true;
        }
        return this.keepRunningInternal();
    }

    public final boolean keepRunning() {
        if (this.iterationsRemaining > 1) {
            int n = this.iterationsRemaining;
            this.iterationsRemaining = n + -1;
            return true;
        }
        return this.keepRunningInternal();
    }

    private final void check(boolean value, Function0<String> lazyMessage) {
        int $i$f$check = 0;
        if (!value) {
            ThreadPriority.INSTANCE.resetBumpedThread();
            throw (Throwable)new IllegalStateException((String)lazyMessage.invoke());
        }
    }

    @PublishedApi
    public final boolean keepRunningInternal() {
        switch (this.state) {
            case 0: {
                if (Errors.INSTANCE.getUNSUPPRESSED_WARNING_MESSAGE() != null) {
                    throw (Throwable)((Object)new AssertionError((Object)Errors.INSTANCE.getUNSUPPRESSED_WARNING_MESSAGE()));
                }
                if (!firstBenchmark && Arguments.INSTANCE.getStartupMode()) {
                    throw (Throwable)((Object)new AssertionError((Object)"Error - multiple benchmarks in startup mode. Only one benchmark may be run per 'am instrument' call, to ensure result isolation."));
                }
                firstBenchmark = false;
                if (this.totalRunTimeStartNs == 0L) {
                    this.totalRunTimeStartNs = System.nanoTime();
                }
                if (this.performThrottleChecks && !CpuInfo.INSTANCE.getLocked() && !IsolationActivity.Companion.getSustainedPerformanceModeInUse$benchmark_common_release() && !Errors.INSTANCE.isEmulator()) {
                    ThrottleDetector.INSTANCE.computeThrottleBaseline();
                }
                ThreadPriority.INSTANCE.bumpCurrentThreadPriority();
                if (Arguments.INSTANCE.getDryRunMode() || Arguments.INSTANCE.getStartupMode()) {
                    this.beginBenchmark();
                } else {
                    this.beginWarmup();
                }
                return true;
            }
            case 1: {
                int n = this.warmupIteration;
                this.warmupIteration = n + 1;
                long time = System.nanoTime();
                long lastDuration = time - this.startTimeNs;
                this.startTimeNs = time;
                this.throwIfPaused();
                if (this.warmupManager.onNextIteration(lastDuration)) {
                    TraceCompatKt.endTraceSection();
                    this.beginBenchmark();
                }
                return true;
            }
            case 2: {
                int n = this.iterationsRemaining;
                this.iterationsRemaining = n + -1;
                if (this.iterationsRemaining <= 0) {
                    this.throwIfPaused();
                    return this.startNextTestRun();
                }
                return true;
            }
            case 3: {
                throw (Throwable)new IllegalStateException("The benchmark has finished.");
            }
        }
        throw (Throwable)new IllegalStateException("The benchmark is in unknown state.");
    }

    private final void throwIfPaused() {
        if (this.paused) {
            throw (Throwable)new IllegalStateException("Benchmark step finished with paused state. Resume the benchmark before finishing each step.");
        }
    }

    @NotNull
    public final Report getReport$benchmark_common_release(@NotNull String testName, @NotNull String className) {
        Intrinsics.checkParameterIsNotNull((Object)testName, (String)"testName");
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        return new Report(className, testName, this.totalRunTimeNs, (List<Long>)this.results, this.maxIterations, this.thermalThrottleSleepSeconds, this.warmupIteration);
    }

    private final String summaryLine() {
        return "Summary: " + "median=" + this.getStats$benchmark_common_release().getMedian() + "ns, " + "mean=" + (long)this.getStats$benchmark_common_release().getMean() + "ns, " + "min=" + this.getStats$benchmark_common_release().getMin() + "ns, " + "stddev=" + (long)this.getStats$benchmark_common_release().getStandardDeviation() + "ns, " + "count=" + this.maxIterations;
    }

    @NotNull
    public final Bundle getFullStatusReport$benchmark_common_release(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Log.i((String)TAG, (String)(key + this.summaryLine()));
        Bundle status = new Bundle();
        status.putLong(Errors.INSTANCE.getPREFIX() + "median", this.getStats$benchmark_common_release().getMedian());
        status.putLong(Errors.INSTANCE.getPREFIX() + "mean", (long)this.getStats$benchmark_common_release().getMean());
        status.putLong(Errors.INSTANCE.getPREFIX() + "min", this.getStats$benchmark_common_release().getMin());
        status.putLong(Errors.INSTANCE.getPREFIX() + "standardDeviation", (long)this.getStats$benchmark_common_release().getStandardDeviation());
        status.putLong(Errors.INSTANCE.getPREFIX() + "count", (long)this.maxIterations);
        Companion.putIdeSummaryLine$benchmark_common_release(status, key, this.getStats$benchmark_common_release().getMin());
        return status;
    }

    private final void sendStatus(String testName) {
        Bundle bundle = this.getFullStatusReport$benchmark_common_release(testName);
        InstrumentationRegistry.getInstrumentation().sendStatus(-1, bundle);
    }

    private final boolean sleepIfThermalThrottled(long sleepSeconds) {
        boolean bl;
        if (ThrottleDetector.INSTANCE.isDeviceThermalThrottled()) {
            Log.d((String)TAG, (String)("THERMAL THROTTLE DETECTED, SLEEPING FOR " + sleepSeconds + " SECONDS"));
            long startTime = System.nanoTime();
            Thread.sleep(TimeUnit.SECONDS.toMillis(sleepSeconds));
            long sleepTime = System.nanoTime() - startTime;
            this.thermalThrottleSleepSeconds += TimeUnit.NANOSECONDS.toSeconds(sleepTime);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void report(@NotNull String fullClassName, @NotNull String simpleClassName, @NotNull String methodName) {
        Intrinsics.checkParameterIsNotNull((Object)fullClassName, (String)"fullClassName");
        Intrinsics.checkParameterIsNotNull((Object)simpleClassName, (String)"simpleClassName");
        Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
        String fullTestName = Errors.INSTANCE.getPREFIX() + simpleClassName + '.' + methodName;
        this.sendStatus(fullTestName);
        ResultWriter.INSTANCE.appendReport(this.getReport$benchmark_common_release(Errors.INSTANCE.getPREFIX() + methodName, fullClassName));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public BenchmarkState() {
        ArrayList arrayList = new ArrayList();
        BenchmarkState benchmarkState = this;
        boolean bl = false;
        boolean bl2 = false;
        ArrayList $this$apply = arrayList;
        boolean bl3 = false;
        $this$apply.ensureCapacity(REPEAT_COUNT);
        ArrayList arrayList2 = arrayList;
        benchmarkState.results = arrayList2;
        this.performThrottleChecks = true;
        this.throttleRemainingRetries = 3;
    }

    static {
        Companion = new Companion(null);
        REPEAT_COUNT = Arguments.INSTANCE.getDryRunMode() ? 1 : (Arguments.INSTANCE.getStartupMode() ? 10 : 50);
        OVERRIDE_ITERATIONS = Arguments.INSTANCE.getDryRunMode() || Arguments.INSTANCE.getStartupMode() ? Integer.valueOf(1) : null;
        TARGET_TEST_DURATION_NS = TimeUnit.MICROSECONDS.toNanos(500L);
        firstBenchmark = true;
    }

    @JvmStatic
    @Companion.ExperimentalExternalReport
    public static final void reportData(@NotNull String className, @NotNull String testName, @IntRange(from=0L) long totalRunTimeNs, @NotNull List<Long> dataNs, @IntRange(from=0L) int warmupIterations, @IntRange(from=0L) long thermalThrottleSleepSeconds, @IntRange(from=1L) int repeatIterations) {
        Companion.reportData(className, testName, totalRunTimeNs, dataNs, warmupIterations, thermalThrottleSleepSeconds, repeatIterations);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0080\b\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u00c6\u0003J\t\u0010!\u001a\u00020\nH\u00c6\u0003J\t\u0010\"\u001a\u00020\u0006H\u00c6\u0003J\t\u0010#\u001a\u00020\nH\u00c6\u0003JU\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\f\u001a\u00020\nH\u00c6\u0001J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020\nH\u00d6\u0001J\t\u0010)\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u0011\u0010\f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013\u00a8\u0006*"}, d2={"Landroidx/benchmark/BenchmarkState$Report;", "", "className", "", "testName", "totalRunTimeNs", "", "data", "", "repeatIterations", "", "thermalThrottleSleepSeconds", "warmupIterations", "(Ljava/lang/String;Ljava/lang/String;JLjava/util/List;IJI)V", "getClassName", "()Ljava/lang/String;", "getData", "()Ljava/util/List;", "getRepeatIterations", "()I", "stats", "Landroidx/benchmark/Stats;", "getStats", "()Landroidx/benchmark/Stats;", "getTestName", "getThermalThrottleSleepSeconds", "()J", "getTotalRunTimeNs", "getWarmupIterations", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "toString", "benchmark-common_release"})
    public static final class Report {
        @NotNull
        private final Stats stats;
        @NotNull
        private final String className;
        @NotNull
        private final String testName;
        private final long totalRunTimeNs;
        @NotNull
        private final List<Long> data;
        private final int repeatIterations;
        private final long thermalThrottleSleepSeconds;
        private final int warmupIterations;

        @NotNull
        public final Stats getStats() {
            return this.stats;
        }

        @NotNull
        public final String getClassName() {
            return this.className;
        }

        @NotNull
        public final String getTestName() {
            return this.testName;
        }

        public final long getTotalRunTimeNs() {
            return this.totalRunTimeNs;
        }

        @NotNull
        public final List<Long> getData() {
            return this.data;
        }

        public final int getRepeatIterations() {
            return this.repeatIterations;
        }

        public final long getThermalThrottleSleepSeconds() {
            return this.thermalThrottleSleepSeconds;
        }

        public final int getWarmupIterations() {
            return this.warmupIterations;
        }

        public Report(@NotNull String className, @NotNull String testName, long totalRunTimeNs, @NotNull List<Long> data, int repeatIterations, long thermalThrottleSleepSeconds, int warmupIterations) {
            Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
            Intrinsics.checkParameterIsNotNull((Object)testName, (String)"testName");
            Intrinsics.checkParameterIsNotNull(data, (String)"data");
            this.className = className;
            this.testName = testName;
            this.totalRunTimeNs = totalRunTimeNs;
            this.data = data;
            this.repeatIterations = repeatIterations;
            this.thermalThrottleSleepSeconds = thermalThrottleSleepSeconds;
            this.warmupIterations = warmupIterations;
            this.stats = new Stats(this.data);
        }

        @NotNull
        public final String component1() {
            return this.className;
        }

        @NotNull
        public final String component2() {
            return this.testName;
        }

        public final long component3() {
            return this.totalRunTimeNs;
        }

        @NotNull
        public final List<Long> component4() {
            return this.data;
        }

        public final int component5() {
            return this.repeatIterations;
        }

        public final long component6() {
            return this.thermalThrottleSleepSeconds;
        }

        public final int component7() {
            return this.warmupIterations;
        }

        @NotNull
        public final Report copy(@NotNull String className, @NotNull String testName, long totalRunTimeNs, @NotNull List<Long> data, int repeatIterations, long thermalThrottleSleepSeconds, int warmupIterations) {
            Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
            Intrinsics.checkParameterIsNotNull((Object)testName, (String)"testName");
            Intrinsics.checkParameterIsNotNull(data, (String)"data");
            return new Report(className, testName, totalRunTimeNs, data, repeatIterations, thermalThrottleSleepSeconds, warmupIterations);
        }

        public static /* synthetic */ Report copy$default(Report report, String string, String string2, long l, List list, int n, long l2, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = report.className;
            }
            if ((n3 & 2) != 0) {
                string2 = report.testName;
            }
            if ((n3 & 4) != 0) {
                l = report.totalRunTimeNs;
            }
            if ((n3 & 8) != 0) {
                list = report.data;
            }
            if ((n3 & 0x10) != 0) {
                n = report.repeatIterations;
            }
            if ((n3 & 0x20) != 0) {
                l2 = report.thermalThrottleSleepSeconds;
            }
            if ((n3 & 0x40) != 0) {
                n2 = report.warmupIterations;
            }
            return report.copy(string, string2, l, list, n, l2, n2);
        }

        @NotNull
        public String toString() {
            return "Report(className=" + this.className + ", testName=" + this.testName + ", totalRunTimeNs=" + this.totalRunTimeNs + ", data=" + this.data + ", repeatIterations=" + this.repeatIterations + ", thermalThrottleSleepSeconds=" + this.thermalThrottleSleepSeconds + ", warmupIterations=" + this.warmupIterations + ")";
        }

        public int hashCode() {
            String string = this.className;
            String string2 = this.testName;
            List<Long> list = this.data;
            return ((((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + Long.hashCode(this.totalRunTimeNs)) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + Integer.hashCode(this.repeatIterations)) * 31 + Long.hashCode(this.thermalThrottleSleepSeconds)) * 31 + Integer.hashCode(this.warmupIterations);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Report)) break block3;
                    Report report = (Report)object;
                    if (!Intrinsics.areEqual((Object)this.className, (Object)report.className) || !Intrinsics.areEqual((Object)this.testName, (Object)report.testName) || !(this.totalRunTimeNs == report.totalRunTimeNs) || !Intrinsics.areEqual(this.data, report.data) || !(this.repeatIterations == report.repeatIterations) || !(this.thermalThrottleSleepSeconds == report.thermalThrottleSleepSeconds) || !(this.warmupIterations == report.warmupIterations)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001-B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u001eJ\u0018\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0016H\u0002JN\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u00122\b\b\u0001\u0010$\u001a\u00020\u00162\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00160&2\b\b\u0001\u0010'\u001a\u00020\u00062\b\b\u0001\u0010(\u001a\u00020\u00162\b\b\u0001\u0010)\u001a\u00020\u0006H\u0007J!\u0010*\u001a\u00020!*\u00020+2\u0006\u0010#\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b,R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u001c\u0010\f\u001a\u00020\u00068\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Landroidx/benchmark/BenchmarkState$Companion;", "", "()V", "ENABLE_PROFILING", "", "FINISHED", "", "MAX_TEST_ITERATIONS", "MIN_TEST_ITERATIONS", "NOT_STARTED", "OVERRIDE_ITERATIONS", "Ljava/lang/Integer;", "REPEAT_COUNT", "REPEAT_COUNT$annotations", "getREPEAT_COUNT$benchmark_common_release", "()I", "RUNNING", "STUDIO_OUTPUT_KEY_ID", "", "STUDIO_OUTPUT_KEY_PREFIX", "TAG", "TARGET_TEST_DURATION_NS", "", "THROTTLE_BACKOFF_S", "THROTTLE_MAX_RETRIES", "WARMUP", "firstBenchmark", "ideSummaryLine", "key", "nanos", "ideSummaryLine$benchmark_common_release", "ideSummaryLineWrapped", "reportData", "", "className", "testName", "totalRunTimeNs", "dataNs", "", "warmupIterations", "thermalThrottleSleepSeconds", "repeatIterations", "putIdeSummaryLine", "Landroid/os/Bundle;", "putIdeSummaryLine$benchmark_common_release", "ExperimentalExternalReport", "benchmark-common_release"})
    public static final class Companion {
        @VisibleForTesting
        public static /* synthetic */ void REPEAT_COUNT$annotations() {
        }

        public final int getREPEAT_COUNT$benchmark_common_release() {
            return REPEAT_COUNT;
        }

        @JvmStatic
        @ExperimentalExternalReport
        public final void reportData(@NotNull String className, @NotNull String testName, @IntRange(from=0L) long totalRunTimeNs, @NotNull List<Long> dataNs, @IntRange(from=0L) int warmupIterations, @IntRange(from=0L) long thermalThrottleSleepSeconds, @IntRange(from=1L) int repeatIterations) {
            Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
            Intrinsics.checkParameterIsNotNull((Object)testName, (String)"testName");
            Intrinsics.checkParameterIsNotNull(dataNs, (String)"dataNs");
            Report report = new Report(className, testName, totalRunTimeNs, dataNs, repeatIterations, thermalThrottleSleepSeconds, warmupIterations);
            Bundle bundle = new Bundle();
            CharSequence charSequence = className;
            StringBuilder stringBuilder = new StringBuilder().append(Errors.INSTANCE.getPREFIX());
            boolean bl = false;
            boolean bl2 = charSequence.length() > 0;
            String fullTestName = stringBuilder.append(bl2 ? className + '.' + testName : testName).toString();
            this.putIdeSummaryLine$benchmark_common_release(bundle, fullTestName, report.getStats().getMin());
            InstrumentationRegistry.getInstrumentation().sendStatus(-1, bundle);
            ResultWriter.INSTANCE.appendReport(report);
        }

        /*
         * Unable to fully structure code
         */
        private final String ideSummaryLineWrapped(String key, long nanos) {
            v0 = Errors.INSTANCE.acquireWarningStringForLogging();
            if (v0 == null || (v0 = StringsKt.split$default((CharSequence)((CharSequence)v0), (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null)) == null) {
                var5_3 = false;
                v0 = CollectionsKt.emptyList();
            }
            warningLines = v0;
            $this$filterIndexed$iv = CollectionsKt.plus((Collection)((Collection)warningLines), (Object)this.ideSummaryLine$benchmark_common_release(key, nanos));
            $i$f$filterIndexed = false;
            var7_7 = $this$filterIndexed$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterIndexedTo = false;
            $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
            $i$f$forEachIndexed = false;
            index$iv$iv$iv = 0;
            for (T item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                var15_15 = index$iv$iv$iv++;
                var16_16 = false;
                if (var15_15 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                var17_17 = var15_15;
                var18_18 = item$iv$iv$iv;
                index$iv$iv = var17_17;
                $i$a$-forEachIndexed-CollectionsKt___CollectionsKt$filterIndexedTo$1$iv = false;
                var21_21 = (String)element$iv$iv;
                index = index$iv$iv;
                $i$a$-filterIndexed-BenchmarkState$Companion$ideSummaryLineWrapped$1 = false;
                if (index != 0) ** GOTO lbl-1000
                var24_24 = (CharSequence)it;
                var25_25 = false;
                if (var24_24.length() > 0) lbl-1000:
                // 2 sources

                {
                    v1 = true;
                } else {
                    v1 = false;
                }
                if (!v1) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\nbenchmark: ", null, null, (int)0, null, null, (int)62, null);
        }

        @NotNull
        public final String ideSummaryLine$benchmark_common_release(@NotNull String key, long nanos) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%13s ns %s";
            Object[] objectArray = new Object[]{NumberFormat.getNumberInstance().format(nanos), key};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            return string2;
        }

        public final void putIdeSummaryLine$benchmark_common_release(@NotNull Bundle $this$putIdeSummaryLine, @NotNull String testName, long nanos) {
            Intrinsics.checkParameterIsNotNull((Object)$this$putIdeSummaryLine, (String)"$this$putIdeSummaryLine");
            Intrinsics.checkParameterIsNotNull((Object)testName, (String)"testName");
            $this$putIdeSummaryLine.putString("android.studio.display.benchmark", this.ideSummaryLineWrapped(testName, nanos));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Retention(value=AnnotationRetention.BINARY)
        @kotlin.annotation.Target(allowedTargets={AnnotationTarget.FUNCTION})
        @java.lang.annotation.Retention(value=RetentionPolicy.CLASS)
        @Target(value={ElementType.METHOD})
        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Landroidx/benchmark/BenchmarkState$Companion$ExperimentalExternalReport;", "", "benchmark-common_release"})
        @Experimental
        public static @interface ExperimentalExternalReport {
        }
    }
}

