/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.support.annotation.NavigationRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.util.Xml;
import androidx.navigation.NavAction;
import androidx.navigation.NavDestination;
import androidx.navigation.NavGraph;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import androidx.navigation.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class NavInflater {
    private static final String TAG_ARGUMENT = "argument";
    private static final String TAG_DEEP_LINK = "deepLink";
    private static final String TAG_ACTION = "action";
    private static final String TAG_INCLUDE = "include";
    private static final String APPLICATION_ID_PLACEHOLDER = "${applicationId}";
    private static final ThreadLocal<TypedValue> sTmpValue = new ThreadLocal();
    private Context mContext;
    private NavigatorProvider mNavigatorProvider;

    public NavInflater(@NonNull Context context, @NonNull NavigatorProvider navigatorProvider) {
        this.mContext = context;
        this.mNavigatorProvider = navigatorProvider;
    }

    @SuppressLint(value={"ResourceType"})
    @NonNull
    public NavGraph inflate(@NavigationRes int graphResId) {
        Resources res = this.mContext.getResources();
        XmlResourceParser parser = res.getXml(graphResId);
        AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
        try {
            int type;
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                throw new XmlPullParserException("No start tag found");
            }
            String rootElement = parser.getName();
            NavDestination destination = this.inflate(res, parser, attrs);
            if (!(destination instanceof NavGraph)) {
                throw new IllegalArgumentException("Root element <" + rootElement + ">" + " did not inflate into a NavGraph");
            }
            NavGraph navGraph = (NavGraph)destination;
            return navGraph;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception inflating " + res.getResourceName(graphResId) + " line " + parser.getLineNumber(), e);
        }
        finally {
            parser.close();
        }
    }

    @NonNull
    private NavDestination inflate(@NonNull Resources res, @NonNull XmlResourceParser parser, @NonNull AttributeSet attrs) throws XmlPullParserException, IOException {
        int depth;
        int type;
        Navigator navigator = this.mNavigatorProvider.getNavigator(parser.getName());
        NavDestination dest = navigator.createDestination();
        dest.onInflate(this.mContext, attrs);
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            if (type != 2 || depth > innerDepth) continue;
            String name = parser.getName();
            if (TAG_ARGUMENT.equals(name)) {
                this.inflateArgument(res, dest, attrs);
                continue;
            }
            if (TAG_DEEP_LINK.equals(name)) {
                this.inflateDeepLink(res, dest, attrs);
                continue;
            }
            if (TAG_ACTION.equals(name)) {
                this.inflateAction(res, dest, attrs);
                continue;
            }
            if (TAG_INCLUDE.equals(name) && dest instanceof NavGraph) {
                TypedArray a = res.obtainAttributes(attrs, R.styleable.NavInclude);
                int id = a.getResourceId(R.styleable.NavInclude_graph, 0);
                ((NavGraph)dest).addDestination((NavDestination)this.inflate(id));
                a.recycle();
                continue;
            }
            if (!(dest instanceof NavGraph)) continue;
            ((NavGraph)dest).addDestination(this.inflate(res, parser, attrs));
        }
        return dest;
    }

    private void inflateArgument(@NonNull Resources res, @NonNull NavDestination dest, @NonNull AttributeSet attrs) throws XmlPullParserException {
        TypedArray a = res.obtainAttributes(attrs, R.styleable.NavArgument);
        String name = a.getString(R.styleable.NavArgument_android_name);
        TypedValue value = sTmpValue.get();
        if (value == null) {
            value = new TypedValue();
            sTmpValue.set(value);
        }
        String argType = a.getString(R.styleable.NavArgument_argType);
        if (a.getValue(R.styleable.NavArgument_android_defaultValue, value)) {
            if ("string".equals(argType)) {
                dest.getDefaultArguments().putString(name, a.getString(R.styleable.NavArgument_android_defaultValue));
            } else {
                switch (value.type) {
                    case 3: {
                        String stringValue = value.string.toString();
                        if (argType == null) {
                            Long longValue = this.parseLongValue(stringValue);
                            if (longValue != null) {
                                dest.getDefaultArguments().putLong(name, longValue.longValue());
                                break;
                            }
                        } else if ("long".equals(argType)) {
                            Long longValue = this.parseLongValue(stringValue);
                            if (longValue != null) {
                                dest.getDefaultArguments().putLong(name, longValue.longValue());
                                break;
                            }
                            throw new XmlPullParserException("unsupported long value " + value.string);
                        }
                        dest.getDefaultArguments().putString(name, stringValue);
                        break;
                    }
                    case 5: {
                        dest.getDefaultArguments().putInt(name, (int)value.getDimension(res.getDisplayMetrics()));
                        break;
                    }
                    case 4: {
                        dest.getDefaultArguments().putFloat(name, value.getFloat());
                        break;
                    }
                    case 1: {
                        dest.getDefaultArguments().putInt(name, value.data);
                        break;
                    }
                    default: {
                        if (value.type >= 16 && value.type <= 31) {
                            if (value.type == 18) {
                                dest.getDefaultArguments().putBoolean(name, value.data != 0);
                                break;
                            }
                            dest.getDefaultArguments().putInt(name, value.data);
                            break;
                        }
                        throw new XmlPullParserException("unsupported argument type " + value.type);
                    }
                }
            }
        }
        a.recycle();
    }

    @Nullable
    private Long parseLongValue(String value) {
        if (!value.endsWith("L")) {
            return null;
        }
        try {
            value = value.substring(0, value.length() - 1);
            if (value.startsWith("0x")) {
                return Long.parseLong(value.substring(2), 16);
            }
            return Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    private void inflateDeepLink(@NonNull Resources res, @NonNull NavDestination dest, @NonNull AttributeSet attrs) {
        TypedArray a = res.obtainAttributes(attrs, R.styleable.NavDeepLink);
        String uri = a.getString(R.styleable.NavDeepLink_uri);
        if (TextUtils.isEmpty((CharSequence)uri)) {
            throw new IllegalArgumentException("Every <deepLink> must include an app:uri");
        }
        uri = uri.replace(APPLICATION_ID_PLACEHOLDER, this.mContext.getPackageName());
        dest.addDeepLink(uri);
        a.recycle();
    }

    private void inflateAction(@NonNull Resources res, @NonNull NavDestination dest, @NonNull AttributeSet attrs) {
        TypedArray a = res.obtainAttributes(attrs, R.styleable.NavAction);
        int id = a.getResourceId(R.styleable.NavAction_android_id, 0);
        int destId = a.getResourceId(R.styleable.NavAction_destination, 0);
        NavAction action = new NavAction(destId);
        NavOptions.Builder builder = new NavOptions.Builder();
        builder.setLaunchSingleTop(a.getBoolean(R.styleable.NavAction_launchSingleTop, false));
        builder.setLaunchDocument(a.getBoolean(R.styleable.NavAction_launchDocument, false));
        builder.setClearTask(a.getBoolean(R.styleable.NavAction_clearTask, false));
        builder.setPopUpTo(a.getResourceId(R.styleable.NavAction_popUpTo, 0), a.getBoolean(R.styleable.NavAction_popUpToInclusive, false));
        builder.setEnterAnim(a.getResourceId(R.styleable.NavAction_enterAnim, -1));
        builder.setExitAnim(a.getResourceId(R.styleable.NavAction_exitAnim, -1));
        builder.setPopEnterAnim(a.getResourceId(R.styleable.NavAction_popEnterAnim, -1));
        builder.setPopExitAnim(a.getResourceId(R.styleable.NavAction_popExitAnim, -1));
        action.setNavOptions(builder.build());
        dest.putAction(id, action);
        a.recycle();
    }
}

