/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.fragment;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.util.AttributeSet;
import androidx.navigation.NavDestination;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import androidx.navigation.fragment.R;
import java.util.HashMap;

@Navigator.Name(value="fragment")
public class FragmentNavigator
extends Navigator<Destination> {
    private Context mContext;
    private FragmentManager mFragmentManager;
    private int mContainerId;
    private int mBackStackCount;
    private final FragmentManager.OnBackStackChangedListener mOnBackStackChangedListener = new FragmentManager.OnBackStackChangedListener(){

        public void onBackStackChanged() {
            int newCount = FragmentNavigator.this.mFragmentManager.getBackStackEntryCount();
            int backStackEffect = newCount < FragmentNavigator.this.mBackStackCount ? 2 : (newCount > FragmentNavigator.this.mBackStackCount ? 1 : 0);
            FragmentNavigator.this.mBackStackCount = newCount;
            int destId = 0;
            StateFragment state = FragmentNavigator.this.getState();
            if (state != null) {
                destId = state.mCurrentDestId;
            }
            FragmentNavigator.this.dispatchOnNavigatorNavigated(destId, backStackEffect);
        }
    };

    public FragmentNavigator(@NonNull Context context, @NonNull FragmentManager manager, int containerId) {
        this.mContext = context;
        this.mFragmentManager = manager;
        this.mContainerId = containerId;
        this.mBackStackCount = this.mFragmentManager.getBackStackEntryCount();
        this.mFragmentManager.addOnBackStackChangedListener(this.mOnBackStackChangedListener);
    }

    public boolean popBackStack() {
        return this.mFragmentManager.popBackStackImmediate();
    }

    @NonNull
    public Destination createDestination() {
        return new Destination(this);
    }

    @NonNull
    private String getBackStackName(@IdRes int destinationId) {
        try {
            return this.mContext.getResources().getResourceName(destinationId);
        }
        catch (Resources.NotFoundException e) {
            return Integer.toString(destinationId);
        }
    }

    public void navigate(@NonNull Destination destination, @Nullable Bundle args, @Nullable NavOptions navOptions) {
        boolean isSingleTopReplacement;
        int popExitAnim;
        Fragment frag = destination.createFragment(args);
        FragmentTransaction ft = this.mFragmentManager.beginTransaction();
        int enterAnim = navOptions != null ? navOptions.getEnterAnim() : -1;
        int exitAnim = navOptions != null ? navOptions.getExitAnim() : -1;
        int popEnterAnim = navOptions != null ? navOptions.getPopEnterAnim() : -1;
        int n = popExitAnim = navOptions != null ? navOptions.getPopExitAnim() : -1;
        if (enterAnim != -1 || exitAnim != -1 || popEnterAnim != -1 || popExitAnim != -1) {
            enterAnim = enterAnim != -1 ? enterAnim : 0;
            exitAnim = exitAnim != -1 ? exitAnim : 0;
            popEnterAnim = popEnterAnim != -1 ? popEnterAnim : 0;
            popExitAnim = popExitAnim != -1 ? popExitAnim : 0;
            ft.setCustomAnimations(enterAnim, exitAnim, popEnterAnim, popExitAnim);
        }
        ft.replace(this.mContainerId, frag);
        StateFragment oldState = this.getState();
        if (oldState != null) {
            ft.remove((Fragment)oldState);
        }
        final int destId = destination.getId();
        StateFragment newState = new StateFragment();
        newState.mCurrentDestId = destId;
        ft.add((Fragment)newState, "android-support-nav:FragmentNavigator.StateFragment");
        boolean initialNavigation = this.mFragmentManager.getFragments().isEmpty();
        boolean isClearTask = navOptions != null && navOptions.shouldClearTask();
        boolean bl = isSingleTopReplacement = navOptions != null && oldState != null && navOptions.shouldLaunchSingleTop() && oldState.mCurrentDestId == destId;
        if (!(initialNavigation || isClearTask || isSingleTopReplacement)) {
            ft.addToBackStack(this.getBackStackName(destId));
        } else {
            ft.runOnCommit(new Runnable(){

                @Override
                public void run() {
                    FragmentNavigator.this.dispatchOnNavigatorNavigated(destId, isSingleTopReplacement ? 0 : 1);
                }
            });
        }
        ft.commit();
        this.mFragmentManager.executePendingTransactions();
    }

    private StateFragment getState() {
        return (StateFragment)this.mFragmentManager.findFragmentByTag("android-support-nav:FragmentNavigator.StateFragment");
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static class StateFragment
    extends Fragment {
        static final String FRAGMENT_TAG = "android-support-nav:FragmentNavigator.StateFragment";
        private static final String KEY_CURRENT_DEST_ID = "currentDestId";
        int mCurrentDestId;

        public void onCreate(@Nullable Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            if (savedInstanceState != null) {
                this.mCurrentDestId = savedInstanceState.getInt(KEY_CURRENT_DEST_ID);
            }
        }

        public void onSaveInstanceState(Bundle outState) {
            super.onSaveInstanceState(outState);
            outState.putInt(KEY_CURRENT_DEST_ID, this.mCurrentDestId);
        }
    }

    public static class Destination
    extends NavDestination {
        private static final HashMap<String, Class<? extends Fragment>> sFragmentClasses = new HashMap();
        private Class<? extends Fragment> mFragmentClass;

        public Destination(@NonNull NavigatorProvider navigatorProvider) {
            this((Navigator<? extends Destination>)navigatorProvider.getNavigator(FragmentNavigator.class));
        }

        public Destination(@NonNull Navigator<? extends Destination> fragmentNavigator) {
            super(fragmentNavigator);
        }

        public void onInflate(@NonNull Context context, @NonNull AttributeSet attrs) {
            super.onInflate(context, attrs);
            TypedArray a = context.getResources().obtainAttributes(attrs, R.styleable.FragmentNavigator);
            this.setFragmentClass(this.getFragmentClassByName(context, a.getString(R.styleable.FragmentNavigator_android_name)));
            a.recycle();
        }

        private Class<? extends Fragment> getFragmentClassByName(Context context, String name) {
            Class<Object> clazz;
            if (name != null && name.charAt(0) == '.') {
                name = context.getPackageName() + name;
            }
            if ((clazz = sFragmentClasses.get(name)) == null) {
                try {
                    clazz = Class.forName(name, true, context.getClassLoader());
                    sFragmentClasses.put(name, clazz);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            return clazz;
        }

        public Destination setFragmentClass(Class<? extends Fragment> clazz) {
            this.mFragmentClass = clazz;
            return this;
        }

        public Class<? extends Fragment> getFragmentClass() {
            return this.mFragmentClass;
        }

        public Fragment createFragment(@Nullable Bundle args) {
            Fragment f;
            Class<? extends Fragment> clazz = this.getFragmentClass();
            if (clazz == null) {
                throw new IllegalStateException("fragment class not set");
            }
            try {
                f = clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (args != null) {
                f.setArguments(args);
            }
            return f;
        }
    }
}

