/*
 * Decompiled with CFR 0.152.
 */
package com.pingplusplus.net;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.pingplusplus.PingppAccount;
import com.pingplusplus.exception.InvalidRequestException;
import com.pingplusplus.model.BatchRefundCharges;
import com.pingplusplus.model.Charge;
import com.pingplusplus.model.ChargeEssentials;
import com.pingplusplus.model.ChargeRefundCollection;
import com.pingplusplus.model.CouponTemplateExpiration;
import com.pingplusplus.model.EventData;
import com.pingplusplus.model.PingppRawJsonObject;
import com.pingplusplus.model.RedEnvelope;
import com.pingplusplus.model.SettleAccountRecipient;
import com.pingplusplus.model.Transfer;
import com.pingplusplus.net.APIResource;
import com.pingplusplus.serializer.AccountEventDataDeserializer;
import com.pingplusplus.serializer.BatchRefundChargesSerializer;
import com.pingplusplus.serializer.BatchTransferRecipientSerializer;
import com.pingplusplus.serializer.ChargeDeserializer;
import com.pingplusplus.serializer.ChargeEssentialsSerializer;
import com.pingplusplus.serializer.ChargeRefundCollectionDeserializer;
import com.pingplusplus.serializer.CouponTemplateExpirationSerializer;
import com.pingplusplus.serializer.DoubleTypeSerializer;
import com.pingplusplus.serializer.PingppRawJsonObjectDeserializer;
import com.pingplusplus.serializer.RedEnvelopeDeserializer;
import com.pingplusplus.serializer.SettleAccountRecipientSerializer;
import com.pingplusplus.serializer.TransferDeserializer;
import java.io.UnsupportedEncodingException;

public abstract class AppBasedResource
extends APIResource {
    public static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(Charge.class, (Object)new ChargeDeserializer()).registerTypeAdapter(RedEnvelope.class, (Object)new RedEnvelopeDeserializer()).registerTypeAdapter(Transfer.class, (Object)new TransferDeserializer()).registerTypeAdapter(ChargeRefundCollection.class, (Object)new ChargeRefundCollectionDeserializer()).registerTypeAdapter(EventData.class, (Object)new AccountEventDataDeserializer()).registerTypeAdapter(PingppRawJsonObject.class, (Object)new PingppRawJsonObjectDeserializer()).create();
    public static final Gson PRETTY_PRINT_GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).disableHtmlEscaping().registerTypeAdapter(BatchTransferRecipientSerializer.class, (Object)new BatchTransferRecipientSerializer()).registerTypeAdapter(BatchRefundCharges.class, (Object)new BatchRefundChargesSerializer()).registerTypeAdapter(Double.class, (Object)new DoubleTypeSerializer()).registerTypeAdapter(ChargeEssentials.class, (Object)new ChargeEssentialsSerializer()).registerTypeAdapter(CouponTemplateExpiration.class, (Object)new CouponTemplateExpirationSerializer()).registerTypeAdapter(SettleAccountRecipient.class, (Object)new SettleAccountRecipientSerializer()).create();

    protected static String className(Class<?> clazz) {
        String className = clazz.getSimpleName().toLowerCase().replace("$", " ");
        if (className.equals("assettransaction")) {
            return "asset_transaction";
        }
        if (className.equals("balancebonus")) {
            return "balance_bonuse";
        }
        if (className.equals("balancetransfer")) {
            return "balance_transfer";
        }
        if (className.equals("balancetransaction")) {
            return "balance_transaction";
        }
        if (className.equals("coupontemplate")) {
            return "coupon_template";
        }
        if (className.equals("batchwithdrawal")) {
            return "batch_withdrawal";
        }
        if (className.equals("transactionstatistics")) {
            return "transaction_statistics";
        }
        if (className.equals("settleaccount")) {
            return "settle_account";
        }
        if (className.equals("subapp")) {
            return "sub_app";
        }
        if (className.equals("royalty")) {
            return "royaltie";
        }
        if (className.equals("royaltysettlement")) {
            return "royalty_settlement";
        }
        if (className.equals("royaltytransaction")) {
            return "royalty_transaction";
        }
        return className;
    }

    protected static String singleClassURL(Class<?> clazz) throws InvalidRequestException {
        if (PingppAccount.appId == null) {
            throw new InvalidRequestException("Please set app_id using PingppAccount.appId = <APP_ID>", "app_id", null);
        }
        return String.format("%s/v1/apps/%s/%s", PingppAccount.getApiBase(), PingppAccount.appId, AppBasedResource.className(clazz));
    }

    protected static String classURL(Class<?> clazz) throws InvalidRequestException {
        return String.format("%ss", AppBasedResource.singleClassURL(clazz));
    }

    protected static String instanceURL(Class<?> clazz, String id) throws InvalidRequestException {
        try {
            return String.format("%s/%s", AppBasedResource.classURL(clazz), AppBasedResource.urlEncode(id));
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidRequestException("Unable to encode parameters to UTF-8", null, e);
        }
    }

    protected static String customURL(String objectName) throws InvalidRequestException {
        if (PingppAccount.appId == null) {
            throw new InvalidRequestException("Please set app_id using PingppAccount.appId = <APP_ID>", "app_id", null);
        }
        return String.format("%s/v1/apps/%s/%s", PingppAccount.getApiBase(), PingppAccount.appId, objectName);
    }
}

