/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.form.view.table.dialect.impl;

import com.bstek.uflo.form.model.TableColumn;
import com.bstek.uflo.form.model.TableDefinition;
import com.bstek.uflo.form.view.table.dialect.impl.AbstractDialect;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="com.bstek.uflo.form.view.table.dialect.impl.OracleDialect")
public class OracleDialect
extends AbstractDialect {
    @Override
    public boolean support(Connection connection) {
        return this.support(connection, "oracle", null);
    }

    @Override
    public String getPaginationSql(String sql, int pageNo, int pageSize) {
        int startNo = (pageNo - 1) * pageSize;
        int endNo = pageNo * pageSize;
        sql = sql.trim();
        String forUpdateClause = null;
        boolean isForUpdate = false;
        int forUpdateIndex = sql.toLowerCase().lastIndexOf("for update");
        if (forUpdateIndex > -1) {
            forUpdateClause = sql.substring(forUpdateIndex);
            sql = sql.substring(0, forUpdateIndex - 1);
            isForUpdate = true;
        }
        StringBuffer pagingSelect = new StringBuffer(sql.length() + 100);
        pagingSelect.append("select * from ( select row_.*, rownum rownum_ from ( ");
        pagingSelect.append(sql);
        pagingSelect.append(" ) row_ where rownum <= " + endNo + ") where rownum_ > " + startNo + "");
        if (isForUpdate) {
            pagingSelect.append(" ");
            pagingSelect.append(forUpdateClause);
        }
        return pagingSelect.toString();
    }

    @Override
    public String[] generateCreateTableSchema(TableDefinition table) {
        String sql = this.generateSchema(table, false);
        List<TableDefinition> children = table.getSlaveTables();
        if (children != null && children.size() > 0) {
            TableDefinition child = children.get(0);
            return new String[]{sql, this.generateSchema(child, true)};
        }
        return new String[]{sql};
    }

    private String generateSchema(TableDefinition table, boolean isChildren) {
        StringBuffer sb = new StringBuffer();
        sb.append("create table " + table.getName() + "(");
        List<TableColumn> columns = table.getColumns();
        if (columns != null) {
            sb.append("ID_ number(19) primary key,");
            for (TableColumn col : columns) {
                sb.append(col.getName() + " " + col.getDataType() + (col.isEmpty() ? "" : " not null"));
                sb.append(",");
            }
            if (isChildren) {
                sb.append("MASTER_ID_ number(19),");
            } else {
                sb.append("PROCESS_PROMOTER_ varchar2(60),");
            }
            sb.append("STATE_ varchar2(20)");
        }
        sb.append(");");
        return sb.toString();
    }

    @Override
    public List<String> getDataTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Varchar2(30)");
        list.add("Date");
        list.add("Integer");
        list.add("Long");
        list.add("Number");
        list.add("SmallInt");
        list.add("Double");
        list.add("Float");
        return list;
    }
}

