/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.form.view.table.dialect.impl;

import com.bstek.uflo.form.model.TableColumn;
import com.bstek.uflo.form.model.TableDefinition;
import com.bstek.uflo.form.view.table.dialect.impl.AbstractDialect;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="com.bstek.uflo.form.view.table.dialect.impl.Db2Dialect")
public class Db2Dialect
extends AbstractDialect {
    @Override
    public boolean support(Connection connection) {
        return this.support(connection, "db2", null);
    }

    @Override
    public String getPaginationSql(String sql, int pageNo, int pageSize) {
        int startNo = (pageNo - 1) * pageSize;
        int endNo = pageNo * pageSize;
        int startOfSelect = sql.toLowerCase().indexOf("select");
        StringBuffer pagingSelect = new StringBuffer(sql.length() + 100).append(sql.substring(0, startOfSelect)).append("select * from ( select ").append(this.getRowNumber(sql));
        if (Db2Dialect.hasDistinct(sql)) {
            pagingSelect.append(" row_.* from ( ").append(sql.substring(startOfSelect)).append(" ) as row_");
        } else {
            pagingSelect.append(sql.substring(startOfSelect + 6));
        }
        pagingSelect.append(" ) as temp_ where rownumber_ ");
        pagingSelect.append("between " + startNo + " and " + endNo + "");
        return pagingSelect.toString();
    }

    private String getRowNumber(String sql) {
        StringBuffer rownumber = new StringBuffer(50).append("rownumber() over(");
        int orderByIndex = sql.toLowerCase().indexOf("order by");
        if (orderByIndex > 0 && !Db2Dialect.hasDistinct(sql)) {
            rownumber.append(sql.substring(orderByIndex));
        }
        rownumber.append(") as rownumber_,");
        return rownumber.toString();
    }

    private static boolean hasDistinct(String sql) {
        return sql.toLowerCase().indexOf("select distinct") >= 0;
    }

    @Override
    public String[] generateCreateTableSchema(TableDefinition table) {
        String sql = this.generateSchema(table, false);
        List<TableDefinition> children = table.getSlaveTables();
        if (children != null && children.size() > 0) {
            TableDefinition child = children.get(0);
            return new String[]{sql, this.generateSchema(child, true)};
        }
        return new String[]{sql};
    }

    private String generateSchema(TableDefinition table, boolean isChildren) {
        StringBuffer sb = new StringBuffer();
        sb.append("create table " + table.getName() + "(");
        List<TableColumn> columns = table.getColumns();
        if (columns != null) {
            sb.append("ID_ bigint,");
            for (TableColumn col : columns) {
                sb.append(col.getName() + " " + col.getDataType() + (col.isEmpty() ? "" : " not null"));
                sb.append(",");
            }
            sb.append("STATE_ varchar(20),");
            if (isChildren) {
                sb.append("MASTER_ID_ bigint,");
            } else {
                sb.append("PROCESS_PROMOTER_ varchar(60),");
            }
            sb.append("primary key (ID_)");
        }
        sb.append(");");
        return sb.toString();
    }

    @Override
    public List<String> getDataTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Varchar(30)");
        list.add("Date");
        list.add("Integer");
        list.add("SmallInt");
        list.add("Double");
        list.add("Float");
        return list;
    }
}

