/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.form.listener;

import com.bstek.uflo.command.CommandService;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.form.model.TableDefinition;
import com.bstek.uflo.form.view.common.FormState;
import com.bstek.uflo.model.ProcessInstance;
import com.bstek.uflo.process.listener.ProcessListener;
import com.bstek.uflo.service.ProcessService;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.jdbc.Work;

public class FormProcessListener
implements ProcessListener {
    private final Log log = LogFactory.getLog(this.getClass());
    private CommandService commandService;
    private ProcessService processService;

    public void processStart(ProcessInstance processInstance, Context context) {
    }

    public void processEnd(ProcessInstance processInstance, Context context) {
        String tag = processInstance.getTag();
        if (StringUtils.isEmpty((String)tag) || !tag.equals("UFLO_FORM_PROCESS_")) {
            return;
        }
        String bussinessId = processInstance.getBusinessId();
        Object id = this.processService.getProcessVariable("TABLE_DEF_ID_", processInstance.getId());
        if (id == null) {
            this.log.warn((Object)"Uflo form process instance was not found table definition id variable.");
            return;
        }
        long tableId = Long.valueOf(id.toString());
        TableDefinition table = (TableDefinition)context.getSession().get(TableDefinition.class, (Serializable)Long.valueOf(tableId));
        if (table == null) {
            this.log.warn((Object)("Table definition " + tableId + " is not exist."));
            return;
        }
        final String sql = "update " + table.getName() + " set " + "STATE_" + "=? where " + "ID_" + "=?";
        final Object[] params = new Object[]{FormState.Completed.toString(), Long.valueOf(bussinessId)};
        context.getSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                PreparedStatement stmt = connection.prepareStatement(sql);
                stmt.setString(1, params[0].toString());
                stmt.setLong(2, (Long)params[1]);
                stmt.execute();
                stmt.close();
            }
        });
    }

    public CommandService getCommandService() {
        return this.commandService;
    }

    public void setCommandService(CommandService commandService) {
        this.commandService = commandService;
    }

    public ProcessService getProcessService() {
        return this.processService;
    }

    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }
}

