﻿CKEDITOR.dialog.add( 'toolbar', function( editor ) {
		function addOption(combo, optionText, optionValue, documentObject, index ) {
		     var oOption = documentObject.createElement( "OPTION" );
		     if ( CKEDITOR.env.ie ) {
		    	 if ( !isNaN( parseInt( index, 10 ) ) )
		    		 combo.$.options.add( oOption.$, index );
		    	 else
		    		 combo.$.options.add( oOption.$ );
		    	 
		    	 oOption.$.innerHTML = optionText.length > 0 ? optionText : '';
		    	 oOption.$.value = optionValue;
		     } else {
		    	 if ( index !== null && index < combo.getChildCount() ){
		    		 combo.getChild( index < 0 ? 0 : index ).insertBeforeMe( oOption );		    		 
		    	 } else {
		    		 combo.append( oOption );		    		 
		    	 }
		    	 oOption.setText( optionText.length > 0 ? optionText : '' );
		    	 oOption.setValue( optionValue );
		     }
		     return oOption;
		}	
        return {
                title: "工具栏信息编辑",
                minWidth: 260,
                minHeight: 260,
                contents: [
                        {
                        id: 'info',
                        elements: [
                                   {
                                	   type: 'hbox',
                   						widths: ['65%','35%'],
                   						children:[
	                   						          {
	                   						        	  id: 'toolbarbuttonlist',
	                   						        	  type: 'select',
	                   						        	  style:"width:200px",
	                   						        	  label: "选择要添加的动作按钮",
	                   						        	  'default': '',
	                   						        	  items:window.formActions
	                   						          },
	                   						          {
	                   						        	  type:"button",
	                   						        	  style:"margin-top:14px",
	                   						        	  label:"添加",
	                   						        	  onClick:function(){
	                   						        		var dialog = this.getDialog(),
	                   						        			parentEditor = dialog.getParentEditor(),
	                   						        			currentButton = dialog.getContentElement('info', 'toolbarbuttonlist' );
	                   						        		var dom=currentButton.getInputElement().$;
	                   						        		var selectedIndex=dom.selectedIndex;
	                   						        		if(selectedIndex==-1){
	                   						        			alert("请先选择一个要添加的动作按钮!");
	                   						        			return;
	                   						        		}
	                   						        		var toolbarbuttons=dialog.getContentElement('info', 'toolbarbuttons' );
	                   						        		var text=dom.options[selectedIndex].text;
	                   						        		var value=dom.options[selectedIndex].value;
	                   						        		var selectedOptions=toolbarbuttons.getInputElement().$.options;
	                   						        		for(var i=0;i<selectedOptions.length;i++){
	                   						        			var option=selectedOptions[i];
	                   						        			if(option.value==value && option.text==text){
	                   						        				alert("当前选择的动作按钮已存在!");
	                   						        				return;
	                   						        			}
	                   						        		}
	                   						        		toolbarbuttons.add(text,value);
	                   						        	  }
	                   						          }
                   						 ]
                                   },
                                   {
                                	   type:"hbox",
                                	   children:[
                                	             {
                                	            	 id:"toolbarbuttons",
                                	            	 type:"select",
                                	            	 label: "已添加的工具栏按钮",
                                                     size: 5,
                                                     style: 'width:200px;height:150px',
                                                     items:[],
                                                     setup:function(widget){
                                                    	this.clear();
                                                    	var buttons=widget.element.getChildren();
                                                    	if(!buttons)return;
                                                    	for(var i=0;i<buttons.count();i++){
                                                    		var button=buttons.getItem(i);
                                                    		this.add(button.getText(),button.getAttribute("action"));
                                                    	}
                                                     },
                                                     commit:function(widget){
                                                    	 var buttons=[];
                                                    	 var options=this.getInputElement().$.options;
                                                    	 for(var i=0;i<options.length;i++){
                                                    		 var option=options[i];
                                                    		 buttons.push({text:option.text,value:option.value});
                                                    	 }
                                                    	 widget.setData("buttons",buttons);
                                                     }
                                	             },
                                	             {
                                	            	 type:"vbox",
                                	            	 children:[
                                	            	           {
                                	            	        	 type:"button",
                                              	            	 label:"删除",
                                              	            	 style:"width:100%;margin-top:10px",
                                              	            	 onClick:function(){
                                              	            		var dialog = this.getDialog(),
                                              	            			toolbarbuttons=dialog.getContentElement('info', 'toolbarbuttons');
                                              	            		var element=toolbarbuttons.getInputElement();
        	                   						        		var selectedIndex=element.$.selectedIndex;
        	                   						        		if(selectedIndex==-1){
        	                   						        			alert("请先选择要删除的动作按钮");
        	                   						        			return;
        	                   						        		}
        	                   						        		for ( var i = element.getChildren().count() - 1; i >= 0; i-- ) {
        	                   					                        if ( element.getChild( i ).$.selected ){
        	                   					                        	element.getChild( i ).remove();        	                   					                        	
        	                   					                        }
        	                   						        		}
                                              	            	 }
                                	            	           },
                                	            	           {
                                	            	        	   type:"button",
                                	            	        	   label:"上移",
                                	            	        	   onClick:function(){
                                	            	        		   var dialog = this.getDialog(),
                                             	            				toolbarbuttons=dialog.getContentElement('info', 'toolbarbuttons'),
                                             	            				element=toolbarbuttons.getInputElement();
                                	            	        		   var selectedIndex=element.$.selectedIndex;
	           	                   						        		if(selectedIndex==-1){
	           	                   						        			alert("请先选择要上移的动作按钮");
	           	                   						        			return;
	           	                   						        		}
	           	                   						        		if(selectedIndex==0){
	           	                   						        			alert("当前动作按钮已处于顶部，不能再上移！");
	           	                   						        			return;
	           	                   						        		}
	           	                   						        		var text=element.$.options[selectedIndex].text;
	           	                   						        		var value=element.$.options[selectedIndex].value;
		           	                   						        	for (var i = element.getChildren().count() - 1; i >= 0; i-- ) {
	        	                   					                        if ( element.getChild( i ).$.selected ){
	        	                   					                        	element.getChild( i ).remove();        	                   					                        	
	        	                   					                        }
	        	                   						        		}
		           	                   						        	addOption(element,text,value,editor.document,selectedIndex-1);
                                	            	        	   }
                                	            	           },
                                	            	           {
                                	            	        	   type:"button",
                                	            	        	   label:"下移",
                                	            	        	   onClick:function(){
                                	            	        		   var dialog = this.getDialog(),
                                             	            				toolbarbuttons=dialog.getContentElement('info', 'toolbarbuttons'),
                                             	            				element=toolbarbuttons.getInputElement();
                                	            	        		   var selectedIndex=element.$.selectedIndex;
                                	            	        		   var options=element.$.options;
	           	                   						        		if(selectedIndex==-1){
	           	                   						        			alert("请先选择要下移的动作按钮");
	           	                   						        			return;
	           	                   						        		}
	           	                   						        		if(selectedIndex==options.length-1){
	           	                   						        			alert("当前动作按钮已处于底部，不能再下移！");
	           	                   						        			return;
	           	                   						        		}
	           	                   						        		var text=options[selectedIndex].text;
	           	                   						        		var value=options[selectedIndex].value;
		           	                   						        	for (var i = element.getChildren().count() - 1; i >= 0; i-- ) {
	        	                   					                        if ( element.getChild( i ).$.selected ){
	        	                   					                        	element.getChild( i ).remove();        	                   					                        	
	        	                   					                        }
	        	                   						        		}
		           	                   						        	addOption(element,text,value,editor.document,selectedIndex+1);
                                	            	        	   }
                                	            	           }
                                	            	 ]
                                	             }
                                	   ]
                                   }
                        ]
                }
                ]
        };
});