﻿CKEDITOR.dialog.add('text',function(editor){ 
    return {
        title: editor.lang.uflo.textfield.title,
        minWidth: 320,
        minHeight: 150,
        contents: [{
            id: 'info',
            label: editor.lang.uflo.textfield.title,
            title: editor.lang.uflo.textfield.title,
            elements: [
				{
	                type: 'hbox',
	                children: [
						{
		                    id: 'bindingfield',
		                    type: 'select',
							style:"width:320px",
		                    label: editor.lang.uflo.textfield.bindingfiled,
		                    'default': '',
							items: window.formTable.getMasterColumns(),
							setup:function(widget){
								var element=widget.element;
								var bindingfield=element.getAttribute("bindingfield");
								if(bindingfield){
									this.setValue(bindingfield);
								}
							},
		                    commit:function(widget){
								widget.setData("bindingfield",this.getValue());
							}    
						}
					]
	        	},
				{
					type: 'hbox',
					widths: ['40%','60%'],
					children: [
						{
		                    id: 'width',
		                    type: 'text',
							style:"width:150px",
		                    label: editor.lang.uflo.textfield.charWidth,
		                    'default': '100%',
							setup:function(widget){
								var element=widget.element;
								var styles=element.getAttribute("style");
								if(styles){
									var style=styles.split(";");
									for(var i=0;i<style.length;i++){
										var item=style[i].split(":");
										if(item[0]=="width"){
											this.setValue(item[1]);
											break;
										}
									}
								}
							},
		                    commit:function(widget){
								widget.setData("width",this.getValue());
							}  
		                    //validate: CKEDITOR.dialog.validate.integer(editor.lang.common.validateNumberFailed)
		                },
						{
			                id: 'type',
			                type: 'select',
							style:"width:150px",
			                label: editor.lang.uflo.textfield.type,
			                'default': 'text',
			                accessKey: 'M',
			                items: [
										[editor.lang.uflo.textfield.typePass,'password'],
										[editor.lang.uflo.textfield.typeText,'text']
									],   
							setup:function(widget){
								var element=widget.element;
								var type=element.getAttribute("type");
								if(type){
									this.setValue(type);
								}
							},		
							commit:function(widget){
								widget.setData("type",this.getValue());
							}      
						}
					]
				}
			]
        }]
    };
});
