/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.form.view.table.dialect.impl;

import com.bstek.uflo.form.model.TableColumn;
import com.bstek.uflo.form.model.TableDefinition;
import com.bstek.uflo.form.view.table.dialect.impl.AbstractDialect;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="com.bstek.uflo.form.view.table.dialect.impl.MySqlDialect")
public class MySqlDialect
extends AbstractDialect {
    @Override
    public boolean support(Connection connection) {
        return this.support(connection, "mysql", null);
    }

    @Override
    public String[] generateCreateTableSchema(TableDefinition table) {
        String sql = this.generateSchema(table, false);
        List<TableDefinition> children = table.getSlaveTables();
        if (children != null && children.size() > 0) {
            TableDefinition child = children.get(0);
            return new String[]{sql, this.generateSchema(child, true)};
        }
        return new String[]{sql};
    }

    @Override
    public String getPaginationSql(String sql, int pageNo, int pageSize) {
        int startNo = (pageNo - 1) * pageSize;
        return sql + " limit " + startNo + "," + pageSize;
    }

    private String generateSchema(TableDefinition table, boolean isChildren) {
        StringBuffer sb = new StringBuffer();
        sb.append("create table " + table.getName() + "(");
        List<TableColumn> columns = table.getColumns();
        if (columns != null) {
            sb.append("ID_ bigint primary key,");
            for (TableColumn col : columns) {
                sb.append(col.getName() + " " + col.getDataType() + (col.isEmpty() ? "" : " not null"));
                sb.append(",");
            }
            if (isChildren) {
                sb.append("MASTER_ID_ bigint,");
            } else {
                sb.append("PROCESS_PROMOTER_ varchar(60),");
            }
            sb.append("STATE_ varchar(20)");
        }
        sb.append(")ENGINE=InnoDB DEFAULT CHARSET=gbk;");
        return sb.toString();
    }

    @Override
    public List<String> getDataTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Varchar(30)");
        list.add("Date");
        list.add("Integer");
        list.add("SmallInt");
        list.add("Double");
        list.add("Float");
        return list;
    }
}

