/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.form.view.table;

import com.bstek.dorado.annotation.DataProvider;
import com.bstek.dorado.annotation.DataResolver;
import com.bstek.dorado.data.provider.Page;
import com.bstek.uflo.command.Command;
import com.bstek.uflo.command.CommandService;
import com.bstek.uflo.form.command.GenerateTablesCommand;
import com.bstek.uflo.form.command.GetDataTypeCommand;
import com.bstek.uflo.form.command.QueryTableColumnCommand;
import com.bstek.uflo.form.command.QueryTableCommand;
import com.bstek.uflo.form.command.SaveTableCommand;
import com.bstek.uflo.form.model.MappingProvider;
import com.bstek.uflo.form.model.TableColumn;
import com.bstek.uflo.form.model.TableDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="uflo.form.tableMaintain")
public class TableMaintain
implements ApplicationContextAware {
    @Autowired
    @Qualifier(value="uflo.commandService")
    private CommandService commandService;
    private ApplicationContext applicationContext;

    @DataProvider
    public void loadTables(Page<TableDefinition> page, Long parentId) {
        this.commandService.executeCommand((Command)new QueryTableCommand(page, parentId));
    }

    @DataProvider
    public List<TableColumn> loadColumns(Long tableId) {
        return (List)this.commandService.executeCommand((Command)new QueryTableColumnCommand(tableId));
    }

    @DataProvider
    public List<Map<String, Object>> getDataTypes() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List types = (List)this.commandService.executeCommand((Command)new GetDataTypeCommand());
        if (types == null) {
            return list;
        }
        for (String type : types) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", type);
            list.add(map);
        }
        return list;
    }

    @DataProvider
    public Collection<Map<String, Object>> loadMappingProviders() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (String name : this.applicationContext.getBeansOfType(MappingProvider.class).keySet()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", name);
            list.add(map);
        }
        return list;
    }

    @DataResolver
    public void saveTables(Collection<TableDefinition> tables) {
        this.commandService.executeCommand((Command)new SaveTableCommand(tables));
    }

    @DataResolver
    public void generateTables(Collection<TableDefinition> tables) {
        if (tables == null || tables.size() == 0) {
            throw new IllegalArgumentException("\u8bf7\u6307\u5b9a\u8981\u751f\u6210\u8868\u7684\u8868\u5b9a\u4e49\u4fe1\u606f\uff01");
        }
        TableDefinition table = tables.iterator().next();
        this.commandService.executeCommand((Command)new GenerateTablesCommand(table));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

