/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.form.view.table;

import com.bstek.dorado.annotation.DataProvider;
import com.bstek.dorado.data.provider.Page;
import com.bstek.dorado.data.type.AggregationDataType;
import com.bstek.dorado.data.type.DataType;
import com.bstek.dorado.data.type.DateDataType;
import com.bstek.dorado.data.type.EntityDataType;
import com.bstek.dorado.data.type.property.BasePropertyDef;
import com.bstek.dorado.data.type.property.Mapping;
import com.bstek.dorado.data.type.property.PropertyDef;
import com.bstek.dorado.view.manager.ViewConfig;
import com.bstek.dorado.view.widget.base.SplitPanel;
import com.bstek.dorado.view.widget.grid.Column;
import com.bstek.dorado.view.widget.grid.DataColumn;
import com.bstek.dorado.view.widget.grid.DataGrid;
import com.bstek.dorado.web.DoradoContext;
import com.bstek.uflo.command.Command;
import com.bstek.uflo.command.CommandService;
import com.bstek.uflo.form.command.GetTableDefinitionCommand;
import com.bstek.uflo.form.command.QueryDataCommand;
import com.bstek.uflo.form.model.MappingProvider;
import com.bstek.uflo.form.model.MappingSource;
import com.bstek.uflo.form.model.TableColumn;
import com.bstek.uflo.form.model.TableDefinition;
import com.bstek.uflo.form.view.common.FormState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="uflo.dataAnalysis")
public class DataAnalysis
implements ApplicationContextAware {
    @Autowired
    @Qualifier(value="uflo.commandService")
    private CommandService commandService;
    private EntityDataType dataTypeMaster;
    private EntityDataType dataTypeSlave;
    private ApplicationContext applicationContext;

    public void onInit(ViewConfig config) throws Exception {
        HttpServletRequest request = DoradoContext.getCurrent().getRequest();
        String tableId = request.getParameter("id");
        if (StringUtils.isEmpty((String)tableId)) {
            return;
        }
        TableDefinition table = (TableDefinition)this.commandService.executeCommand((Command)new GetTableDefinitionCommand(Long.valueOf(tableId)));
        if (table == null) {
            throw new IllegalArgumentException("Table " + tableId + " is not exist.");
        }
        this.dataTypeMaster = (EntityDataType)config.getDataType("dataTypeMaster");
        HashMap<String, Boolean> mappingMap = new HashMap<String, Boolean>();
        this.buildDataTypeProperty(config, table, this.dataTypeMaster, mappingMap);
        if (table.getSlaveTables().size() > 0) {
            TableDefinition slaveTable = table.getSlaveTables().get(0);
            this.dataTypeSlave = (EntityDataType)config.getDataType("dataTypeSlave");
            this.buildDataTypeProperty(config, slaveTable, this.dataTypeSlave, null);
            BasePropertyDef salveProperty = new BasePropertyDef("salvetables");
            AggregationDataType refDataType = new AggregationDataType();
            refDataType.setId("[dataTypeSlave]");
            refDataType.setElementDataType((DataType)this.dataTypeSlave);
            salveProperty.setDataType((DataType)refDataType);
            this.dataTypeMaster.addPropertyDef((PropertyDef)salveProperty);
        } else {
            config.getView().getComponent("dataGridSlave").setIgnored(true);
            SplitPanel splitPanel = (SplitPanel)config.getView().getComponent("splitPanel");
            splitPanel.setPosition("100%");
        }
    }

    private void buildDataTypeProperty(ViewConfig config, TableDefinition table, EntityDataType dataType, Map<String, Boolean> mappingMap) throws Exception {
        DataGrid grid = null;
        grid = mappingMap != null ? (DataGrid)config.getView().getComponent("dataGridMaster") : (DataGrid)config.getView().getComponent("dataGridSlave");
        BasePropertyDef primaryKeyDef = new BasePropertyDef("ID_");
        primaryKeyDef.setDataType(config.getDataType("long"));
        dataType.addPropertyDef((PropertyDef)primaryKeyDef);
        for (TableColumn col : table.getColumns()) {
            BasePropertyDef def = new BasePropertyDef(col.getName().toLowerCase());
            def.setLabel(col.getMemo());
            DataType dt = this.getDataType(config, col.getDataType());
            if (dt instanceof DateDataType) {
                def.setDisplayFormat("Y-m-d H:i:s");
            }
            def.setDataType(dt);
            def.setDefaultValue((Object)col.getDefaultValue());
            def.setRequired(!col.isEmpty());
            String mappingStr = col.getMapping();
            if (StringUtils.isNotEmpty((String)mappingStr)) {
                def.setMapping(this.buildMapping(col.getMapping(), col.getMappingSource()));
                if (mappingMap != null) {
                    mappingMap.put(col.getName(), true);
                }
            } else if (mappingMap != null) {
                mappingMap.put(col.getName(), false);
            }
            dataType.addPropertyDef((PropertyDef)def);
            DataColumn datacol = new DataColumn();
            datacol.setName(col.getName().toLowerCase());
            datacol.setProperty(col.getName().toLowerCase());
            grid.addColumn((Column)datacol);
        }
    }

    private Mapping buildMapping(String mappingStr, MappingSource mappingSource) {
        Mapping mapping = new Mapping();
        mapping.setKeyProperty("key");
        mapping.setValueProperty("label");
        if (mappingSource.equals((Object)MappingSource.MappingProvider)) {
            MappingProvider provider = (MappingProvider)this.applicationContext.getBean(mappingStr);
            mapping.setMapValues(provider.getMapping());
        } else {
            ArrayList list = new ArrayList();
            for (String pairs : mappingStr.split(";")) {
                String[] pair = pairs.split("=");
                if (pair.length != 2) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("key", pair[0]);
                map.put("label", pair[1]);
                list.add(map);
            }
            mapping.setMapValues(list);
        }
        return mapping;
    }

    private DataType getDataType(ViewConfig config, String dataType) throws Exception {
        String[] numbers;
        int end;
        int start;
        String type = null;
        if ((dataType = dataType.toLowerCase()).startsWith("varchar") || dataType.startsWith("nvarchar")) {
            type = "String";
        }
        if (dataType.startsWith("double")) {
            type = "double";
        }
        if (dataType.startsWith("float")) {
            type = "float";
        }
        if (dataType.startsWith("bit")) {
            type = "boolean";
        }
        if (dataType.startsWith("long")) {
            type = "long";
        }
        if (dataType.startsWith("date")) {
            type = "Date";
        }
        if (dataType.startsWith("int") || dataType.startsWith("smallint") || dataType.startsWith("tinyint") || dataType.startsWith("integer")) {
            type = "int";
        }
        if (dataType.startsWith("number") && dataType.indexOf("(") > -1) {
            start = dataType.indexOf("(") + 1;
            numbers = dataType.substring(start, end = dataType.lastIndexOf(")")).split(",");
            type = numbers.length == 1 ? "long" : (Integer.parseInt(numbers[1]) > 0 ? "double" : "long");
        }
        if (dataType.startsWith("numeric") && dataType.indexOf("(") > -1) {
            start = dataType.indexOf("(") + 1;
            numbers = dataType.substring(start, end = dataType.lastIndexOf(")")).split(",");
            type = numbers.length == 1 ? "long" : (Integer.parseInt(numbers[1]) > 0 ? "double" : "long");
        }
        if (type == null) {
            throw new IllegalArgumentException("Unsupport datatype:" + dataType + "");
        }
        return config.getDataType(type);
    }

    @DataProvider
    public void loadData(Page<Map<String, Object>> page, Map<String, Object> parameter) {
        String tableId = (String)parameter.get("tableId");
        String state = (String)parameter.get("state");
        Map orders = (Map)parameter.get("orders");
        FormState formState = null;
        if (StringUtils.isNotEmpty((String)state)) {
            formState = FormState.valueOf(state);
        }
        TableDefinition table = (TableDefinition)this.commandService.executeCommand((Command)new GetTableDefinitionCommand(Long.valueOf(tableId)));
        this.commandService.executeCommand((Command)new QueryDataCommand(page, table, formState, orders));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

