/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.form.service;

import com.bstek.dorado.data.provider.Page;
import com.bstek.uflo.command.Command;
import com.bstek.uflo.command.CommandService;
import com.bstek.uflo.form.command.QueryFormCommand;
import com.bstek.uflo.form.command.QueryTableCommand;
import com.bstek.uflo.form.model.Form;
import com.bstek.uflo.form.model.FormInfo;
import com.bstek.uflo.form.model.TableDefinition;
import com.bstek.uflo.form.model.TableInfo;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormService {
    private CommandService commandService;
    public static final String BEAN_ID = "uflo.form.formService";

    public List<TableInfo> queryTableInfo() {
        Page page = new Page(10000, 1);
        this.commandService.executeCommand((Command)new QueryTableCommand((Page<TableDefinition>)page, null));
        ArrayList<TableInfo> infos = new ArrayList<TableInfo>();
        for (TableDefinition def : page.getEntities()) {
            TableInfo info = new TableInfo();
            info.setDesc(def.getMemo());
            info.setId(def.getId());
            info.setName(def.getName());
            infos.add(info);
        }
        return infos;
    }

    public List<FormInfo> queryFormInfos(long tableId) {
        List forms = (List)this.commandService.executeCommand((Command)new QueryFormCommand(tableId));
        ArrayList<FormInfo> infos = new ArrayList<FormInfo>();
        for (Form form : forms) {
            FormInfo info = new FormInfo();
            info.setName(form.getName());
            info.setUrl("dorado/uflo/form/dispatch/" + form.getId());
            infos.add(info);
        }
        return infos;
    }

    public CommandService getCommandService() {
        return this.commandService;
    }

    public void setCommandService(CommandService commandService) {
        this.commandService = commandService;
    }
}

