/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.form.command;

import com.bstek.uflo.command.Command;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.form.command.MapResultTransformer;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.ResultTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetTableDataCommand
implements Command<Map<String, Object>> {
    private Object keyValue;
    private String sql;
    private String slaveSql;

    public GetTableDataCommand(String sql, String slaveSql, Object keyValue) {
        this.keyValue = keyValue;
        this.sql = sql;
        this.slaveSql = slaveSql;
    }

    public Map<String, Object> execute(Context context) {
        Session session = context.getSession();
        SQLQuery query = session.createSQLQuery(this.sql);
        if (this.keyValue instanceof Integer) {
            query.setInteger(0, ((Integer)this.keyValue).intValue());
        } else if (this.keyValue instanceof Long) {
            query.setLong(0, ((Long)this.keyValue).longValue());
        } else {
            query.setString(0, (String)this.keyValue);
        }
        query.setResultTransformer((ResultTransformer)new MapResultTransformer());
        Map result = (Map)query.uniqueResult();
        if (StringUtils.isNotEmpty((String)this.slaveSql)) {
            SQLQuery slaveQuery = session.createSQLQuery(this.slaveSql);
            if (this.keyValue instanceof Integer) {
                slaveQuery.setInteger(0, ((Integer)this.keyValue).intValue());
            } else if (this.keyValue instanceof Long) {
                slaveQuery.setLong(0, ((Long)this.keyValue).longValue());
            } else {
                slaveQuery.setString(0, (String)this.keyValue);
            }
            slaveQuery.setResultTransformer((ResultTransformer)new MapResultTransformer());
            result.put("salvetables", slaveQuery.list());
        }
        return result;
    }
}

