/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.form.action.impl;

import com.bstek.dorado.view.View;
import com.bstek.uflo.form.action.Action;
import com.bstek.uflo.form.action.FormData;
import com.bstek.uflo.form.model.TableColumn;
import com.bstek.uflo.form.model.TableDefinition;
import com.bstek.uflo.form.view.common.FormState;
import com.bstek.uflo.utils.EnvironmentUtils;
import com.bstek.uflo.utils.IDGenerator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveFormDataAction
implements Action {
    @Override
    public String getName() {
        return "\u4fdd\u5b58\u6570\u636e";
    }

    @Override
    public String getIcon() {
        return "url(skin>common/icons.gif) -140px -20px";
    }

    @Override
    public void onViewInit(View view) {
    }

    @Override
    public void execute(FormData formData, Session session) {
        this.saveFormData(formData, session);
    }

    protected String saveFormData(final FormData formData, Session session) {
        final String[] returnValues = new String[1];
        session.doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                Map<String, Object> map = formData.getMasterTable();
                TableDefinition table = formData.getTable();
                String sql = null;
                ArrayList<Object> params = new ArrayList<Object>();
                Object primaryKeyValue = map.get("ID_");
                if (primaryKeyValue == null || primaryKeyValue.toString().equals("0")) {
                    primaryKeyValue = IDGenerator.getInstance().nextId();
                    params.add(primaryKeyValue);
                    sql = SaveFormDataAction.this.buildInsertSql(table, params, map, null);
                } else {
                    sql = SaveFormDataAction.this.buildUpdateSql(table, params, map);
                }
                returnValues[0] = primaryKeyValue.toString();
                PreparedStatement stmt = connection.prepareStatement(sql);
                for (int i = 1; i < params.size() + 1; ++i) {
                    Object obj = params.get(i - 1);
                    stmt.setObject(i, obj);
                }
                stmt.execute();
                stmt.close();
                SaveFormDataAction.this.saveSlaveTableData(connection, map, table, primaryKeyValue);
            }
        });
        return returnValues[0];
    }

    private void saveSlaveTableData(Connection connection, Map<String, Object> map, TableDefinition table, Object masterPrimaryKeyValue) throws SQLException {
        List<TableDefinition> children = table.getSlaveTables();
        Object slaves = map.get("salvetables");
        if (children == null || children.size() == 0 || slaves == null) {
            return;
        }
        Collection coll = (Collection)slaves;
        if (coll.size() == 0) {
            return;
        }
        TableDefinition slave = children.get(0);
        for (Map child : coll) {
            Object keyValue = child.get("ID_");
            ArrayList<Object> values = new ArrayList<Object>();
            String sql = null;
            if (keyValue == null || keyValue.toString().equals("0")) {
                keyValue = IDGenerator.getInstance().nextId();
                values.add(keyValue);
                sql = this.buildInsertSql(slave, values, child, Long.valueOf(masterPrimaryKeyValue.toString()));
            } else {
                sql = this.buildUpdateSql(slave, values, child);
            }
            PreparedStatement stmt = connection.prepareStatement(sql);
            for (int i = 1; i < values.size() + 1; ++i) {
                Object obj = values.get(i - 1);
                stmt.setObject(i, obj);
            }
            stmt.execute();
            stmt.close();
        }
    }

    private String buildUpdateSql(TableDefinition table, List<Object> params, Map<String, Object> map) {
        StringBuffer sb = new StringBuffer();
        sb.append("update " + table.getName() + " set ");
        int i = 0;
        for (TableColumn col : table.getColumns()) {
            sb.append(" " + col.getName() + "=? ");
            params.add(map.get(col.getName().toLowerCase()));
            if (++i >= table.getColumns().size()) continue;
            sb.append(",");
        }
        sb.append(" where ID_=?");
        params.add(map.get("ID_"));
        return sb.toString();
    }

    private String buildInsertSql(TableDefinition table, List<Object> params, Map<String, Object> map, Long masterId) {
        StringBuffer sb = new StringBuffer();
        StringBuffer values = new StringBuffer();
        sb.append("insert into " + table.getName() + "(");
        sb.append("ID_,");
        values.append("?,");
        if (masterId != null) {
            values.append("?,");
            sb.append("MASTER_ID_,");
            params.add(masterId);
        } else {
            sb.append("PROCESS_PROMOTER_,");
            values.append("?,");
            params.add(EnvironmentUtils.getEnvironment().getLoginUser());
        }
        for (TableColumn col : table.getColumns()) {
            sb.append(col.getName());
            params.add(map.get(col.getName().toLowerCase()));
            values.append("?");
            sb.append(",");
            values.append(",");
        }
        sb.append("STATE_");
        sb.append(")");
        values.append("?");
        params.add(FormState.InProgress.toString());
        return sb.toString() + " values(" + values.toString() + ")";
    }

    @Override
    public String getClickScript(String actionId) {
        return null;
    }
}

