/**
 * @author Jacky
 */
var uflo={};
uflo.form={};
uflo.form.TableDefinition=function(data){
	this.data=data;
	function getColumns(columns){
		if(!columns){
			return [];
		}
		var fields=[];
		for(var i=0;i<columns.length;i++){
			var col=columns[i];
			var field=[];
			field.push(col.memo);
			field.push(col.name);
			fields.push(field);
		}
		return fields;
	}
	this.getMasterColumns=function(){
		return getColumns(this.data.columns);
	};
	this.getSlaveColumns=function(){
		if(this.data.slaveTables.length==0){
			return [];
		}
		return getColumns(this.data.slaveTables[0].columns);
	};
}

uflo.form.FormData=function(data){
	this.data=data;
	this.getName=function(){
		return this.data.name;
	};
	this.getContent=function(){
		return this.data.content;
	};
	this.getId=function(){
		return this.data.id;
	};
}

$(document).ready(function(){
	var editor=CKEDITOR.replace( 'editorContainer', {
		extraPlugins: "save,font,justify,colorbutton,tableresize,uflo,autoform"
	});
	var url = location.href;  
	var params = url.substring(url.indexOf("?"),url.length);
	var requestUrl=window.contextPath+"/dorado/uflo/form/table"+params;
	$.ajax({
		url:requestUrl,
		type:"GET",
		dataType:"json",
		success:function(data){
			window.formTable=new uflo.form.TableDefinition(data);
		},
		error:function(req,error,exception){
			alert("表定义信息加载失败。！");
		}
	});
	$.ajax({
		url:window.contextPath+"/dorado/uflo/form/load"+params,
		type:"GET",
		dataType:"json",
		success:function(data){
			if(data){
				window.formData=new uflo.form.FormData(data);				
			}
		},
		error:function(req,error,exception){
			alert("表定义信息加载失败。！");
		}
	});
	$.ajax({
		url:window.contextPath+"/dorado/uflo/form/action",
		type:"GET",
		dataType:"json",
		success:function(data){
			window.formActions=data;
		},
		error:function(req,error,exception){
			debugger;
			alert("动作定义信息加载失败。！");
		}
	});
	editor.on( 'instanceReady', function( event ){
	  var ckeditor = event.editor;
	  var command = ckeditor.getCommand('maximize');
	  command.exec();
	  if(window.formData){
	  	ckeditor.setData(window.formData.getContent());
	  }
	});
});
