/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.form.view.table.dialect.impl;

import com.bstek.uflo.form.model.TableColumn;
import com.bstek.uflo.form.model.TableDefinition;
import com.bstek.uflo.form.view.table.dialect.impl.AbstractDialect;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="com.bstek.uflo.form.view.table.dialect.impl.SqlServerDialect")
public class SqlServerDialect
extends AbstractDialect {
    private String DISTINCT = "distinct";
    private String SELECT = "select";
    private String FROM = "from";

    @Override
    public boolean support(Connection connection) {
        return this.support(connection, "sql server", null);
    }

    @Override
    public String[] generateCreateTableSchema(TableDefinition table) {
        String sql = this.generateSchema(table, false);
        List<TableDefinition> children = table.getSlaveTables();
        if (children != null && children.size() > 0) {
            TableDefinition child = children.get(0);
            return new String[]{sql, this.generateSchema(child, true)};
        }
        return new String[]{sql};
    }

    @Override
    public String getPaginationSql(String sql, int pageNo, int pageSize) {
        String orderby;
        int startNo = (pageNo - 1) * pageSize + 1;
        int endNo = pageNo * pageSize;
        StringBuilder sb = new StringBuilder(sql.trim().toLowerCase());
        int orderByIndex = sb.indexOf("order by");
        CharSequence charSequence = orderby = orderByIndex > 0 ? sb.subSequence(orderByIndex, sb.length()) : "ORDER BY CURRENT_TIMESTAMP";
        if (orderByIndex > 0) {
            sb.delete(orderByIndex, orderByIndex + orderby.length());
        }
        this.replaceDistinctWithGroupBy(sb);
        this.insertRowNumberFunction(sb, orderby);
        sb.insert(0, "WITH query AS (").append(") SELECT * FROM query ");
        sb.append("WHERE __hibernate_row_nr__ BETWEEN " + startNo + " AND " + endNo + "");
        return sb.toString();
    }

    private void replaceDistinctWithGroupBy(StringBuilder sql) {
        int distinctIndex = sql.indexOf(this.DISTINCT);
        if (distinctIndex > 0) {
            sql.delete(distinctIndex, distinctIndex + this.DISTINCT.length() + 1);
            sql.append(" group by").append(this.getSelectFieldsWithoutAliases(sql));
        }
    }

    private CharSequence getSelectFieldsWithoutAliases(StringBuilder sql) {
        String select = sql.substring(sql.indexOf(this.SELECT) + this.SELECT.length(), sql.indexOf(this.FROM));
        return this.stripAliases(select);
    }

    private String stripAliases(String str) {
        return str.replaceAll("\\sas[^,]+(,?)", "$1");
    }

    private void insertRowNumberFunction(StringBuilder sql, CharSequence orderby) {
        int fromStartIndex = sql.indexOf(this.FROM);
        sql.insert(fromStartIndex, " ,ROW_NUMBER() OVER (" + orderby + ") as __hibernate_row_nr__ ");
    }

    private String generateSchema(TableDefinition table, boolean isChildren) {
        StringBuffer sb = new StringBuffer();
        sb.append("create table " + table.getName() + "(");
        List<TableColumn> columns = table.getColumns();
        if (columns != null) {
            sb.append("ID_ long primary key,");
            for (TableColumn col : columns) {
                sb.append(col.getName() + " " + col.getDataType() + (col.isEmpty() ? "" : " not null"));
                sb.append(",");
            }
            if (isChildren) {
                sb.append("MASTER_ID_ long,");
            } else {
                sb.append("PROCESS_PROMOTER_ varchar(60),");
            }
            sb.append("STATE_ varchar(20)");
        }
        sb.append(");");
        return sb.toString();
    }

    @Override
    public List<String> getDataTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Varchar(30)");
        list.add("Datetime");
        list.add("Int");
        list.add("Long");
        list.add("Number");
        list.add("SmallInt");
        list.add("Numeric");
        list.add("Float");
        return list;
    }
}

