/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.form.view.table.dialect.impl;

import com.bstek.uflo.form.model.TableColumn;
import com.bstek.uflo.form.model.TableDefinition;
import com.bstek.uflo.form.view.table.dialect.impl.AbstractDialect;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="com.bstek.uflo.form.view.table.dialect.impl.InformixDialect")
public class InformixDialect
extends AbstractDialect {
    @Override
    public boolean support(Connection connection) {
        return this.support(connection, "Informix Dynamic Server", null);
    }

    @Override
    public String getPaginationSql(String sql, int pageNo, int pageSize) {
        if (pageNo < 1) {
            throw new RuntimeException("page no \u4e0d\u80fd\u5c0f\u4e8e1");
        }
        int startNo = (pageNo - 1) * pageSize;
        sql = sql.trim().toLowerCase();
        String select = "select";
        int indexOfSelect = sql.indexOf("select");
        if (indexOfSelect != -1) {
            return sql.substring(0, (indexOfSelect += "select".length()) + 1) + " skip " + startNo + " first " + pageSize + sql.substring(indexOfSelect);
        }
        throw new RuntimeException("\u672a\u627e\u5230select");
    }

    @Override
    public String[] generateCreateTableSchema(TableDefinition table) {
        String sql = this.generateSchema(table, false);
        List<TableDefinition> children = table.getSlaveTables();
        if (children != null && children.size() > 0) {
            TableDefinition child = children.get(0);
            return new String[]{sql, this.generateSchema(child, true)};
        }
        return new String[]{sql};
    }

    private String generateSchema(TableDefinition table, boolean isChildren) {
        StringBuffer sb = new StringBuffer();
        sb.append("create table " + table.getName() + "(");
        List<TableColumn> columns = table.getColumns();
        if (columns != null) {
            sb.append("ID_ integer,");
            for (TableColumn col : columns) {
                sb.append(col.getName() + " " + col.getDataType() + (col.isEmpty() ? "" : " not null"));
                sb.append(",");
            }
            if (isChildren) {
                sb.append("MASTER_ID_ integer,");
            } else {
                sb.append("PROCESS_PROMOTER_ varchar(60),");
            }
            sb.append("STATE_ varchar(20),");
            sb.append("primary key (ID_)");
        }
        sb.append(");");
        return sb.toString();
    }

    @Override
    public List<String> getDataTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Varchar(30)");
        list.add("Date");
        list.add("Integer");
        list.add("SmallInt");
        list.add("Float");
        return list;
    }
}

