/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.form.view.common;

import com.bstek.dorado.annotation.DataProvider;
import com.bstek.dorado.annotation.DataResolver;
import com.bstek.dorado.data.provider.manager.DataProviderManager;
import com.bstek.dorado.data.type.AggregationDataType;
import com.bstek.dorado.data.type.DataType;
import com.bstek.dorado.data.type.EntityDataType;
import com.bstek.dorado.data.type.property.BasePropertyDef;
import com.bstek.dorado.data.type.property.Mapping;
import com.bstek.dorado.data.type.property.PropertyDef;
import com.bstek.dorado.view.View;
import com.bstek.dorado.view.manager.ViewConfig;
import com.bstek.dorado.view.widget.data.DataSet;
import com.bstek.dorado.web.DoradoContext;
import com.bstek.uflo.command.Command;
import com.bstek.uflo.command.CommandService;
import com.bstek.uflo.form.action.Action;
import com.bstek.uflo.form.action.FormData;
import com.bstek.uflo.form.command.GetTableDataCommand;
import com.bstek.uflo.form.command.GetTableDefinitionCommand;
import com.bstek.uflo.form.command.SaveDataCommand;
import com.bstek.uflo.form.controller.FormHolder;
import com.bstek.uflo.form.model.Form;
import com.bstek.uflo.form.model.MappingProvider;
import com.bstek.uflo.form.model.MappingSource;
import com.bstek.uflo.form.model.TableColumn;
import com.bstek.uflo.form.model.TableDefinition;
import com.bstek.uflo.form.view.common.ComponentBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.htmlparser.Node;
import org.htmlparser.Parser;
import org.htmlparser.nodes.TagNode;
import org.htmlparser.util.NodeIterator;
import org.htmlparser.util.NodeList;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.util.SerializationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="uflo.form.commonPage")
public class CommonPage
implements ApplicationContextAware {
    @Autowired
    @Qualifier(value="uflo.commandService")
    private CommandService commandService;
    @Autowired
    @Qualifier(value="dorado.dataProviderManager")
    private DataProviderManager dataProviderManager;
    private EntityDataType dataTypeMaster;
    private EntityDataType dataTypeSlave;
    private ApplicationContext applicationContext;
    private Collection<ComponentBuilder> builders;

    public void onInit(ViewConfig config) throws Exception {
        HttpServletRequest request = DoradoContext.getCurrent().getRequest();
        String tableId = request.getParameter("tableId");
        if (StringUtils.isEmpty((String)tableId)) {
            return;
        }
        TableDefinition table = (TableDefinition)this.commandService.executeCommand((Command)new GetTableDefinitionCommand(Long.valueOf(tableId)));
        if (table == null) {
            throw new IllegalArgumentException("Table " + tableId + " is not exist.");
        }
        this.dataTypeMaster = (EntityDataType)config.createDataType("dataTypeMaster");
        HashMap<String, Boolean> mappingMap = new HashMap<String, Boolean>();
        this.buildDataTypeProperty(config, table, this.dataTypeMaster, mappingMap);
        if (table.getSlaveTables().size() > 0) {
            TableDefinition slaveTable = table.getSlaveTables().get(0);
            this.dataTypeSlave = (EntityDataType)config.createDataType("dataTypeSlave");
            this.buildDataTypeProperty(config, slaveTable, this.dataTypeSlave, null);
            BasePropertyDef salveProperty = new BasePropertyDef("salvetables");
            AggregationDataType refDataType = new AggregationDataType();
            refDataType.setId("[dataTypeSlave]");
            refDataType.setElementDataType((DataType)this.dataTypeSlave);
            salveProperty.setDataType((DataType)refDataType);
            this.dataTypeMaster.addPropertyDef((PropertyDef)salveProperty);
        }
        View view = config.getView();
        Form form = FormHolder.getForm();
        if (form == null) {
            throw new IllegalArgumentException("Invalid request.");
        }
        String content = (String)SerializationUtils.deserialize((byte[])form.getContent());
        String html = "<body>" + content + "</body>";
        HashMap<String, com.bstek.dorado.view.widget.Component> map = new HashMap<String, com.bstek.dorado.view.widget.Component>();
        Parser parser = new Parser();
        parser.setResource(html);
        NodeIterator iterator = parser.elements();
        while (iterator.hasMoreNodes()) {
            Node node = iterator.nextNode();
            this.parseXml(node, view, map, mappingMap, table);
        }
        DataSet ds = new DataSet();
        ds.setId("dataSetTable");
        ds.setDataType((DataType)this.dataTypeMaster);
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        String businessId = request.getParameter("businessId");
        parameter.put("businessId", businessId);
        parameter.put("tableId", Long.valueOf(tableId));
        ds.setParameter(parameter);
        ds.setDataProvider(this.dataProviderManager.getDataProvider("uflo.form.commonPage#loadTableData"));
        view.addChild((com.bstek.dorado.view.widget.Component)ds);
    }

    private void parseXml(Node node, View view, Map<String, com.bstek.dorado.view.widget.Component> map, Map<String, Boolean> mappingMap, TableDefinition table) throws Exception {
        NodeList children;
        if (!(node instanceof TagNode)) {
            return;
        }
        TagNode element = (TagNode)node;
        for (ComponentBuilder builder : this.builders) {
            if (!builder.support(element)) continue;
            builder.build(element, view, map, mappingMap, table);
            break;
        }
        if ((children = element.getChildren()) != null && children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                Node cnode = children.elementAt(i);
                this.parseXml(cnode, view, map, mappingMap, table);
            }
        }
    }

    private void buildDataTypeProperty(ViewConfig config, TableDefinition table, EntityDataType dataType, Map<String, Boolean> mappingMap) throws Exception {
        BasePropertyDef primaryKeyDef = new BasePropertyDef("ID_");
        primaryKeyDef.setDataType(config.getDataType("long"));
        dataType.addPropertyDef((PropertyDef)primaryKeyDef);
        for (TableColumn col : table.getColumns()) {
            BasePropertyDef def = new BasePropertyDef(col.getName().toLowerCase());
            def.setLabel(col.getMemo());
            def.setDataType(this.getDataType(config, col.getDataType()));
            def.setDefaultValue((Object)col.getDefaultValue());
            def.setRequired(!col.isEmpty());
            String mappingStr = col.getMapping();
            if (StringUtils.isNotEmpty((String)mappingStr)) {
                def.setMapping(this.buildMapping(col.getMapping(), col.getMappingSource()));
                if (mappingMap != null) {
                    mappingMap.put(col.getName(), true);
                }
            } else if (mappingMap != null) {
                mappingMap.put(col.getName(), false);
            }
            dataType.addPropertyDef((PropertyDef)def);
        }
    }

    private Mapping buildMapping(String mappingStr, MappingSource mappingSource) {
        Mapping mapping = new Mapping();
        mapping.setKeyProperty("key");
        mapping.setValueProperty("label");
        if (mappingSource.equals((Object)MappingSource.MappingProvider)) {
            MappingProvider provider = (MappingProvider)this.applicationContext.getBean(mappingStr);
            mapping.setMapValues(provider.getMapping());
        } else {
            ArrayList list = new ArrayList();
            for (String pairs : mappingStr.split(";")) {
                String[] pair = pairs.split("=");
                if (pair.length != 2) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("key", pair[0]);
                map.put("label", pair[1]);
                list.add(map);
            }
            mapping.setMapValues(list);
        }
        return mapping;
    }

    private DataType getDataType(ViewConfig config, String dataType) throws Exception {
        String[] numbers;
        int end;
        int start;
        String type = null;
        if ((dataType = dataType.toLowerCase()).startsWith("varchar") || dataType.startsWith("nvarchar")) {
            type = "String";
        }
        if (dataType.startsWith("double")) {
            type = "double";
        }
        if (dataType.startsWith("float")) {
            type = "float";
        }
        if (dataType.startsWith("bit")) {
            type = "boolean";
        }
        if (dataType.startsWith("long")) {
            type = "long";
        }
        if (dataType.startsWith("date")) {
            type = "Date";
        }
        if (dataType.startsWith("int") || dataType.startsWith("smallint") || dataType.startsWith("tinyint") || dataType.startsWith("integer")) {
            type = "int";
        }
        if (dataType.startsWith("number") && dataType.indexOf("(") > -1) {
            start = dataType.indexOf("(") + 1;
            numbers = dataType.substring(start, end = dataType.lastIndexOf(")")).split(",");
            type = numbers.length == 1 ? "long" : (Integer.parseInt(numbers[1]) > 0 ? "double" : "long");
        }
        if (dataType.startsWith("numeric") && dataType.indexOf("(") > -1) {
            start = dataType.indexOf("(") + 1;
            numbers = dataType.substring(start, end = dataType.lastIndexOf(")")).split(",");
            type = numbers.length == 1 ? "long" : (Integer.parseInt(numbers[1]) > 0 ? "double" : "long");
        }
        if (type == null) {
            throw new IllegalArgumentException("Unsupport datatype:" + dataType + "");
        }
        return config.getDataType(type);
    }

    @DataProvider
    public Map<String, Object> loadTableData(String businessId, long tableId) {
        if (StringUtils.isEmpty((String)businessId)) {
            return new HashMap<String, Object>();
        }
        TableDefinition table = (TableDefinition)this.commandService.executeCommand((Command)new GetTableDefinitionCommand(tableId));
        String keyValue = businessId;
        String tableName = table.getName();
        String sql = "select * from " + tableName + " where " + "ID_" + "=?";
        List<TableDefinition> slaveTables = table.getSlaveTables();
        if (slaveTables != null && slaveTables.size() > 0) {
            TableDefinition slaveTable = slaveTables.get(0);
            String slaveSql = "select * from " + slaveTable.getName() + " where " + "MASTER_ID_" + "=?";
            return (Map)this.commandService.executeCommand((Command)new GetTableDataCommand(sql, slaveSql, keyValue));
        }
        return (Map)this.commandService.executeCommand((Command)new GetTableDataCommand(sql, null, keyValue));
    }

    @DataResolver
    public void saveData(Map<String, Object> data, Map<String, Object> parameter) {
        Object processData;
        String processId;
        String actionStr = (String)parameter.get("action");
        String tableId = (String)parameter.get("tableId");
        String taskId = (String)parameter.get("taskId");
        FormData formData = new FormData();
        if (StringUtils.isNotEmpty((String)taskId)) {
            formData.setTaskId(Long.valueOf(taskId));
        }
        if (StringUtils.isNotEmpty((String)(processId = (String)parameter.get("processId")))) {
            formData.setProcessId(Long.valueOf(processId));
        }
        if ((processData = parameter.get("processData")) != null) {
            formData.setProcessData((Map)processData);
        }
        Action action = (Action)this.applicationContext.getBean(actionStr);
        TableDefinition table = (TableDefinition)this.commandService.executeCommand((Command)new GetTableDefinitionCommand(Long.valueOf(tableId)));
        formData.setMasterTable(data);
        formData.setTable(table);
        Object slaveData = data.get("salvetables");
        if (slaveData != null) {
            formData.setSlaveTable((Collection)slaveData);
        }
        this.commandService.executeCommand((Command)new SaveDataCommand(action, formData));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.builders = applicationContext.getBeansOfType(ComponentBuilder.class).values();
    }
}

