/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.form.command;

import com.bstek.dorado.data.provider.Page;
import com.bstek.uflo.command.Command;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.form.model.TableDefinition;
import java.util.Collection;
import org.hibernate.Query;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryTableCommand
implements Command<Object> {
    private Long parentId;
    private Page<TableDefinition> page;

    public QueryTableCommand(Page<TableDefinition> page, Long parentId) {
        this.page = page;
        this.parentId = parentId;
    }

    public Object execute(Context context) {
        Query query = null;
        String hql = "from " + TableDefinition.class.getName() + "";
        int count = 0;
        Session session = context.getSession();
        if (this.parentId != null && this.parentId > 0L) {
            hql = hql + " where parentId=:parentId";
            query = session.createQuery(hql + " order by createDate desc");
            query.setLong("parentId", this.parentId.longValue());
            count = this.queryCount(session, hql);
        } else {
            hql = hql + " where parentId=0";
            query = session.createQuery(hql + " order by createDate desc");
            query = session.createQuery(hql);
            count = this.queryCount(session, hql);
        }
        query.setFirstResult((this.page.getPageNo() - 1) * this.page.getPageSize());
        query.setMaxResults(this.page.getPageSize());
        this.page.setEntities((Collection)query.list());
        this.page.setEntityCount(count);
        return null;
    }

    private int queryCount(Session session, String hql) {
        Object obj;
        int count = 0;
        Query countQuery = session.createQuery("select count(*) " + hql);
        if (this.parentId != null && this.parentId > 0L) {
            countQuery.setLong("parentId", this.parentId.longValue());
        }
        if ((obj = countQuery.uniqueResult()) == null) {
            obj = 0;
        }
        if (obj instanceof Integer) {
            count = (Integer)obj;
        } else if (obj instanceof Long) {
            count = ((Long)obj).intValue();
        } else {
            throw new IllegalArgumentException("Query count was failed.");
        }
        return count;
    }
}

