﻿CKEDITOR.plugins.add( 'uflo', {
        requires: 'widget,dialog,fakeobjects',
        lang: 'zh-cn',
        icons: 'actionbutton,checkbox,radio,select,textarea,textfield,text,toolbar,datagrid,approveopinion,approveform',
        hidpi: true,
        onLoad: function() {
                CKEDITOR.addCss('.uflotoolbar' +
                        '{' +
						    'padding-top: 1px;'+
						    'padding-bottom: 2px;'+
						    'padding-left: 10px;'+
						    'margin: 2px;'+
						    'background:#EEE  url(' + CKEDITOR.getUrl( this.path + 'images/toolbar-bg.gif' ) + ') repeat-x top;'+
						    'border-radius: 1px;'+
						    'border: 1px solid #ddd;'+
                        '}\n');
                CKEDITOR.addCss('.uflotoolbarbutton' +
                        '{' +
							'height:22px;' +
							'margin-left:10px;' +
							'line-height:20px;' +
							'vertical-align:baseline;' +
							'font-size:12px;' +
							'font-family:"Microsoft YaHei";' +
							'cursor:default;' +
                        '}\n');
                CKEDITOR.addCss('.uflotext' +
                        '{' +
							'border:solid gray 1px;' +
							'height:22px;' +
							'text-align:left;' +
                        '}\n');
                CKEDITOR.addCss('.uflotextarea' +
                        '{' +
							'border:solid gray 1px;' +
							'overflow-y:scroll;' +
							'text-align:left;' +
                        '}\n');
                CKEDITOR.addCss('.ufloselect' +
                        '{' +
							'border:solid gray 1px;' +
							'text-align:left;' +
                        '}\n');
                CKEDITOR.addCss('.uflobutton' +
                        '{}\n');
                CKEDITOR.addCss('.uflocheckbox' +
                        '{' +
							'border:solid gray 1px;' +
                        '}\n');
                CKEDITOR.addCss('.ufloradio' +
                        '{' +
							'border:solid gray 1px;' +
                        '}\n');
                CKEDITOR.addCss('.uflogrid' +
                        '{' +
							'width:100%;' +
                        '}\n');
                CKEDITOR.addCss('.uflogridtoolbar' +
                        '{' +
						    'padding-top: 1px;'+
						    'padding-bottom: 2px;'+
						    'padding-left: 10px;'+
							'text-align:left;' +
						    'margin: 2px;'+
						    'background:#EEE  url(' + CKEDITOR.getUrl( this.path + 'images/toolbar-bg.gif' ) + ') repeat-x;'+
						    'border-radius: 1px;'+
						    'border: 1px solid #ddd;'+
                        '}\n');
                CKEDITOR.addCss('.uflogridtoolbarbutton' +
                        '{' +
						    'padding-left: 5px;'+
						    'font-size: 12px;'+
						    'font-family:"Microsoft YaHei";'+
                        '}\n');
                CKEDITOR.addCss('.uflogridheader' +
                        '{' +
						    'background:#F0F0F0 url(' + CKEDITOR.getUrl( this.path + 'images/header-bg.gif' ) + ') repeat-x;'+
						    'height: 24px;'+
							'border: solid 1px #ddd;'+
                        '}\n');
                CKEDITOR.addCss('.uflogridcontent' +
                        '{' +
						    'background:#F0F0F0;'+
						    'height: 28px;'+
							'border: solid 1px #ddd;'+
                        '}\n');
                CKEDITOR.addCss('.uflogridcolumn' +
                        '{' +
							'width:160px;' +
							'height:24px;'+
							'text-align:center;'+
							'display:inline-block;'+
							'border-right: solid 1px #ddd;'+
							'font-size: 12px;'+
							'font-family:"Microsoft YaHei";'+
                        '}\n');
                CKEDITOR.addCss('.uflogridcontentvalue' +
                        '{' +
							'width:160px;' +
							'height:28px;'+
							'text-align:center;'+
							'display:inline-block;'+
							'border-right: solid 1px #ddd;'+
							'font-size: 12px;'+
                        '}\n');
                CKEDITOR.addCss('.ufloapproveopinion' +
                        '{' +
							'border:solid 2px #D3A608;' +
							'font-size: 16px;'+
							'font-family:"Microsoft YaHei";'+
                        '}\n');
                CKEDITOR.addCss('.ufloapproveopinionbgcolor' +
                        '{' +
							'background-color:#fdfcc2;' +
                        '}\n');
                CKEDITOR.addCss('.ufloapproveform' +
                        '{' +
							'border:solid 1px #D3A608;' +
							'font-size: 16px;'+
							'font-family:"Microsoft YaHei";'+
                        '}\n');
        },
        init: function( editor ) {
	        	editor.widgets.add("approveform",{
	            	button:"任务处理表单",
	           		template:"<table class=\"ufloapproveform\" style=\"width:100%\" border=\"0\"><tr><td class=\"ufloapproveopinionbgcolor\" align=\"center\"><div style=\"margin:5px\" id=\""+CKEDITOR.tools.getNextId()+"\"><img src=\""+CKEDITOR.getUrl( this.path + 'images/approvecomponent.png' )+"\"/>处理任务的表单</div></td></tr></table>",
	            	allowedContent:'table(!ufloapproveform){!width}[border];td(!ufloapproveopinionbgcolor)[align];div{!margin}[id]',
	            	requiredContent: 'table(ufloapproveform)[width]',
		            upcast: function( element ) {
		                return element.name == 'table' && element.hasClass('ufloapproveform');
		            }
				});
	        	editor.widgets.add("approveopinion",{
	            	button:"任务处理历史",
	           		template:"<table class=\"ufloapproveopinion\" style=\"width:100%\" border=\"0\"><tr><td style=\"background-color:#fdfcc2\" align=\"center\"><div style=\"margin:5px\" id=\""+CKEDITOR.tools.getNextId()+"\"><img src=\""+CKEDITOR.getUrl( this.path + 'images/component.png' )+"\"/>任务处理历史信息</div></td></tr></table>",
	            	allowedContent:'table(!ufloapproveopinion){!width}[border];td{!background-color}[align];div{!margin}[id]',
	            	requiredContent: 'table(ufloapproveopinion)[width]',
		            upcast: function( element ) {
		                return element.name == 'table' && element.hasClass('ufloapproveopinion');
		            }
				});
	        	editor.widgets.add("actionbutton",{
	            	button:"按钮",
					dialog:"actionbutton",
	           		template:'<input class="uflobutton" type="button"></input>',
	            	allowedContent:'input(!uflobutton){!width}[id,type,value,action]',
	            	requiredContent: 'input(uflobutton)[id,type,value,action]',
		            upcast: function( element ) {
		                return element.name == 'input' && element.hasClass('uflobutton');
		            },
					data:function(){
						this.element.setAttribute("id",CKEDITOR.tools.getNextId());
						var action=this.data.action;
						if(action){
							this.element.setAttribute("action",action);						
						}
						var text=this.data.text;
						if(text){
							this.element.setAttribute("value",text);						
						}
						if(this.data.width){
							this.element.setAttribute("style","width:"+this.data.width+"");
						}
					}
				});
	        	editor.widgets.add("toolbar",{
	            	button:"工具栏",
					dialog:"toolbar",
	           		template:'<div class="uflotoolbar"></div>',
	            	allowedContent:'div(!uflotoolbar)[id];span(!uflotoolbarbutton)(!uflotoolbarbutton)[action,id]',
	            	requiredContent: 'div(uflotoolbar)[id]',
		            upcast: function( element ) {
		                return element.name == 'div' && element.hasClass( 'uflotoolbar' );
		            },
					data:function(){
						this.element.setAttribute("id",CKEDITOR.tools.getNextId());
						var buttons=this.data.buttons;
						if(buttons){
							var children=this.element.getChildren();
							if(children){
								for(var i=children.count();i>-1;i--){
									var node=children.getItem(i);
									if(node)node.remove();
								}
							}
							for(var i=0;i<buttons.length;i++){
								var button=buttons[i];
								this.element.appendHtml("<span class=\"uflotoolbarbutton\" id=\""+CKEDITOR.tools.getNextId()+"\" action=\""+button.value+"\">"+button.text+"</span>");
							}
						}
					}
				});
				editor.widgets.add("text",{
					button: "单行文本框",
					dialog:"text",
	           		template:'<div class="uflotext"></div>',
	            	allowedContent:'div(!uflotext){!width}[type,bindingfield,id]',
	            	requiredContent:'div(uflotext)[type,bindingfield,id]',
		            upcast: function( element ) {
		                return element.name == 'div' && element.hasClass('uflotext');
		            },
					data:function(){
						this.element.setAttribute("id",CKEDITOR.tools.getNextId());
						if(this.data.bindingfield){
							this.element.setAttribute("bindingfield",this.data.bindingfield);
							this.element.setText("$F{"+this.data.bindingfield+"}");
						}
						if(this.data.width){
							this.element.setAttribute("style","width:"+this.data.width+"");
						}
						if(this.data.type){
							this.element.setAttribute("type",this.data.type);
						}
					}
				});
				editor.widgets.add("checkbox",{
					button: "复选框",
					dialog:"checkbox",
	           		template:'<input type="checkbox" class="uflocheckbox"></input>',
	            	allowedContent:'input(!uflocheckbox)[type,bindingfield,id]',
	            	requiredContent:'input(uflocheckbox)[type,bindingfield,id]',
		            upcast: function( element ) {
		                return element.name == 'input' && element.hasClass('uflocheckbox');
		            },
					data:function(){
						this.element.setAttribute("id",CKEDITOR.tools.getNextId());
						if(this.data.bindingfield){
							this.element.setAttribute("bindingfield",this.data.bindingfield);
						}
					}
				});
				editor.widgets.add("radio",{
					button: "单选框",
					dialog:"radio",
	           		template:'<input type="radio" class="ufloradio"></input>',
	            	allowedContent:'input(!ufloradio)[type,bindingfield,id]',
	            	requiredContent:'input(ufloradio)[type,bindingfield,id]',
		            upcast: function( element ) {
		                return element.name == 'input' && element.hasClass('ufloradio');
		            },
					data:function(){
						this.element.setAttribute("id",CKEDITOR.tools.getNextId());
						if(this.data.bindingfield){
							this.element.setAttribute("bindingfield",this.data.bindingfield);
						}
					}
				});
				editor.widgets.add("textarea",{
					button: "多行文本框",
					dialog:"textarea",
	           		template:'<div cols=80 rows=5 class="uflotextarea"></div>',
	            	allowedContent:'div(!uflotextarea){!width,!height}[bindingfield,id]',
	            	requiredContent:'div(uflotextarea)[bindingfield,id]',
		            upcast: function( element ) {
		                return element.name == 'div' && element.hasClass('uflotextarea');
		            },
					data:function(){
						this.element.setAttribute("id",CKEDITOR.tools.getNextId());
						if(this.data.bindingfield){
							this.element.setAttribute("bindingfield",this.data.bindingfield);
							this.element.setText("$F{"+this.data.bindingfield+"}");
						}
						if(this.data.width){
							if(this.data.height){
								this.element.setAttribute("style","width:"+this.data.width+";height:"+this.data.height+"");
							}else{
								this.element.setAttribute("style","width:"+this.data.width+"");								
							}
						}
						if(this.data.height){
							if(this.data.width){
								this.element.setAttribute("style","width:"+this.data.width+";height:"+this.data.height+"");
							}else{
								this.element.setAttribute("style","height:"+this.data.height+"");								
							}
						}
					}
				});
				editor.widgets.add("select",{
					button: "下拉框选择框",
					dialog:"select",
	           		template:'<select class="ufloselect"></select>',
	            	allowedContent:'select(!ufloselect){!width}[bindingfield,width,id];option[value]',
	            	requiredContent:'select(ufloselect)[bindingfield,id]',
		            upcast: function( element ) {
		                return element.name == 'select' && element.hasClass('ufloselect');
		            },
					data:function(){
						this.element.setAttribute("id",CKEDITOR.tools.getNextId());
						if(this.data.bindingfield){
							this.element.setAttribute("bindingfield",this.data.bindingfield);
							var children=this.element.getChildren();
							if(children){
								for(var i=0;i<children.count();i++){
									children.getItem(i).remove();
								}
							}
							this.element.appendHtml("<option>$F{"+this.data.bindingfield+"}</option>");
						}
						if(this.data.width){
							this.element.setAttribute("width",this.data.width);
							this.element.setAttribute("style","width:"+this.data.width+"");
						}
					}
				});
				
				editor.widgets.add("datagrid",{
					button: "数据表格",
					dialog:"datagrid",
	           		template:'<div class="uflogrid"><div class="uflogridtoolbar">'+
						'<span class="uflogridtoolbarbutton">添加</span><span class="uflogridtoolbarbutton">删除</span>'+
						'</div><div class="uflogridheader"></div><div class="uflogridcontent"></div></div>',
	            	allowedContent:'div(!uflogrid)[id];div(!uflogridtoolbar);div(!uflogridheader);div(!uflogridcontent);span(!uflogridcolumn,){!width}[bindingfield];span(!uflogridcontentvalue){!width}',
	            	requiredContent:'div(uflogrid)[id]',
		            upcast: function( element ) {
		                return element.name == 'div' && element.hasClass('uflogrid');
		            },
					data:function(){
						this.element.setAttribute("id",CKEDITOR.tools.getNextId());
						var columns=this.data.columns;
						if(!columns){
							return;
						}
						var children=this.element.getChildren();
						for(var i=0;i<children.count();i++){
							var element=children.getItem(i);
							if(element.hasClass("uflogridheader")){
								for(var j=element.getChildCount();j>-1;j--){
									var node=element.getChildren().getItem(j);
									if(node)node.remove();
								}
								var length=columns.length;
								var percentValue=parseInt(100/length);
								var modValue=(100%length);
								for(var j=0;j<length;j++){
									var col=columns[j];
									var newSpan=new CKEDITOR.dom.element("span");
									newSpan.addClass("uflogridcolumn");
									newSpan.setAttribute("bindingfield",col.value);
									newSpan.setHtml(col.text);
									var percent=percentValue;
									if(j==(length-1)){
										percent+=modValue;
										percent--;
									}
									newSpan.setStyle("width",percent+"%");
									element.append(newSpan);
								}
							}else if(element.hasClass("uflogridcontent")){
								for(var j=element.getChildCount();j>-1;j--){
									var node=element.getChildren().getItem(j);
									if(node)node.remove();
								}
								var length=columns.length;
								var percentValue=parseInt(100/length);
								var modValue=(100%length);
								for(var j=0;j<length;j++){
									var col=columns[j];
									var newSpan=new CKEDITOR.dom.element("span");
									newSpan.addClass("uflogridcontentvalue");
									newSpan.setHtml("......");
									var percent=percentValue;
									if(j==(length-1)){
										percent+=modValue;
										percent--;
									}
									newSpan.setStyle("width",percent+"%");
									element.append(newSpan);
								}
							}
						}
					}
				});

                var dialogPath = this.path + 'dialogs/';
                CKEDITOR.dialog.add('actionbutton', dialogPath + 'actionbutton.js' );
                CKEDITOR.dialog.add('checkbox', dialogPath + 'checkbox.js' );
                CKEDITOR.dialog.add('radio', dialogPath + 'radio.js' );
                CKEDITOR.dialog.add('text', dialogPath + 'text.js' );
                CKEDITOR.dialog.add('textarea', dialogPath + 'textarea.js' );
                CKEDITOR.dialog.add('select', dialogPath + 'select.js' );
                //CKEDITOR.dialog.add('button', dialogPath + 'button.js' );
                CKEDITOR.dialog.add('toolbar', dialogPath + 'toolbar.js' );
                CKEDITOR.dialog.add('datagrid', dialogPath + 'datagrid.js' );
        }
});
