﻿CKEDITOR.dialog.add('textfield',function(editor){
    var autoAttributes = {
        value: 1,
        size: 1,
        maxLength: 1
    };
    
    var acceptedTypes = {
        email: 1,
        password: 1,
        search: 1,
        tel: 1,
        text: 1,
        url: 1
    };
    
    function autoCommit(data){
        var element = data.element;
        var value = this.getValue();
        
        value ? element.setAttribute(this.id,value) : element.removeAttribute(this.id);
    };
    
    function autoSetup(element){
        var value = element.hasAttribute(this.id) && element.getAttribute(this.id);
        this.setValue(value || '');
    };
    
    return {
        title: editor.lang.uflo.textfield.title,
        minWidth: 320,
        minHeight: 150,
        onShow: function(){
            delete this.textField;            
            var element = this.getParentEditor().getSelection().getSelectedElement();
            if (element && element.getName() == "input" && (acceptedTypes[element.getAttribute('type')] || !element.getAttribute('type'))) {
                this.textField = element;
                this.setupContent(element);
            }        
		},
        onOk: function(){
            var editor = this.getParentEditor(),element = this.textField,isInsertMode = !element;
            
            if (isInsertMode) {
                element = editor.document.createElement('input');
                element.setAttribute('type','text');
            };
            var data = {
                element: element
            };
            
            if (isInsertMode) {
                editor.insertElement(data.element);				
			}
            
            this.commitContent(data);
			var field=data.element.getAttribute("bindingfield");
			if(field){
				data.element.setAttribute("value","$F{"+field+"}");
			}
            
            // Element might be replaced by commitment.
            if (!isInsertMode) 
                editor.getSelection().selectElement(data.element);
        },
        onLoad: function(){
            this.foreach(function(contentObj){
                if (contentObj.getValue) {
                    if (!contentObj.setup) 
                        contentObj.setup = autoSetup;
                    if (!contentObj.commit) 
                        contentObj.commit = autoCommit;
                }            });
        },
        contents: [{
            id: 'info',
            label: editor.lang.uflo.textfield.title,
            title: editor.lang.uflo.textfield.title,
            elements: [
				{
	                type: 'hbox',
	                children: [
						{
		                    id: 'bindingfield',
		                    type: 'select',
							style:"width:320px",
		                    label: editor.lang.uflo.textfield.bindingfiled,
		                    'default': '',
							items: [
									[editor.lang.uflo.textfield.typeEmail,'email'],
									[editor.lang.uflo.textfield.typePass,'password'],
									[editor.lang.uflo.textfield.typeUrl,'url']
								],
		                    accessKey: 'N'             
						}
					]
	        	},
				{
					type: 'hbox',
					widths: ['40%','60%'],
					children: [
						{
		                    id: 'size',
		                    type: 'text',
							style:"width:150px",
		                    label: editor.lang.uflo.textfield.charWidth,
		                    'default': '100%',
		                    accessKey: 'C'
		                    //validate: CKEDITOR.dialog.validate.integer(editor.lang.common.validateNumberFailed)
		                },
						{
			                id: 'editortype',
			                type: 'select',
							style:"width:150px",
			                label: editor.lang.uflo.textfield.type,
			                'default': 'text',
			                accessKey: 'M',
			                items: [
										[editor.lang.uflo.textfield.typePass,'password'],
										[editor.lang.uflo.textfield.typeText,'text']
									]           
						}
					]
				}
			]
        }]
    };
});
