/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.form.view.common.impl;

import com.bstek.dorado.common.event.ClientEvent;
import com.bstek.dorado.common.event.DefaultClientEvent;
import com.bstek.dorado.view.View;
import com.bstek.dorado.view.widget.Component;
import com.bstek.dorado.view.widget.Control;
import com.bstek.dorado.view.widget.base.toolbar.Button;
import com.bstek.dorado.view.widget.base.toolbar.ToolBar;
import com.bstek.uflo.form.action.Action;
import com.bstek.uflo.form.model.TableDefinition;
import com.bstek.uflo.form.view.common.AbstractButtonBuilder;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.htmlparser.Node;
import org.htmlparser.nodes.TagNode;
import org.htmlparser.tags.Div;
import org.htmlparser.tags.Span;
import org.htmlparser.util.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@org.springframework.stereotype.Component(value="com.bstek.uflo.form.view.common.impl.ToolbarBuilder")
public class ToolbarBuilder
extends AbstractButtonBuilder {
    @Override
    public boolean support(TagNode node) {
        Div div;
        String css;
        return node instanceof Div && (css = (div = (Div)node).getAttribute("class")) != null && css.equals("uflotoolbar");
    }

    @Override
    public void build(TagNode node, View view, Map<String, Component> map, Map<String, Boolean> mappingMap, TableDefinition table) {
        ToolBar toolbar = new ToolBar();
        String id = node.getAttribute("id");
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        toolbar.setRenderOn("#" + id);
        if (map.containsKey(id)) {
            return;
        }
        map.put(id, (Component)toolbar);
        toolbar.setId(id);
        view.addChild((Component)toolbar);
        NodeList list = node.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            Span span;
            String css;
            Node cnode = list.elementAt(i);
            if (!(cnode instanceof Span) || (css = (span = (Span)cnode).getAttribute("class")) == null || !css.equals("uflotoolbarbutton")) continue;
            Button button = this.buildButton(span, view, table);
            toolbar.addItem((Control)button);
        }
    }

    private Button buildButton(Span span, View view, TableDefinition table) {
        String actionStr = span.getAttribute("action");
        if (StringUtils.isEmpty((String)actionStr)) {
            return null;
        }
        String id = span.getAttribute("id");
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        Action action = (Action)this.applicationContext.getBean(actionStr);
        action.onViewInit(view);
        Button button = new Button();
        button.setCaption(action.getName());
        button.setIcon(action.getIcon());
        button.setId(id);
        String script = action.getClickScript("updateActionSave");
        DefaultClientEvent event = new DefaultClientEvent();
        if (StringUtils.isNotEmpty((String)script)) {
            StringBuffer sb = new StringBuffer();
            sb.append("var result=view.id(\"dataSetTable\").getData().validate();if(result!='ok')return;\n");
            sb.append("view.id(\"updateActionSave\").set(\"parameter\",{action:\"" + actionStr + "\",buttonId:\"" + id + "\"});\n");
            script = sb.toString() + script;
            event.setScript(script);
        } else {
            event.setScript(this.buildEventScript(view, action, actionStr, id));
        }
        button.addClientEventListener("onClick", (ClientEvent)event);
        return button;
    }
}

