/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.form.view.common.impl;

import com.bstek.dorado.view.View;
import com.bstek.dorado.view.widget.Control;
import com.bstek.dorado.view.widget.form.autoform.AutoForm;
import com.bstek.dorado.view.widget.form.autoform.AutoFormElement;
import com.bstek.dorado.view.widget.layout.CommonLayoutConstraint;
import com.bstek.dorado.web.DoradoContext;
import com.bstek.uflo.client.service.TaskClient;
import com.bstek.uflo.form.model.TableColumn;
import com.bstek.uflo.form.model.TableDefinition;
import com.bstek.uflo.form.view.common.AbstractComponentBuilder;
import com.bstek.uflo.model.ProcessDefinition;
import com.bstek.uflo.model.task.Task;
import com.bstek.uflo.process.node.FormElement;
import com.bstek.uflo.process.node.TaskNode;
import com.bstek.uflo.process.security.Authority;
import com.bstek.uflo.service.ProcessService;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.htmlparser.Node;
import org.htmlparser.nodes.TagNode;
import org.htmlparser.tags.Div;
import org.htmlparser.tags.TableRow;
import org.htmlparser.tags.TableTag;
import org.htmlparser.util.NodeList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="com.bstek.uflo.form.view.common.ApproveAutoFormBuilder")
public class ApproveAutoFormBuilder
extends AbstractComponentBuilder {
    @Autowired
    @Qualifier(value="uflo.taskClient")
    private TaskClient taskClient;
    @Autowired
    @Qualifier(value="uflo.processService")
    private ProcessService processService;

    @Override
    public boolean support(TagNode node) {
        TableTag table;
        String css;
        return node instanceof TableTag && (css = (table = (TableTag)node).getAttribute("class")) != null && css.equals("ufloapproveform");
    }

    @Override
    public void build(TagNode node, View view, Map<String, com.bstek.dorado.view.widget.Component> map, Map<String, Boolean> mappingMap, TableDefinition table) {
        NodeList tdList;
        TableTag tableTag = (TableTag)node;
        NodeList trList = tableTag.getChildren();
        if (trList.size() == 0) {
            return;
        }
        Node trNode = null;
        for (int i = 0; i < trList.size(); ++i) {
            Node n = trList.elementAt(i);
            if (n == null || !(n instanceof TableRow)) continue;
            trNode = n;
            break;
        }
        if ((tdList = trNode.getChildren()).size() == 0) {
            return;
        }
        org.htmlparser.tags.TableColumn td = null;
        for (int i = 0; i < tdList.size(); ++i) {
            Node n = tdList.elementAt(i);
            if (n == null || !(n instanceof org.htmlparser.tags.TableColumn)) continue;
            td = (org.htmlparser.tags.TableColumn)n;
            break;
        }
        Div div = null;
        NodeList divList = td.getChildren();
        for (int i = 0; i < divList.size(); ++i) {
            Node n = divList.elementAt(i);
            if (n == null || !(n instanceof Div)) continue;
            div = (Div)n;
            break;
        }
        if (div == null) {
            return;
        }
        String id = div.getAttribute("id");
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        HttpServletRequest request = DoradoContext.getCurrent().getRequest();
        if (map.containsKey(id)) {
            return;
        }
        AutoForm autoform = this.buildAutoForm(table, request.getParameter("processId"), request.getParameter("taskId"));
        if (autoform != null) {
            autoform.setId("autoFormTaskProcess");
            autoform.setRenderOn("#" + id);
            autoform.setId("autoFormTaskProcess");
            autoform.setLabelWidth(110);
            view.addChild((com.bstek.dorado.view.widget.Component)autoform);
            map.put(id, (com.bstek.dorado.view.widget.Component)autoform);
        }
    }

    private AutoForm buildAutoForm(TableDefinition table, String processId, String taskId) {
        if (StringUtils.isEmpty((String)processId) || StringUtils.isEmpty((String)taskId)) {
            return null;
        }
        AutoForm form = new AutoForm();
        form.setCols("*,*");
        ProcessDefinition process = this.processService.getProcessById(Long.valueOf(processId).longValue());
        Task task = this.taskClient.getTask(Long.valueOf(taskId).longValue());
        TaskNode taskNode = (TaskNode)process.getNode(task.getNodeName());
        List<TableColumn> columns = table.getColumns();
        List formElements = taskNode.getFormElements();
        for (FormElement element : formElements) {
            boolean exist = false;
            for (TableColumn col : columns) {
                if (!col.getName().equals(element.getName())) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            AutoFormElement autoFormElement = new AutoFormElement();
            autoFormElement.setName(element.getName());
            autoFormElement.setLabel(element.getCaption());
            autoFormElement.setEditorType(element.getEditorType());
            autoFormElement.setReadOnly(element.getAuthority().equals((Object)Authority.Read));
            form.addElement((Control)autoFormElement);
        }
        AutoFormElement formElement = new AutoFormElement();
        formElement.setName("TASK_OPINION_");
        formElement.setLabel("\u4efb\u52a1\u5904\u7406\u610f\u89c1");
        formElement.setLayoutConstraint((Object)this.buildLayoutConstraint("2", null));
        form.addElement((Control)formElement);
        return form;
    }

    private CommonLayoutConstraint buildLayoutConstraint(String colSpan, String rowSpan) {
        CommonLayoutConstraint commonLayoutConstraint = new CommonLayoutConstraint();
        if (StringUtils.isNotEmpty((String)colSpan)) {
            commonLayoutConstraint.put((Object)"colSpan", (Object)colSpan);
        }
        if (StringUtils.isNotEmpty((String)rowSpan)) {
            commonLayoutConstraint.put((Object)"rowSpan", (Object)rowSpan);
        }
        return commonLayoutConstraint;
    }
}

