/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.form.command;

import com.bstek.dorado.data.entity.EntityState;
import com.bstek.dorado.data.entity.EntityUtils;
import com.bstek.uflo.command.Command;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.form.model.TableColumn;
import com.bstek.uflo.form.model.TableDefinition;
import com.bstek.uflo.utils.EnvironmentUtils;
import com.bstek.uflo.utils.IDGenerator;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveTableCommand
implements Command<TableDefinition> {
    private Collection<TableDefinition> tables;

    public SaveTableCommand(Collection<TableDefinition> tables) {
        this.tables = tables;
    }

    public TableDefinition execute(Context context) {
        Session session = context.getSession();
        this.saveTables(session, this.tables);
        return null;
    }

    private void saveTables(Session session, Collection<TableDefinition> tableDefs) {
        for (TableDefinition table : tableDefs) {
            List<TableDefinition> children;
            EntityState state = EntityUtils.getState((Object)table);
            if (state.equals((Object)EntityState.NEW)) {
                table.setId(IDGenerator.getInstance().nextId());
                table.setCreateDate(new Date());
                table.setCategoryId(EnvironmentUtils.getEnvironment().getCategoryId());
                session.save((Object)table);
            } else if (state.equals((Object)EntityState.MODIFIED)) {
                session.saveOrUpdate((Object)table);
            } else if (state.equals((Object)EntityState.DELETED)) {
                session.createQuery("delete " + TableColumn.class.getName() + " where tableId=:tableId").setLong("tableId", table.getId()).executeUpdate();
                session.delete((Object)table);
            }
            List<TableColumn> columns = table.getColumns();
            if (columns != null && columns.size() > 0) {
                this.saveTableColumns(columns, session);
            }
            if ((children = table.getSlaveTables()) == null || children.size() <= 0) continue;
            this.saveTables(session, children);
        }
    }

    private void saveTableColumns(List<TableColumn> columns, Session session) {
        for (TableColumn column : columns) {
            EntityState state = EntityUtils.getState((Object)column);
            if (state.equals((Object)EntityState.NEW)) {
                column.setId(IDGenerator.getInstance().nextId());
                session.save((Object)column);
                continue;
            }
            if (state.equals((Object)EntityState.MODIFIED)) {
                session.saveOrUpdate((Object)column);
                continue;
            }
            if (!state.equals((Object)EntityState.DELETED)) continue;
            session.delete((Object)column);
        }
    }
}

