/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.form.command;

import com.bstek.dorado.data.provider.Page;
import com.bstek.uflo.command.Command;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.form.command.MapResultTransformer;
import com.bstek.uflo.form.model.TableDefinition;
import com.bstek.uflo.form.view.common.FormState;
import com.bstek.uflo.form.view.table.dialect.Dialect;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.hibernate.transform.ResultTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryDataCommand
implements Command<Object> {
    private Page<Map<String, Object>> page;
    private TableDefinition table;
    private FormState state;
    private Map<String, Object> orders;
    private Dialect dialect;

    public QueryDataCommand(Page<Map<String, Object>> page, TableDefinition table, FormState state, Map<String, Object> orders) {
        this.page = page;
        this.table = table;
        this.state = state;
        this.orders = orders;
    }

    public Object execute(Context context) {
        Session session = context.getSession();
        final Collection dialects = context.getApplicationContext().getBeansOfType(Dialect.class).values();
        session.doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                for (Dialect d : dialects) {
                    if (!d.support(connection)) continue;
                    QueryDataCommand.this.dialect = d;
                    break;
                }
            }
        });
        String sql = "from " + this.table.getName() + " where 1=1 ";
        if (this.state != null) {
            sql = sql + " and STATE_='" + this.state.toString() + "'";
        }
        String countSql = "select count(*) " + sql;
        SQLQuery countQuery = session.createSQLQuery(countSql);
        countQuery.setResultTransformer((ResultTransformer)new MapResultTransformer());
        Map countResult = (Map)countQuery.uniqueResult();
        Object countObj = countResult.values().iterator().next();
        int count = 0;
        count = countObj instanceof Integer ? (Integer)countObj : (countObj instanceof Long ? ((Long)countObj).intValue() : Integer.valueOf(countObj.toString()).intValue());
        this.page.setEntityCount(count);
        if (this.orders != null && this.orders.size() > 0) {
            for (String columnName : this.orders.keySet()) {
                sql = sql + " order by " + columnName + " " + this.orders.get(columnName) + ",";
            }
            if (sql.endsWith(",")) {
                sql = sql.substring(0, sql.length() - 1);
            }
        }
        String querySql = this.dialect.getPaginationSql("select * " + sql, this.page.getPageNo(), this.page.getPageSize());
        SQLQuery query = session.createSQLQuery(querySql);
        query.setResultTransformer((ResultTransformer)new MapResultTransformer());
        List result = query.list();
        List<TableDefinition> slaves = this.table.getSlaveTables();
        if (slaves == null || slaves.size() == 0) {
            return result;
        }
        for (Map map : result) {
            for (TableDefinition slave : slaves) {
                String slaveSql = "select * from " + slave.getName() + " where " + "MASTER_ID_" + "=" + map.get("ID_") + "";
                SQLQuery slaveQuery = session.createSQLQuery(slaveSql);
                slaveQuery.setResultTransformer((ResultTransformer)new MapResultTransformer());
                map.put("salvetables", slaveQuery.list());
            }
        }
        this.page.setEntities((Collection)result);
        return null;
    }
}

