/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.form.command;

import com.bstek.uflo.command.Command;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.form.model.TableColumn;
import com.bstek.uflo.form.model.TableDefinition;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetTableDefinitionCommand
implements Command<TableDefinition> {
    private long tableId;

    public GetTableDefinitionCommand(long tableId) {
        this.tableId = tableId;
    }

    public TableDefinition execute(Context context) {
        Session session = context.getSession();
        TableDefinition tableDef = (TableDefinition)session.get(TableDefinition.class, (Serializable)Long.valueOf(this.tableId));
        if (tableDef == null) {
            return null;
        }
        tableDef.setColumns(this.getTableColumns(session, this.tableId));
        List slaveTables = session.createQuery("from " + TableDefinition.class.getName() + " where parentId=:parentId").setLong("parentId", this.tableId).list();
        for (TableDefinition table : slaveTables) {
            table.setColumns(this.getTableColumns(session, table.getId()));
        }
        tableDef.setSlaveTables(slaveTables);
        return tableDef;
    }

    private List<TableColumn> getTableColumns(Session session, long tableId) {
        List cols = session.createQuery("from " + TableColumn.class.getName() + " where tableId=:tableId").setLong("tableId", tableId).list();
        return cols;
    }
}

