/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.form.action.impl;

import com.bstek.dorado.view.View;
import com.bstek.dorado.web.DoradoContext;
import com.bstek.uflo.client.service.TaskClient;
import com.bstek.uflo.form.action.FormData;
import com.bstek.uflo.form.action.impl.SaveFormDataAction;
import com.bstek.uflo.model.ProcessDefinition;
import com.bstek.uflo.model.task.Task;
import com.bstek.uflo.process.node.FormElement;
import com.bstek.uflo.process.node.TaskNode;
import com.bstek.uflo.service.ProcessService;
import com.bstek.uflo.service.TaskOpinion;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="uflo.form.completeTaskAndSaveFormDataAction")
public class CompleteTaskAndSaveFormDataAction
extends SaveFormDataAction {
    @Autowired
    @Qualifier(value="uflo.taskClient")
    private TaskClient taskClient;
    @Autowired
    @Qualifier(value="uflo.processService")
    private ProcessService processService;

    @Override
    public String getName() {
        return "\u4fdd\u5b58\u5e76\u5b8c\u6210\u4efb\u52a1";
    }

    @Override
    public String getIcon() {
        return "url(skin>common/icons.gif) -160px -20px";
    }

    @Override
    public void onViewInit(View view) {
    }

    @Override
    public void execute(FormData formData, Session session) {
        super.saveFormData(formData, session);
        long taskId = formData.getTaskId();
        Map<String, Object> processData = formData.getProcessData();
        this.taskClient.start(taskId);
        if (processData != null && processData.size() > 0) {
            TaskOpinion opinion;
            String taskOpinion = (String)processData.get("TASK_OPINION_");
            processData.remove("TASK_OPINION_");
            this.buildTaskVariables(processData, taskId, formData);
            HashMap<String, Object> variables = new HashMap<String, Object>();
            for (String key : processData.keySet()) {
                if (processData.get(key) == null) continue;
                variables.put(key, processData.get(key));
            }
            if (variables.size() > 0) {
                if (StringUtils.isEmpty((String)taskOpinion)) {
                    this.taskClient.complete(taskId, variables);
                } else {
                    opinion = new TaskOpinion(taskOpinion);
                    this.taskClient.complete(taskId, variables, opinion);
                }
            } else if (StringUtils.isEmpty((String)taskOpinion)) {
                this.taskClient.complete(taskId);
            } else {
                opinion = new TaskOpinion(taskOpinion);
                this.taskClient.complete(taskId, opinion);
            }
        } else {
            this.taskClient.complete(taskId);
        }
    }

    private void buildTaskVariables(Map<String, Object> variables, long taskId, FormData formData) {
        Task task = this.taskClient.getTask(taskId);
        ProcessDefinition process = this.processService.getProcessById(task.getProcessId());
        TaskNode taskNode = (TaskNode)process.getNode(task.getNodeName());
        List elements = taskNode.getFormElements();
        if (elements == null || elements.size() == 0) {
            return;
        }
        Map<String, Object> dataMap = formData.getMasterTable();
        block0: for (FormElement element : elements) {
            for (String fieldName : dataMap.keySet()) {
                if (!fieldName.equals(element.getName())) continue;
                variables.put(fieldName, dataMap.get(fieldName));
                continue block0;
            }
        }
    }

    @Override
    public String getClickScript(String actionId) {
        StringBuffer sb = new StringBuffer();
        sb.append("dorado.MessageBox.confirm(\"\u771f\u7684\u8981\u4fdd\u5b58\u6570\u636e\u5e76\u5b8c\u6210\u5f53\u524d\u4efb\u52a1\u5417\uff1f\",function(){\n");
        sb.append("view.id(\"" + actionId + "\").execute(function(){\n");
        sb.append("dorado.MessageBox.alert(\"\u64cd\u4f5c\u6210\u529f.\");\n");
        sb.append("if(window.parent && window.parent.closeProcessDialog){\n");
        sb.append("window.parent.closeProcessDialog(" + DoradoContext.getCurrent().getRequest().getParameter("type") + ");\n");
        sb.append("}\n");
        sb.append("});\n");
        sb.append("});\n");
        sb.append("");
        return sb.toString();
    }
}

