/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.designer.utils;

import com.bstek.uflo.designer.model.Shape;
import com.bstek.uflo.designer.model.TaskType;
import com.bstek.uflo.designer.model.node.Action;
import com.bstek.uflo.designer.model.node.Decision;
import com.bstek.uflo.designer.model.node.End;
import com.bstek.uflo.designer.model.node.Foreach;
import com.bstek.uflo.designer.model.node.Fork;
import com.bstek.uflo.designer.model.node.Join;
import com.bstek.uflo.designer.model.node.Node;
import com.bstek.uflo.designer.model.node.Start;
import com.bstek.uflo.designer.model.node.SubProcess;
import com.bstek.uflo.designer.model.node.Task;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapeUtils {
    public static String getShapeIcon(Shape shape) {
        if (shape instanceof Start) {
            return "start32.png";
        }
        if (shape instanceof End) {
            return ((End)shape).isTerminate() ? "end-terminate32.png" : "end32.png";
        }
        if (shape instanceof Decision) {
            return "decision32.png";
        }
        if (shape instanceof Fork) {
            return "fork32.png";
        }
        if (shape instanceof Join) {
            return "join32.png";
        }
        if (shape instanceof Foreach) {
            return "foreach32.png";
        }
        if (shape instanceof Task) {
            return ((Task)shape).getTaskType().equals(TaskType.Countersign.name()) ? "task-countersign32.png" : "task32.png";
        }
        if (shape instanceof Action) {
            return "action32.png";
        }
        if (shape instanceof SubProcess) {
            return "subprocess32.png";
        }
        return null;
    }

    public static String getShapeObjectId(Shape shape) {
        if (shape instanceof Start) {
            return "bpm.Start";
        }
        if (shape instanceof End) {
            return "bpm.End";
        }
        if (shape instanceof Task) {
            return "bpm.Task";
        }
        if (shape instanceof Action) {
            return "bpm.Action";
        }
        if (shape instanceof SubProcess) {
            return "bpm.SubProcess";
        }
        if (shape instanceof Decision) {
            return "bpm.Decision";
        }
        if (shape instanceof Fork) {
            return "bpm.Fork";
        }
        if (shape instanceof Join) {
            return "bpm.Join";
        }
        if (shape instanceof Foreach) {
            return "bpm.Foreach";
        }
        return null;
    }

    public static String getShapXmlName(Shape shape) {
        if (shape instanceof Start) {
            return "start";
        }
        if (shape instanceof End) {
            return "end";
        }
        if (shape instanceof Task) {
            return "task";
        }
        if (shape instanceof Action) {
            return "action";
        }
        if (shape instanceof SubProcess) {
            return "subprocess";
        }
        if (shape instanceof Decision) {
            return "decision";
        }
        if (shape instanceof Fork) {
            return "fork";
        }
        if (shape instanceof Join) {
            return "join";
        }
        if (shape instanceof Foreach) {
            return "foreach";
        }
        return null;
    }

    public static Node findNodeById(List<Node> nodes, String nodeId) {
        for (Node node : nodes) {
            if (!node.getId().equals(nodeId)) continue;
            return node;
        }
        return null;
    }

    public static Node findNodeByName(List<Node> nodes, String nodeName) {
        for (Node node : nodes) {
            if (!node.getName().equals(nodeName)) continue;
            return node;
        }
        return null;
    }
}

