/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.designer.serializer.impl;

import com.bstek.uflo.designer.model.AssignmentType;
import com.bstek.uflo.designer.model.CalendarInfo;
import com.bstek.uflo.designer.model.Shape;
import com.bstek.uflo.designer.model.TaskAssignee;
import com.bstek.uflo.designer.model.TaskType;
import com.bstek.uflo.designer.model.UserData;
import com.bstek.uflo.designer.model.node.Task;
import com.bstek.uflo.designer.serializer.impl.NodeSerializer;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.springframework.stereotype.Service;

@Service
public class TaskSerializer
extends NodeSerializer {
    public void serializerPrivateAttribute(Element taskElement, Shape shape) {
        List<UserData> userDataList;
        List<TaskAssignee> taskAssignees;
        String taskListenerBean;
        String url;
        Task task = (Task)shape;
        String taskName = task.getTaskName();
        if (StringUtils.isNotEmpty((String)taskName)) {
            taskElement.addAttribute("task-name", task.getTaskName());
        }
        if (StringUtils.isNotEmpty((String)(url = task.getUrl()))) {
            taskElement.addAttribute("url", task.getUrl());
        }
        if (StringUtils.isNotEmpty((String)(taskListenerBean = task.getTaskListenerBean()))) {
            taskElement.addAttribute("task-listener-bean", taskListenerBean);
        }
        String taskType = task.getTaskType();
        taskElement.addAttribute("task-type", taskType);
        if (taskType.equals(TaskType.Countersign.name())) {
            String counterSignType = task.getCounterSignType();
            if (counterSignType.equals("countersignMultiplicity")) {
                taskElement.addAttribute("countersign-multiplicity", String.valueOf(task.getCountersignMultiplicity()));
            } else if (counterSignType.equals("countersignPercentMultiplicity")) {
                taskElement.addAttribute("countersign-percent-multiplicity", String.valueOf(task.getCountersignPercentMultiplicity()));
            } else if (counterSignType.equals("countersignExpression")) {
                taskElement.addAttribute("countersign-expression", task.getCountersignExpression());
            } else if (counterSignType.equals("countersignHandler")) {
                taskElement.addAttribute("countersign-handler", task.getCountersignHandler());
            }
        }
        taskElement.addAttribute("allow-specify-assignee", String.valueOf(task.isAllowSpecifyAssignee()));
        String assignmentType = task.getAssignmentType();
        taskElement.addAttribute("assignment-type", assignmentType);
        if (assignmentType.equals(AssignmentType.Swimlane.name())) {
            taskElement.addAttribute("swimlane", task.getSwimlane());
        } else if (assignmentType.equals(AssignmentType.Expression.name())) {
            taskElement.addAttribute("expression", task.getExpression());
        } else if (assignmentType.equals(AssignmentType.Handler.name())) {
            taskElement.addAttribute("assignment-handler-bean", task.getAssignmentHandlerBean());
        } else if (assignmentType.equals(AssignmentType.Assignee.name()) && (taskAssignees = task.getTaskAssignees()) != null) {
            for (TaskAssignee taskAssignee : taskAssignees) {
                Element taskAssigneeElement = taskElement.addElement("assignee");
                taskAssigneeElement.addAttribute("id", taskAssignee.getId());
                taskAssigneeElement.addAttribute("name", taskAssignee.getName());
                taskAssigneeElement.addAttribute("provider-id", taskAssignee.getProviderId());
            }
        }
        if (task.isUseDue()) {
            String reminderHandlerBean;
            String reminderType;
            Element dueElement = taskElement.addElement("due");
            int dueDay = task.getDueDay();
            int dueDour = task.getDueDour();
            int dueMinute = task.getDueMinute();
            dueElement.addAttribute("day", String.valueOf(dueDay));
            dueElement.addAttribute("hour", String.valueOf(dueDour));
            dueElement.addAttribute("minute", String.valueOf(dueMinute));
            List<CalendarInfo> dueCalendarInfos = task.getDueCalendarInfos();
            if (dueCalendarInfos != null) {
                for (CalendarInfo calendarInfo : dueCalendarInfos) {
                    Element calendarInfoElement = dueElement.addElement("calendar-provider");
                    calendarInfoElement.addAttribute("id", calendarInfo.getId());
                    calendarInfoElement.addAttribute("name", calendarInfo.getName());
                }
            }
            if ((reminderType = task.getReminderType()).equals("once")) {
                Element onceElement = dueElement.addElement("once-reminder");
                reminderHandlerBean = task.getReminderHandlerBean();
                if (StringUtils.isNotEmpty((String)reminderHandlerBean)) {
                    onceElement.addAttribute("handler-bean", reminderHandlerBean);
                }
            } else if (reminderType.equals("period")) {
                Element periodElement = dueElement.addElement("period-reminder");
                reminderHandlerBean = task.getReminderHandlerBean();
                if (StringUtils.isNotEmpty((String)reminderHandlerBean)) {
                    periodElement.addAttribute("handler-bean", reminderHandlerBean);
                }
                int reminderRepeat = task.getReminderRepeat();
                periodElement.addAttribute("unit", task.getReminderDateUnit());
                periodElement.addAttribute("repeat", String.valueOf(reminderRepeat));
                List<CalendarInfo> reminderCalendarInfos = task.getReminderCalendarInfos();
                if (reminderCalendarInfos != null) {
                    for (CalendarInfo calendarInfo : reminderCalendarInfos) {
                        Element calendarInfoElement = periodElement.addElement("calendar-provider");
                        calendarInfoElement.addAttribute("id", calendarInfo.getId());
                        calendarInfoElement.addAttribute("name", calendarInfo.getName());
                    }
                }
            }
            if (task.isUseDueAction()) {
                List<CalendarInfo> dueActionCalendarInfos;
                Element dueActionElement = dueElement.addElement("due-action");
                int dueActionDay = task.getDueActionDay();
                int dueActionDour = task.getDueActionDour();
                int dueActionMinute = task.getDueActionMinute();
                String dueActionHandlerBean = task.getDueActionHandlerBean();
                dueActionElement.addAttribute("day", String.valueOf(dueActionDay));
                dueActionElement.addAttribute("hour", String.valueOf(dueActionDour));
                dueActionElement.addAttribute("minute", String.valueOf(dueActionMinute));
                if (StringUtils.isNotEmpty((String)dueActionHandlerBean)) {
                    dueActionElement.addAttribute("handler-bean", dueActionHandlerBean);
                }
                if ((dueActionCalendarInfos = task.getDueActionCalendarInfos()) != null) {
                    for (CalendarInfo calendarInfo : dueActionCalendarInfos) {
                        Element calendarInfoElement = dueActionElement.addElement("calendar-provider");
                        calendarInfoElement.addAttribute("id", calendarInfo.getId());
                        calendarInfoElement.addAttribute("name", calendarInfo.getName());
                    }
                }
            }
        }
        if ((userDataList = task.getUserData()) != null) {
            for (UserData userData : userDataList) {
                Element userDataElement = taskElement.addElement("user-data");
                userDataElement.addAttribute("value", userData.getValue());
                userDataElement.addAttribute("key", userData.getKey());
            }
        }
    }

    public boolean support(Shape shape) {
        return shape instanceof Task;
    }
}

