/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.designer.serializer.impl;

import com.bstek.uflo.designer.model.ComponentAuthority;
import com.bstek.uflo.designer.model.ConditionType;
import com.bstek.uflo.designer.model.FormElement;
import com.bstek.uflo.designer.model.Mapping;
import com.bstek.uflo.designer.model.Point;
import com.bstek.uflo.designer.model.Rectangle;
import com.bstek.uflo.designer.model.Shape;
import com.bstek.uflo.designer.model.edge.Connection;
import com.bstek.uflo.designer.model.node.Node;
import com.bstek.uflo.designer.model.node.RectNode;
import com.bstek.uflo.designer.model.node.Start;
import com.bstek.uflo.designer.model.node.Task;
import com.bstek.uflo.designer.serializer.ShapeSerializer;
import com.bstek.uflo.designer.utils.ShapeUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public abstract class NodeSerializer
implements ShapeSerializer {
    public void execute(Element parentElement, Shape shape) {
        Element currentElement = this.buildCurrentElement(parentElement, shape);
        this.serializerCommonAttribute(currentElement, shape);
        this.serializerPrivateAttribute(currentElement, shape);
        this.serializerFormElementAttribute(currentElement, shape);
    }

    public abstract void serializerPrivateAttribute(Element var1, Shape var2);

    protected void serializerCommonAttribute(Element currentElement, Shape shape) {
        String desc;
        String eventHandlerBean;
        String label;
        Node node = (Node)shape;
        currentElement.addAttribute("g", this.buildNodeGValue(node));
        String name = node.getName();
        if (StringUtils.isNotEmpty((String)name)) {
            currentElement.addAttribute("name", name);
        }
        if (StringUtils.isNotEmpty((String)(label = node.getLabel()))) {
            currentElement.addAttribute("label", label);
        }
        if (StringUtils.isNotEmpty((String)(eventHandlerBean = node.getEventHandlerBean()))) {
            currentElement.addAttribute("event-handler-bean", eventHandlerBean);
        }
        if (StringUtils.isNotEmpty((String)(desc = node.getDescription()))) {
            Element descriptionElement = currentElement.addElement("description");
            descriptionElement.addText(desc);
        }
        this.serializerSequenceFlowAttribute(currentElement, node);
        this.serializerComponentAuthorityAttribute(currentElement, node);
    }

    private void serializerSequenceFlowAttribute(Element currentElement, Node node) {
        List<Connection> connecitons = node.getOutConnections();
        if (connecitons != null) {
            for (Connection conn : connecitons) {
                Element connectionElement = currentElement.addElement("sequence-flow");
                connectionElement.addAttribute("name", conn.getName());
                connectionElement.addAttribute("to", conn.getToNode().getName());
                String conditionType = conn.getConditionType();
                if (StringUtils.isNotEmpty((String)conditionType)) {
                    if (conditionType.equals(ConditionType.Expression.name())) {
                        connectionElement.addAttribute("condition-type", conn.getConditionType());
                        connectionElement.addAttribute("expression", conn.getExpression());
                    } else if (conditionType.equals(ConditionType.Handler.name())) {
                        connectionElement.addAttribute("condition-type", conn.getConditionType());
                        connectionElement.addAttribute("handler-bean", conn.getHandlerBean());
                    }
                }
                connectionElement.addAttribute("g", this.buildConnectionGValue(conn));
            }
        }
    }

    private void serializerComponentAuthorityAttribute(Element currentElement, Node node) {
        List<ComponentAuthority> componentAuthorities = null;
        if (node instanceof Task) {
            componentAuthorities = ((Task)node).getComponentAuthorities();
        } else if (node instanceof Start) {
            componentAuthorities = ((Start)node).getComponentAuthorities();
        }
        if (componentAuthorities != null) {
            for (ComponentAuthority componentAuthority : componentAuthorities) {
                Element componentAuthorityElement = currentElement.addElement("component-authority");
                componentAuthorityElement.addAttribute("authority", componentAuthority.getAuthority());
                componentAuthorityElement.addAttribute("component", componentAuthority.getComponent());
            }
        }
    }

    private String buildNodeGValue(Node node) {
        Rectangle rectangle = node.getRectangle();
        int x = rectangle.getPoint().getX();
        int y = rectangle.getPoint().getY();
        int width = rectangle.getWidth();
        int height = rectangle.getHeight();
        x -= 50;
        y -= 25;
        if (node instanceof RectNode) {
            height += 15;
        } else {
            y -= 5;
            x += 40;
            height += 30;
            width += 8;
        }
        return String.valueOf(x) + "," + y + "," + width + "," + height;
    }

    private String buildConnectionGValue(Connection conn) {
        List<Point> points = conn.getVertices();
        points.remove(0);
        points.remove(points.size() - 1);
        ArrayList<String> pointString = new ArrayList<String>();
        for (Point point : points) {
            int pointX = point.getX() + 10;
            int pointY = point.getY();
            pointString.add(String.valueOf(pointX) + "," + pointY);
        }
        String value = String.valueOf(StringUtils.join(pointString, (String)";")) + ":-40,-9";
        return value;
    }

    protected void serializerFormElementAttribute(Element currentElement, Shape shape) {
        String formTemplate = null;
        List<FormElement> formElements = null;
        if (shape instanceof Start) {
            formTemplate = ((Start)shape).getFormTemplate();
            formElements = ((Start)shape).getFormElements();
        } else if (shape instanceof Task) {
            formTemplate = ((Task)shape).getFormTemplate();
            formElements = ((Task)shape).getFormElements();
        }
        if (StringUtils.isNotEmpty((String)formTemplate)) {
            currentElement.addAttribute("form-template", formTemplate);
        }
        if (formElements != null) {
            for (FormElement formElement : formElements) {
                List<Mapping> mappings;
                String authority;
                String editorType;
                String dataType;
                String caption;
                Element formElementElement = currentElement.addElement("form-element");
                String name = formElement.getName();
                if (StringUtils.isNotEmpty((String)name)) {
                    formElementElement.addAttribute("name", name);
                }
                if (StringUtils.isNotEmpty((String)(caption = formElement.getCaption()))) {
                    formElementElement.addAttribute("caption", caption);
                }
                if (StringUtils.isNotEmpty((String)(dataType = formElement.getDataType()))) {
                    formElementElement.addAttribute("data-type", dataType);
                }
                if (StringUtils.isNotEmpty((String)(editorType = formElement.getEditorType()))) {
                    formElementElement.addAttribute("editor-type", editorType);
                }
                if (StringUtils.isNotEmpty((String)(authority = formElement.getAuthority()))) {
                    formElementElement.addAttribute("authority", authority);
                }
                formElementElement.addAttribute("required", String.valueOf(formElement.isRequired()));
                String defaultValue = formElement.getDefaultValue();
                if (StringUtils.isNotEmpty((String)defaultValue)) {
                    formElementElement.addAttribute("default-value", defaultValue);
                }
                if ((mappings = formElement.getMappings()) == null) continue;
                for (Mapping mapping : mappings) {
                    Element mappingElement = formElementElement.addElement("mapping");
                    mappingElement.addAttribute("key", mapping.getKey());
                    mappingElement.addAttribute("label", mapping.getLabel());
                }
            }
        }
    }

    private Element buildCurrentElement(Element parentElement, Shape shape) {
        String nodeName = ShapeUtils.getShapXmlName(shape);
        Element element = parentElement.addElement(nodeName);
        return element;
    }

    public boolean support(Shape shape) {
        return shape instanceof Node;
    }
}

