/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.designer.deserializer.impl;

import com.bstek.uflo.designer.deserializer.ProcessDeserializer;
import com.bstek.uflo.designer.deserializer.ShapeDeserializer;
import com.bstek.uflo.designer.model.AssignmentType;
import com.bstek.uflo.designer.model.Shape;
import com.bstek.uflo.designer.model.SwimlaneAssignee;
import com.bstek.uflo.designer.model.node.Node;
import com.bstek.uflo.designer.model.process.Process;
import com.bstek.uflo.designer.model.process.Swimlane;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="uflo.designer.processDeserializer")
public class DefaultProcessDeserializer
implements ProcessDeserializer,
ApplicationContextAware {
    private Collection<ShapeDeserializer> shapeDeserializerColl;

    public Process execute(Document document) throws Exception {
        Assert.notNull((Object)document);
        Element rootElement = document.getRootElement();
        Process process = new Process();
        this.deserializerCommonAttribute(process, rootElement);
        this.deserializerSwimlane(process, rootElement);
        this.deserializerNode(process, rootElement);
        return process;
    }

    private void deserializerCommonAttribute(Process process, Element rootElement) {
        Element descriptionElement;
        String name = rootElement.attributeValue("name");
        String key = rootElement.attributeValue("key");
        String startProcessUrl = rootElement.attributeValue("start-process-url");
        String eventHandlerBean = rootElement.attributeValue("event-handler-bean");
        String categoryId = rootElement.attributeValue("category-id");
        String effectDate = rootElement.attributeValue("effect-date");
        process.setName(name);
        process.setKey(key);
        process.setStartProcessUrl(startProcessUrl);
        process.setEventHandlerBean(eventHandlerBean);
        process.setCategoryId(categoryId);
        if (StringUtils.isNotEmpty((String)effectDate)) {
            try {
                process.setEffectDate(DateUtils.parseDate((String)effectDate, (String[])new String[]{"yyyy-MM-dd HH:mm:ss"}));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if ((descriptionElement = rootElement.element("description")) != null) {
            String desc = descriptionElement.getText();
            process.setDescription(desc);
        }
    }

    private void deserializerSwimlane(Process process, Element rootElement) {
        List swimlaneElements = rootElement.elements("swimlane");
        for (Object swimlaneObj : swimlaneElements) {
            Element swimlaneElement = (Element)swimlaneObj;
            String swimlaneName = swimlaneElement.attributeValue("name");
            String assignmentType = swimlaneElement.attributeValue("assignment-type");
            Swimlane swimlane = new Swimlane();
            swimlane.setName(swimlaneName);
            swimlane.setAssignmentType(assignmentType);
            if (assignmentType.equals(AssignmentType.Expression.name())) {
                String expression = swimlaneElement.attributeValue("expression");
                swimlane.setExpression(expression);
            } else if (assignmentType.equals(AssignmentType.Handler.name())) {
                String assignmentHandlerBean = swimlaneElement.attributeValue("assignment-handler-bean");
                swimlane.setAssignmentHandlerBean(assignmentHandlerBean);
            } else if (assignmentType.equals(AssignmentType.Assignee.name())) {
                List assigneeElements = swimlaneElement.elements("assignee");
                for (Object assigneeObj : assigneeElements) {
                    Element assigneeElement = (Element)assigneeObj;
                    SwimlaneAssignee swimlaneAssignee = new SwimlaneAssignee();
                    swimlaneAssignee.setId(assigneeElement.attributeValue("id"));
                    swimlaneAssignee.setName(assigneeElement.attributeValue("name"));
                    swimlaneAssignee.setProviderId(assigneeElement.attributeValue("provider-id"));
                    swimlane.getSwimlaneAssignees().add(swimlaneAssignee);
                }
            }
            process.getSwimlanes().add(swimlane);
        }
    }

    private void deserializerNode(Process process, Element rootElement) throws Exception {
        for (Object obj : rootElement.elements()) {
            Element element = (Element)obj;
            for (ShapeDeserializer shapeDeserializer : this.shapeDeserializerColl) {
                Shape childShape;
                if (!shapeDeserializer.support(element.getName()) || !((childShape = shapeDeserializer.execute(element)) instanceof Node)) continue;
                process.getNodes().add((Node)childShape);
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.shapeDeserializerColl = applicationContext.getBeansOfType(ShapeDeserializer.class).values();
    }
}

