/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.designer.convert.impl;

import com.bstek.uflo.command.Command;
import com.bstek.uflo.command.CommandService;
import com.bstek.uflo.designer.command.QueryProcessBlobCommand;
import com.bstek.uflo.designer.convert.ConvertService;
import com.bstek.uflo.designer.deserializer.ProcessDeserializer;
import com.bstek.uflo.designer.graph.GraphService;
import com.bstek.uflo.designer.model.process.Process;
import com.bstek.uflo.designer.security.model.ProcessEntry;
import com.bstek.uflo.designer.security.service.SecurityService;
import com.bstek.uflo.designer.serializer.ProcessSerializer;
import com.bstek.uflo.designer.utils.FileUtils;
import com.bstek.uflo.model.Blob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="uflo.designer.convertService")
public class ConvertServiceImpl
implements ConvertService {
    @Autowired
    @Qualifier(value="uflo.designer.processSerializer")
    private ProcessSerializer processSerializer;
    @Autowired
    @Qualifier(value="uflo.designer.processDeserializer")
    private ProcessDeserializer processDeserializer;
    @Autowired
    @Qualifier(value="uflo.designer.graphService")
    private GraphService graphService;
    @Autowired
    @Qualifier(value="uflo.designer.SecurityService")
    private SecurityService securityService;
    @Autowired
    @Qualifier(value="uflo.commandService")
    private CommandService commandService;

    public Process graphToModel(String graphData) throws Exception {
        Document doc = DocumentHelper.parseText((String)graphData);
        Process process = this.graphService.serializer(doc);
        return process;
    }

    public File modelToUflo(Process process) throws Exception {
        Document document = this.processSerializer.execute(process);
        String tempFileName = String.valueOf(UUID.randomUUID().toString()) + ".uflo.xml";
        File file = new File(FileUtils.getTempDirectory(), tempFileName);
        FileOutputStream out = new FileOutputStream(file);
        OutputFormat outputFormat = OutputFormat.createPrettyPrint();
        XMLWriter xmlWriter = new XMLWriter((OutputStream)out, outputFormat);
        try {
            xmlWriter.write(document);
        }
        finally {
            out.close();
            xmlWriter.close();
        }
        return file;
    }

    public Process ufloToModel(String ufloXmlData) throws Exception {
        Document document = DocumentHelper.parseText((String)ufloXmlData);
        return this.processDeserializer.execute(document);
    }

    public Process ufloToModel(String ufloXmlData, long processId) throws Exception {
        Process process = this.ufloToModel(ufloXmlData);
        String username = this.securityService.getLoginUsername();
        ProcessEntry processEntry = null;
        if (StringUtils.isNotEmpty((String)username)) {
            processEntry = this.securityService.checkProcessSecurity(processId, username);
        }
        process.setProcessEntry(processEntry);
        return process;
    }

    public String modelToGraph(Process process) throws Exception {
        Document document = this.graphService.deserializer(process);
        String tempFileName = String.valueOf(UUID.randomUUID().toString()) + ".xml";
        OutputFormat outputFormat = OutputFormat.createCompactFormat();
        XMLWriter xmlWriter = null;
        FileOutputStream out = null;
        FileInputStream input = null;
        try {
            String graphXmlData;
            out = new FileOutputStream(new File(FileUtils.getTempDirectory(), tempFileName));
            xmlWriter = new XMLWriter((OutputStream)out, outputFormat);
            xmlWriter.write(document);
            input = new FileInputStream(new File(FileUtils.getTempDirectory(), tempFileName));
            String string = graphXmlData = IOUtils.toString((InputStream)input, (String)"UTF-8");
            return string;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (xmlWriter != null) {
                xmlWriter.close();
            }
            if (input != null) {
                input.close();
            }
        }
    }

    public String findProcessDefinitionXml(long processId) throws Exception {
        Blob blob = (Blob)this.commandService.executeCommand((Command)new QueryProcessBlobCommand(processId));
        if (blob == null) {
            throw new IllegalArgumentException("\u5a34\u4f7a\u25bcid[" + processId + "]\u6d93\u5d85\u608e\u5a09\ufffd,\u6d93\u5d85\u74e8\u9366\u3126\ue11d\u5a34\u4f7a\u25bc\u951b\ufffd");
        }
        byte[] blobValue = blob.getBlobValue();
        String ufloXmlData = new String(blobValue, "UTF-8");
        return ufloXmlData;
    }
}

